/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.sanitizers;

import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersKind;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersSettings;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SanitizersConfigurable
implements SearchableConfigurable {
    private boolean myUseVisualRepresentation;
    private final Map<SanitizersKind, RawCommandLineEditor> mySanitizersFlags = new TreeMap<SanitizersKind, RawCommandLineEditor>();

    public SanitizersConfigurable() {
        for (SanitizersKind sanitizer : SanitizersKind.values()) {
            this.mySanitizersFlags.put(sanitizer, new RawCommandLineEditor());
        }
        this.reset();
    }

    @NotNull
    public String getId() {
        return "dynamic.analysis.tools.sanitizers";
    }

    @Nls
    public String getDisplayName() {
        return CLionProfilingBundle.message("dynamic.analysis.tools.sanitizers.configurable.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "Google_Sanitizers";
    }

    @Nullable
    public JComponent createComponent() {
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.createCommonOptions(), bag.nextLine());
        panel2.add((Component)this.createSanitizersFlags(), bag.nextLine().insetTop(20).weighty(1.0));
        return panel2;
    }

    @NotNull
    private JComponent createSanitizersFlags() {
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(0.0).setDefaultWeightY(0.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CLionProfilingBundle.message("sanitizers.runtime.flags.border.title", new Object[0]), (boolean)false));
        panel2.add((Component)new JBLabel(CLionProfilingBundle.message("sanitizers.runtime.flags.hint", new Object[0]), UIUtil.ComponentStyle.SMALL), bag.nextLine().coverLine(2).insetBottom(2));
        panel2.add((Component)new JBLabel(CLionProfilingBundle.message("sanitizers.runtime.flags.hint.note", new Object[0]), UIUtil.ComponentStyle.SMALL), bag.nextLine().coverLine(2).insetBottom(5));
        panel2.add((Component)this.createImportButton(), bag.nextLine().coverLine(2).anchor(17).fillCellNone().insetBottom(15));
        for (Map.Entry<SanitizersKind, RawCommandLineEditor> sanitizerFlags : this.mySanitizersFlags.entrySet()) {
            panel2.add((Component)new JBLabel(sanitizerFlags.getKey().getPresentableName()), bag.nextLine().fillCellVertically().setColumn(0).insetRight(10));
            panel2.add((Component)sanitizerFlags.getValue(), bag.next().insetBottom(5).weightx(1.0));
        }
        panel2.add((Component)new JSeparator(), bag.nextLine().coverLine(2).weightx(1.0).insetTop(10));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            SanitizersConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private JButton createImportButton() {
        JButton button = new JButton(CLionProfilingBundle.message("sanitizers.import.flags.button", new Object[0]));
        boolean isEnabled = Arrays.stream(SanitizersKind.values()).anyMatch(sanitizer -> StringUtil.isNotEmpty((String)EnvironmentUtil.getValue((String)sanitizer.getOptionsName())));
        button.setEnabled(isEnabled);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SanitizersKind sanitizer : SanitizersKind.values()) {
                    String environmentValue = EnvironmentUtil.getValue((String)sanitizer.getOptionsName());
                    if (!StringUtil.isNotEmpty((String)environmentValue)) continue;
                    SanitizersConfigurable.this.mySanitizersFlags.get((Object)sanitizer).setText(environmentValue);
                }
            }
        });
        return button;
    }

    @NotNull
    private JPanel createCommonOptions() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        final JBCheckBox checkBox = new JBCheckBox(CLionProfilingBundle.message("sanitizers.use.visual.representation.checkbox", new Object[0]), this.myUseVisualRepresentation);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SanitizersConfigurable.this.myUseVisualRepresentation = checkBox.isSelected();
            }
        });
        builder.addComponent((JComponent)checkBox);
        builder.addComponent((JComponent)new JBLabel(CLionProfilingBundle.message("sanitizers.compiler.min.version.supported", SanitizersUtil.MIN_CLANG_VERSION.toString(), SanitizersUtil.MIN_GCC_VERSION.toString()), UIUtil.ComponentStyle.SMALL));
        JPanel jPanel = builder.getPanel();
        if (jPanel == null) {
            SanitizersConfigurable.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public boolean isModified() {
        SanitizersSettings settings = SanitizersSettings.getInstance();
        return this.myUseVisualRepresentation != settings.isUseVisualRepresentation() || !SanitizersConfigurable.areEqual(SanitizersConfigurable.toStringMap(this.mySanitizersFlags), settings.getSanitizersFlags());
    }

    public void apply() {
        SanitizersSettings settings = SanitizersSettings.getInstance();
        settings.setUseVisualRepresentation(this.myUseVisualRepresentation);
        settings.setSanitizersFlags(SanitizersConfigurable.toStringMap(this.mySanitizersFlags));
    }

    public void reset() {
        SanitizersSettings settings = SanitizersSettings.getInstance();
        this.myUseVisualRepresentation = settings.isUseVisualRepresentation();
        for (Map.Entry<SanitizersKind, String> sanitizerFlags : settings.getSanitizersFlags().entrySet()) {
            RawCommandLineEditor editor = this.mySanitizersFlags.get((Object)sanitizerFlags.getKey());
            SanitizersConfigurable.resetFlagsEditor(sanitizerFlags.getKey(), sanitizerFlags.getValue(), editor);
        }
    }

    private static void resetFlagsEditor(@NotNull SanitizersKind sanitizer, @NotNull String flags, @NotNull RawCommandLineEditor editor) {
        if (sanitizer == null) {
            SanitizersConfigurable.$$$reportNull$$$0(2);
        }
        if (flags == null) {
            SanitizersConfigurable.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            SanitizersConfigurable.$$$reportNull$$$0(4);
        }
        editor.setText(flags);
        if (editor.getTextField() instanceof JBTextField) {
            JBTextField textField = (JBTextField)editor.getTextField();
            textField.getEmptyText().setText(sanitizer.getOptionsName());
        }
    }

    private static boolean areEqual(@NotNull Map<SanitizersKind, String> left, @NotNull Map<SanitizersKind, String> right) {
        if (left == null) {
            SanitizersConfigurable.$$$reportNull$$$0(5);
        }
        if (right == null) {
            SanitizersConfigurable.$$$reportNull$$$0(6);
        }
        if (left.size() != right.size()) {
            return false;
        }
        for (Map.Entry<SanitizersKind, String> leftPair : left.entrySet()) {
            String rightValue = right.get((Object)leftPair.getKey());
            if (leftPair.getValue().equals(rightValue)) continue;
            return false;
        }
        return true;
    }

    private static Map<SanitizersKind, String> toStringMap(@NotNull Map<SanitizersKind, RawCommandLineEditor> sourceMap) {
        if (sourceMap == null) {
            SanitizersConfigurable.$$$reportNull$$$0(7);
        }
        return sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RawCommandLineEditor)e.getValue()).getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSanitizersFlags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommonOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetFlagsEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toStringMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

