/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.sanitizers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersKind;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SanitizersSettings", storages={@Storage(value="other.xml")})
public class SanitizersSettings
implements PersistentStateComponent<SanitizersSettings> {
    private boolean myUseVisualRepresentation = true;
    private Map<SanitizersKind, String> mySanitizersFlags = new HashMap<SanitizersKind, String>();

    public SanitizersSettings() {
        for (SanitizersKind sanitizer : SanitizersKind.values()) {
            this.mySanitizersFlags.put(sanitizer, SanitizersSettings.getDefaultFlags(sanitizer));
        }
    }

    public boolean isUseVisualRepresentation() {
        return this.myUseVisualRepresentation;
    }

    public void setUseVisualRepresentation(boolean useVisualRepresentation) {
        this.myUseVisualRepresentation = useVisualRepresentation;
    }

    public Map<SanitizersKind, String> getSanitizersFlags() {
        return this.mySanitizersFlags;
    }

    public void setSanitizersFlags(Map<SanitizersKind, String> sanitizersFlags) {
        this.mySanitizersFlags = new HashMap<SanitizersKind, String>(sanitizersFlags);
    }

    @Nullable
    public SanitizersSettings getState() {
        return this;
    }

    public void loadState(@NotNull SanitizersSettings state) {
        if (state == null) {
            SanitizersSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public static SanitizersSettings getInstance() {
        SanitizersSettings sanitizersSettings = (SanitizersSettings)ApplicationManager.getApplication().getService(SanitizersSettings.class);
        if (sanitizersSettings == null) {
            SanitizersSettings.$$$reportNull$$$0(1);
        }
        return sanitizersSettings;
    }

    private static String getDefaultFlags(@NotNull SanitizersKind sanitizer) {
        if (sanitizer == null) {
            SanitizersSettings.$$$reportNull$$$0(2);
        }
        if (sanitizer == SanitizersKind.ADDRESS_SANITIZER) {
            return "detect_stack_use_after_return=false";
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFlags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

