/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.valgrind.ValgrindSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValgrindConfigurable
implements SearchableConfigurable {
    private final ValgrindSettings mySettings = ValgrindSettings.getInstance();
    private JBTextField myValgrindPathTextField;
    private final RawCommandLineEditor myCommandLineEditor = new RawCommandLineEditor();
    private DefaultListModel<String> mySuppressionListModel;
    private List<String> mySuppressionFiles = new ArrayList<String>(this.mySettings.getSuppressionFiles());

    @NotNull
    public String getId() {
        return "dynamic.analysis.tools.valgrind";
    }

    @Nls
    public String getDisplayName() {
        return CLionProfilingBundle.message("dynamic.analysis.tools.valgrind.configurable.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JBLabel label = new JBLabel(CLionProfilingBundle.message("valgrind.configurable.executable.label", new Object[0]));
        panel2.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myValgrindPathTextField = new JBTextField(this.mySettings.getValgrindPath(), 30);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)this.myValgrindPathTextField, CLionProfilingBundle.message("valgrind.configurable.executable.dialog.title", new Object[0]), "", descriptor);
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton((JTextField)this.myValgrindPathTextField, (ActionListener)browseFilesListener);
        panel2.add((Component)textFieldWithBrowseButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)this.createMemcheckSettings(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    public boolean isModified() {
        return !this.myValgrindPathTextField.getText().equals(this.mySettings.getValgrindPath()) || !this.myCommandLineEditor.getText().equals(this.mySettings.getAnalysisOptions()) || !this.mySuppressionFiles.equals(this.mySettings.getSuppressionFiles());
    }

    public void apply() throws ConfigurationException {
        this.mySettings.setValgrindPath(this.myValgrindPathTextField.getText());
        this.mySettings.setAnalysisOptions(this.myCommandLineEditor.getText());
        this.mySettings.setSuppressionFiles(this.mySuppressionFiles);
    }

    public void reset() {
        this.myValgrindPathTextField.setText(this.mySettings.getValgrindPath());
        this.myCommandLineEditor.setText(this.mySettings.getAnalysisOptions());
        this.mySuppressionFiles = new ArrayList<String>(this.mySettings.getSuppressionFiles());
        this.resetSuppressionFilesModel();
    }

    private JPanel createMemcheckSettings() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CLionProfilingBundle.message("dynamic.analysis.tools.memcheck.border.title", new Object[0]), (boolean)false));
        panel2.add((Component)new JLabel(CLionProfilingBundle.message("valgrind.confugurable.analysisOptions.label", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)this.myCommandLineEditor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JBLabel hintTitle = new JBLabel(CLionProfilingBundle.message("valgrind.configurable.arguments.hint", new Object[0]), UIUtil.ComponentStyle.SMALL);
        JBLabel hintArguments = new JBLabel(CLionProfilingBundle.message("valgrind.argument.hint", new Object[0]), UIUtil.ComponentStyle.SMALL);
        panel2.add((Component)hintTitle, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel2.add((Component)hintArguments, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel suppressionFilesPanel = this.createSuppressionFilesPanel();
        panel2.add((Component)suppressionFilesPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)25, (int)0, (int)0, (int)0), 0, 0));
        return panel2;
    }

    private JPanel createSuppressionFilesPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.mySuppressionListModel = new DefaultListModel();
        for (String suppressionFile : this.mySuppressionFiles) {
            this.mySuppressionListModel.addElement(suppressionFile);
        }
        final JBList suppressionFilesList = new JBList(this.mySuppressionListModel);
        suppressionFilesList.getEmptyText().setText(CLionProfilingBundle.message("valgrind.configurable.no.suppression.files", new Object[0]));
        suppressionFilesList.setSelectionMode(0);
        suppressionFilesList.setVisibleRowCount(5);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)suppressionFilesList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null, files -> {
                    @NlsSafe String filePath = ((VirtualFile)files.get(0)).getPath();
                    ValgrindConfigurable.this.mySuppressionListModel.addElement(filePath);
                    ValgrindConfigurable.this.mySuppressionFiles.add(filePath);
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedIndex = suppressionFilesList.getSelectedIndex();
                ValgrindConfigurable.this.mySuppressionListModel.remove(selectedIndex);
                ValgrindConfigurable.this.mySuppressionFiles.remove(selectedIndex);
            }
        }).setButtonComparator(new String[]{CommonActionsPanel.Buttons.ADD.getText(), CommonActionsPanel.Buttons.REMOVE.getText()});
        decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
        panel2.add((Component)new JLabel(CLionProfilingBundle.message("valgrind.configurable.add.suppression.files.label", new Object[0])), "North");
        panel2.add((Component)decorator.createPanel(), "Center");
        return panel2;
    }

    private void resetSuppressionFilesModel() {
        this.mySuppressionListModel.removeAllElements();
        for (String suppressionFile : this.mySuppressionFiles) {
            this.mySuppressionListModel.addElement(suppressionFile);
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "Valgrind";
    }
}

