/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageModel;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "", "filePath", "", "lines", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "(Ljava/lang/String;Ljava/util/List;)V", "getFilePath", "()Ljava/lang/String;", "getLines", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "GCovBlockModel", "GCovBranchModel", "GCovLineModel", "intellij.cidr.coverage"})
public final class GCovCoverageModel {
    @NotNull
    private final String filePath;
    @NotNull
    private final List<GCovLineModel> lines;
    private static final String HITS_PATTERN = "#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+";
    private static final Regex PREAMBLE_REGEX;
    private static final Regex LINE_EXECUTION_REGEX;
    private static final Regex BLOCK_REGEX;
    private static final Regex BRANCH_TAKEN_REGEX;
    private static final Regex BRANCH_NEVER_EXECUTED_REGEX;
    private static final Regex TEMPLATE_SPECIALIZATION_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final List<GCovLineModel> getLines() {
        return this.lines;
    }

    public GCovCoverageModel(@NotNull String filePath, @NotNull List<GCovLineModel> lines) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.filePath = filePath;
        this.lines = lines;
    }

    static {
        Companion = new Companion(null);
        PREAMBLE_REGEX = new Regex("-:\\s*0:(.+?):(.+)");
        LINE_EXECUTION_REGEX = new Regex("(#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+)\\*?:\\s*([0-9]+):(.*)");
        BLOCK_REGEX = new Regex("(#####|=====|\\$\\$\\$\\$\\$|%%%%%|-|[0-9]+):\\s*([0-9]+)-block\\s+([0-9]+)");
        BRANCH_TAKEN_REGEX = new Regex("branch\\s+([0-9]+)\\s+taken\\s+([0-9]+)(.*)");
        BRANCH_NEVER_EXECUTED_REGEX = new Regex("branch\\s+([0-9]+)\\s+never executed");
        TEMPLATE_SPECIALIZATION_REGEX = new Regex("------------------|.*:");
    }

    @NotNull
    public final String component1() {
        return this.filePath;
    }

    @NotNull
    public final List<GCovLineModel> component2() {
        return this.lines;
    }

    @NotNull
    public final GCovCoverageModel copy(@NotNull String filePath, @NotNull List<GCovLineModel> lines) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        return new GCovCoverageModel(filePath, lines);
    }

    public static /* synthetic */ GCovCoverageModel copy$default(GCovCoverageModel gCovCoverageModel, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = gCovCoverageModel.filePath;
        }
        if ((n & 2) != 0) {
            list = gCovCoverageModel.lines;
        }
        return gCovCoverageModel.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "GCovCoverageModel(filePath=" + this.filePath + ", lines=" + this.lines + ")";
    }

    public int hashCode() {
        String string = this.filePath;
        List<GCovLineModel> list = this.lines;
        return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GCovCoverageModel)) break block3;
                GCovCoverageModel gCovCoverageModel = (GCovCoverageModel)object;
                if (!Intrinsics.areEqual((Object)this.filePath, (Object)gCovCoverageModel.filePath) || !Intrinsics.areEqual(this.lines, gCovCoverageModel.lines)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "", "lineIndex", "", "totalHits", "(II)V", "blocks", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "getBlocks", "()Ljava/util/List;", "getLineIndex", "()I", "getTotalHits", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovLineModel {
        @NotNull
        private final List<GCovBlockModel> blocks;
        private final int lineIndex;
        private final int totalHits;

        @NotNull
        public final List<GCovBlockModel> getBlocks() {
            return this.blocks;
        }

        public final int getLineIndex() {
            return this.lineIndex;
        }

        public final int getTotalHits() {
            return this.totalHits;
        }

        public GCovLineModel(int lineIndex, int totalHits) {
            this.lineIndex = lineIndex;
            this.totalHits = totalHits;
            boolean bl = false;
            this.blocks = new ArrayList();
        }

        public final int component1() {
            return this.lineIndex;
        }

        public final int component2() {
            return this.totalHits;
        }

        @NotNull
        public final GCovLineModel copy(int lineIndex, int totalHits) {
            return new GCovLineModel(lineIndex, totalHits);
        }

        public static /* synthetic */ GCovLineModel copy$default(GCovLineModel gCovLineModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovLineModel.lineIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovLineModel.totalHits;
            }
            return gCovLineModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovLineModel(lineIndex=" + this.lineIndex + ", totalHits=" + this.totalHits + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.lineIndex) * 31 + Integer.hashCode(this.totalHits);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GCovLineModel)) break block3;
                    GCovLineModel gCovLineModel = (GCovLineModel)object;
                    if (this.lineIndex != gCovLineModel.lineIndex || this.totalHits != gCovLineModel.totalHits) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "", "blockIndex", "", "hits", "(II)V", "getBlockIndex", "()I", "branches", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBranchModel;", "getBranches", "()Ljava/util/List;", "getHits", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovBlockModel {
        @NotNull
        private final List<GCovBranchModel> branches;
        private final int blockIndex;
        private final int hits;

        @NotNull
        public final List<GCovBranchModel> getBranches() {
            return this.branches;
        }

        public final int getBlockIndex() {
            return this.blockIndex;
        }

        public final int getHits() {
            return this.hits;
        }

        public GCovBlockModel(int blockIndex, int hits) {
            this.blockIndex = blockIndex;
            this.hits = hits;
            boolean bl = false;
            this.branches = new ArrayList();
        }

        public final int component1() {
            return this.blockIndex;
        }

        public final int component2() {
            return this.hits;
        }

        @NotNull
        public final GCovBlockModel copy(int blockIndex, int hits) {
            return new GCovBlockModel(blockIndex, hits);
        }

        public static /* synthetic */ GCovBlockModel copy$default(GCovBlockModel gCovBlockModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovBlockModel.blockIndex;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovBlockModel.hits;
            }
            return gCovBlockModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovBlockModel(blockIndex=" + this.blockIndex + ", hits=" + this.hits + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.blockIndex) * 31 + Integer.hashCode(this.hits);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GCovBlockModel)) break block3;
                    GCovBlockModel gCovBlockModel = (GCovBlockModel)object;
                    if (this.blockIndex != gCovBlockModel.blockIndex || this.hits != gCovBlockModel.hits) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBranchModel;", "", "branchNumber", "", "taken", "(II)V", "getBranchNumber", "()I", "getTaken", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class GCovBranchModel {
        private final int branchNumber;
        private final int taken;

        public final int getBranchNumber() {
            return this.branchNumber;
        }

        public final int getTaken() {
            return this.taken;
        }

        public GCovBranchModel(int branchNumber, int taken) {
            this.branchNumber = branchNumber;
            this.taken = taken;
        }

        public final int component1() {
            return this.branchNumber;
        }

        public final int component2() {
            return this.taken;
        }

        @NotNull
        public final GCovBranchModel copy(int branchNumber, int taken) {
            return new GCovBranchModel(branchNumber, taken);
        }

        public static /* synthetic */ GCovBranchModel copy$default(GCovBranchModel gCovBranchModel, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = gCovBranchModel.branchNumber;
            }
            if ((n3 & 2) != 0) {
                n2 = gCovBranchModel.taken;
            }
            return gCovBranchModel.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "GCovBranchModel(branchNumber=" + this.branchNumber + ", taken=" + this.taken + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.branchNumber) * 31 + Integer.hashCode(this.taken);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GCovBranchModel)) break block3;
                    GCovBranchModel gCovBranchModel = (GCovBranchModel)object;
                    if (this.branchNumber != gCovBranchModel.branchNumber || this.taken != gCovBranchModel.taken) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$Companion;", "", "()V", "BLOCK_REGEX", "Lkotlin/text/Regex;", "BRANCH_NEVER_EXECUTED_REGEX", "BRANCH_TAKEN_REGEX", "HITS_PATTERN", "", "LINE_EXECUTION_REGEX", "PREAMBLE_REGEX", "TEMPLATE_SPECIALIZATION_REGEX", "getFilePath", "tagValue", "workingDirectory", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getHits", "", "hitsText", "getOrCreateNearestBlock", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovBlockModel;", "lineModels", "Ljava/util/ArrayList;", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel$GCovLineModel;", "Lkotlin/collections/ArrayList;", "loadFrom", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "path", "Ljava/nio/file/Path;", "intellij.cidr.coverage"})
    public static final class Companion {
        @NotNull
        public final GCovCoverageModel loadFrom(@NotNull Path path, @Nullable File workingDirectory, @NotNull CidrToolEnvironment environment2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            String filePath = "";
            ArrayList<GCovLineModel> lineModels = new ArrayList<GCovLineModel>();
            Stream textLines2 = Files.lines(path).map(loadFrom.textLines.1.INSTANCE);
            Iterator iterator = textLines2.iterator();
            while (iterator.hasNext()) {
                Application application;
                boolean bl;
                String string;
                String textLine = (String)iterator.next();
                Regex regex = TEMPLATE_SPECIALIZATION_REGEX;
                String string2 = textLine;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"textLine");
                if (regex.matches((CharSequence)string2)) continue;
                MatchResult preambleMatcher = PREAMBLE_REGEX.matchEntire((CharSequence)textLine);
                if (preambleMatcher != null) {
                    String string3 = (String)preambleMatcher.getGroupValues().get(1);
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String tagName = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                    String string5 = (String)preambleMatcher.getGroupValues().get(2);
                    boolean bl3 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String tagValue = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                    if (!StringUtil.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"source")) continue;
                    filePath = this.getFilePath(tagValue, workingDirectory, environment2);
                    continue;
                }
                MatchResult lineExecutionMatcher = LINE_EXECUTION_REGEX.matchEntire((CharSequence)textLine);
                if (lineExecutionMatcher != null) {
                    String hits = (String)lineExecutionMatcher.getGroupValues().get(1);
                    String string7 = (String)lineExecutionMatcher.getGroupValues().get(2);
                    boolean bl4 = false;
                    int lineIndex = Integer.parseInt(string7);
                    if (!lineModels.isEmpty() && ((GCovLineModel)CollectionsKt.last((List)lineModels)).getLineIndex() >= lineIndex) continue;
                    lineModels.add(new GCovLineModel(lineIndex, this.getHits(hits)));
                    continue;
                }
                MatchResult blockMatcher = BLOCK_REGEX.matchEntire((CharSequence)textLine);
                if (blockMatcher != null) {
                    Object object;
                    Object v4;
                    int blockIndex;
                    int hits;
                    block12: {
                        hits = this.getHits((String)blockMatcher.getGroupValues().get(1));
                        String string8 = (String)blockMatcher.getGroupValues().get(2);
                        boolean bl5 = false;
                        int lineIndex = Integer.parseInt(string8);
                        string = (String)blockMatcher.getGroupValues().get(3);
                        bl = false;
                        blockIndex = Integer.parseInt(string);
                        Iterable $this$firstOrNull$iv = CollectionsKt.asReversedMutable((List)lineModels);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            GCovLineModel it = (GCovLineModel)element$iv;
                            boolean bl6 = false;
                            if (!(it.getLineIndex() == lineIndex)) continue;
                            v4 = element$iv;
                            break block12;
                        }
                        v4 = null;
                    }
                    if ((object = (GCovLineModel)v4) == null || (object = ((GCovLineModel)object).getBlocks()) == null) continue;
                    object.add(new GCovBlockModel(blockIndex, hits));
                    continue;
                }
                MatchResult branchTakenMatcher = BRANCH_TAKEN_REGEX.matchEntire((CharSequence)textLine);
                if (branchTakenMatcher != null) {
                    String blockIndex = (String)branchTakenMatcher.getGroupValues().get(1);
                    boolean bl7 = false;
                    int branchNumber = Integer.parseInt(blockIndex);
                    string = (String)branchTakenMatcher.getGroupValues().get(2);
                    bl = false;
                    int taken = Integer.parseInt(string);
                    Object object = this.getOrCreateNearestBlock(lineModels);
                    if (object != null && (object = ((GCovBlockModel)object).getBranches()) != null) {
                        object.add(new GCovBranchModel(branchNumber, taken));
                    }
                    continue;
                }
                MatchResult branchNeverExecutedMatcher = BRANCH_NEVER_EXECUTED_REGEX.matchEntire((CharSequence)textLine);
                if (branchNeverExecutedMatcher != null) {
                    string = (String)branchNeverExecutedMatcher.getGroupValues().get(1);
                    bl = false;
                    int branchNumber = Integer.parseInt(string);
                    Object object = this.getOrCreateNearestBlock(lineModels);
                    if (object != null && (object = ((GCovBlockModel)object).getBranches()) != null) {
                        object.add(new GCovBranchModel(branchNumber, 0));
                    }
                    continue;
                }
                Application application2 = application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
                if (application2.isInternal() || application.isUnitTestMode()) {
                    CidrCoverageLogKt.getCidrCoverageLog().debug("Unrecognized line from gcov output. File: " + path + "; Line: " + textLine);
                    continue;
                }
                CidrCoverageLogKt.getCidrCoverageLog().debug("Unrecognized line from gcov output");
            }
            return new GCovCoverageModel(filePath, (List<GCovLineModel>)lineModels);
        }

        private final String getFilePath(String tagValue, File workingDirectory, CidrToolEnvironment environment2) {
            if (FileUtil.isAbsolute((String)tagValue)) {
                String string = FileUtil.toCanonicalPath((String)environment2.toLocalPath(tagValue));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toCanonicalPath\u2026nt.toLocalPath(tagValue))");
                return string;
            }
            String string = FileUtil.toCanonicalPath((String)environment2.toLocalPath(workingDirectory, tagValue));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toCanonicalPath\u2026kingDirectory, tagValue))");
            return string;
        }

        private final GCovBlockModel getOrCreateNearestBlock(ArrayList<GCovLineModel> lineModels) {
            GCovLineModel gCovLineModel = (GCovLineModel)CollectionsKt.lastOrNull((List)lineModels);
            if (gCovLineModel == null) {
                return null;
            }
            GCovLineModel lastLine = gCovLineModel;
            if (lastLine.getBlocks().isEmpty()) {
                lastLine.getBlocks().add(new GCovBlockModel(0, lastLine.getTotalHits()));
            }
            return (GCovBlockModel)CollectionsKt.last(lastLine.getBlocks());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int getHits(String hitsText) {
            String string = hitsText;
            switch (string.hashCode()) {
                case 58212605: {
                    if (!string.equals("=====")) break;
                    return 0;
                }
                case 34354980: {
                    if (!string.equals("$$$$$")) break;
                    return 0;
                }
                case 45: {
                    if (!string.equals("-")) break;
                    return -1;
                }
                case 33400675: {
                    if (!string.equals("#####")) break;
                    return 0;
                }
                case 35309285: {
                    if (!string.equals("%%%%%")) break;
                    return 0;
                }
            }
            String string2 = hitsText;
            return Integer.parseInt(string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

