/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.gcov;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.gcov.GCovCoverageModel;
import com.jetbrains.cidr.execution.coverage.gcov.GCovUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J5\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageParser;", "", "()V", "doLoadCoverageModels", "", "Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "gcovFiles", "Ljava/nio/file/Path;", "workingDirectory", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "parse", "", "rootDirectory", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/intellij/openapi/project/Project;)[Lcom/jetbrains/cidr/execution/coverage/gcov/GCovCoverageModel;", "intellij.cidr.coverage"})
public final class GCovCoverageParser {
    @NotNull
    public final GCovCoverageModel[] parse(@NotNull File rootDirectory, @Nullable File workingDirectory, @NotNull CidrToolEnvironment environment2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create<List<GCovCoverageModel>>()");
        Ref modelsRef = ref;
        HostMachine host = environment2.getHostMachine();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, rootDirectory, host, modelsRef, workingDirectory, environment2){
            final /* synthetic */ GCovCoverageParser this$0;
            final /* synthetic */ File $rootDirectory;
            final /* synthetic */ HostMachine $host;
            final /* synthetic */ Ref $modelsRef;
            final /* synthetic */ File $workingDirectory;
            final /* synthetic */ CidrToolEnvironment $environment;

            public final void run() {
                String string = FileUtil.join((String[])new String[]{this.$rootDirectory.getPath(), "coverage"});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.join(rootDirectory.path, \"coverage\")");
                String coverageDirectory = string;
                HostMachine hostMachine = this.$host;
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"host");
                Path path = this.$host.getPath(coverageDirectory, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"host.getPath(coverageDirectory)");
                List<Path> gcovFiles = GCovUtils.Companion.getGCovFiles(hostMachine, path, false);
                this.$modelsRef.set((Object)GCovCoverageParser.access$doLoadCoverageModels(this.this$0, gcovFiles, this.$workingDirectory, this.$environment));
            }
            {
                this.this$0 = gCovCoverageParser;
                this.$rootDirectory = file;
                this.$host = hostMachine;
                this.$modelsRef = ref;
                this.$workingDirectory = file2;
                this.$environment = cidrToolEnvironment;
            }
        }, CidrCoverageBundle.message("coverage.reading.output.data", new Object[0]), true, project);
        Object object = modelsRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"modelsRef.get()");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        GCovCoverageModel[] gCovCoverageModelArray = thisCollection$iv.toArray(new GCovCoverageModel[0]);
        if (gCovCoverageModelArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return gCovCoverageModelArray;
    }

    private final List<GCovCoverageModel> doLoadCoverageModels(List<? extends Path> gcovFiles, File workingDirectory, CidrToolEnvironment environment2) {
        CidrCoverageLogKt.getCidrCoverageLog().info("Total number of gcov files: " + gcovFiles.size());
        Stream stream = gcovFiles.parallelStream().map(new Function(workingDirectory, environment2){
            final /* synthetic */ File $workingDirectory;
            final /* synthetic */ CidrToolEnvironment $environment;

            @Nullable
            public final GCovCoverageModel apply(Path it) {
                try {
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    return GCovCoverageModel.Companion.loadFrom(path, this.$workingDirectory, this.$environment);
                }
                catch (Exception e) {
                    CidrCoverageLogKt.getCidrCoverageLog().warn("Failed to parse gcov file: " + e.getMessage());
                    return null;
                }
            }
            {
                this.$workingDirectory = file;
                this.$environment = cidrToolEnvironment;
            }
        });
        Intrinsics.checkNotNullExpressionValue(stream, (String)"gcovFiles.parallelStream\u2026ap null\n        }\n      }");
        return CollectionsKt.filterNotNull((Iterable)StreamsKt.toList(stream));
    }

    public static final /* synthetic */ List access$doLoadCoverageModels(GCovCoverageParser $this, List gcovFiles, File workingDirectory, CidrToolEnvironment environment2) {
        return $this.doLoadCoverageModels(gcovFiles, workingDirectory, environment2);
    }
}

