/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0007\u0018\u0019\u001a\u001b\u001c\u001d\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "", "type", "", "version", "mappings", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$CoverageMapping;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getMappings", "()Ljava/util/List;", "getType", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "BranchMapping", "Companion", "CoverageMapping", "FileMapping", "InvalidModelException", "Segment", "Summary", "intellij.cidr.coverage"})
public final class LLVMCoverageModel {
    @NotNull
    private final String type;
    @NotNull
    private final String version;
    @SerializedName(value="data")
    @NotNull
    private final List<CoverageMapping> mappings;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final List<CoverageMapping> getMappings() {
        return this.mappings;
    }

    public LLVMCoverageModel(@NotNull String type, @NotNull String version, @NotNull List<CoverageMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.type = type;
        this.version = version;
        this.mappings = mappings;
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.version;
    }

    @NotNull
    public final List<CoverageMapping> component3() {
        return this.mappings;
    }

    @NotNull
    public final LLVMCoverageModel copy(@NotNull String type, @NotNull String version, @NotNull List<CoverageMapping> mappings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        return new LLVMCoverageModel(type, version, mappings);
    }

    public static /* synthetic */ LLVMCoverageModel copy$default(LLVMCoverageModel lLVMCoverageModel, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = lLVMCoverageModel.type;
        }
        if ((n & 2) != 0) {
            string2 = lLVMCoverageModel.version;
        }
        if ((n & 4) != 0) {
            list = lLVMCoverageModel.mappings;
        }
        return lLVMCoverageModel.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "LLVMCoverageModel(type=" + this.type + ", version=" + this.version + ", mappings=" + this.mappings + ")";
    }

    public int hashCode() {
        String string = this.type;
        String string2 = this.version;
        List<CoverageMapping> list = this.mappings;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LLVMCoverageModel)) break block3;
                LLVMCoverageModel lLVMCoverageModel = (LLVMCoverageModel)object;
                if (!Intrinsics.areEqual((Object)this.type, (Object)lLVMCoverageModel.type) || !Intrinsics.areEqual((Object)this.version, (Object)lLVMCoverageModel.version) || !Intrinsics.areEqual(this.mappings, lLVMCoverageModel.mappings)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$CoverageMapping;", "", "fileMappings", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$FileMapping;", "(Ljava/util/List;)V", "getFileMappings", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.coverage"})
    public static final class CoverageMapping {
        @SerializedName(value="files")
        @NotNull
        private final List<FileMapping> fileMappings;

        @NotNull
        public final List<FileMapping> getFileMappings() {
            return this.fileMappings;
        }

        public CoverageMapping(@NotNull List<FileMapping> fileMappings) {
            Intrinsics.checkNotNullParameter(fileMappings, (String)"fileMappings");
            this.fileMappings = fileMappings;
        }

        @NotNull
        public final List<FileMapping> component1() {
            return this.fileMappings;
        }

        @NotNull
        public final CoverageMapping copy(@NotNull List<FileMapping> fileMappings) {
            Intrinsics.checkNotNullParameter(fileMappings, (String)"fileMappings");
            return new CoverageMapping(fileMappings);
        }

        public static /* synthetic */ CoverageMapping copy$default(CoverageMapping coverageMapping, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = coverageMapping.fileMappings;
            }
            return coverageMapping.copy(list);
        }

        @NotNull
        public String toString() {
            return "CoverageMapping(fileMappings=" + this.fileMappings + ")";
        }

        public int hashCode() {
            List<FileMapping> list = this.fileMappings;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CoverageMapping)) break block3;
                    CoverageMapping coverageMapping = (CoverageMapping)object;
                    if (!Intrinsics.areEqual(this.fileMappings, coverageMapping.fileMappings)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$FileMapping;", "", "name", "", "segments", "", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "summary", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "(Ljava/lang/String;Ljava/util/List;Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;)V", "getName", "()Ljava/lang/String;", "getSegments", "()Ljava/util/List;", "getSummary", "()Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.coverage"})
    public static final class FileMapping {
        @SerializedName(value="filename")
        @NotNull
        private final String name;
        @NotNull
        private final List<Segment> segments;
        @Nullable
        private final Summary summary;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Segment> getSegments() {
            return this.segments;
        }

        @Nullable
        public final Summary getSummary() {
            return this.summary;
        }

        public FileMapping(@NotNull String name2, @NotNull List<Segment> segments, @Nullable Summary summary) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            this.name = name2;
            this.segments = segments;
            this.summary = summary;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<Segment> component2() {
            return this.segments;
        }

        @Nullable
        public final Summary component3() {
            return this.summary;
        }

        @NotNull
        public final FileMapping copy(@NotNull String name2, @NotNull List<Segment> segments, @Nullable Summary summary) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            return new FileMapping(name2, segments, summary);
        }

        public static /* synthetic */ FileMapping copy$default(FileMapping fileMapping, String string, List list, Summary summary, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileMapping.name;
            }
            if ((n & 2) != 0) {
                list = fileMapping.segments;
            }
            if ((n & 4) != 0) {
                summary = fileMapping.summary;
            }
            return fileMapping.copy(string, list, summary);
        }

        @NotNull
        public String toString() {
            return "FileMapping(name=" + this.name + ", segments=" + this.segments + ", summary=" + this.summary + ")";
        }

        public int hashCode() {
            String string = this.name;
            List<Segment> list = this.segments;
            Summary summary = this.summary;
            return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (summary != null ? ((Object)summary).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileMapping)) break block3;
                    FileMapping fileMapping = (FileMapping)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)fileMapping.name) || !Intrinsics.areEqual(this.segments, fileMapping.segments) || !Intrinsics.areEqual((Object)this.summary, (Object)fileMapping.summary)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Summary;", "", "branches", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "(Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;)V", "getBranches", "()Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.coverage"})
    public static final class Summary {
        @Nullable
        private final BranchMapping branches;

        @Nullable
        public final BranchMapping getBranches() {
            return this.branches;
        }

        public Summary(@Nullable BranchMapping branches) {
            this.branches = branches;
        }

        @Nullable
        public final BranchMapping component1() {
            return this.branches;
        }

        @NotNull
        public final Summary copy(@Nullable BranchMapping branches) {
            return new Summary(branches);
        }

        public static /* synthetic */ Summary copy$default(Summary summary, BranchMapping branchMapping, int n, Object object) {
            if ((n & 1) != 0) {
                branchMapping = summary.branches;
            }
            return summary.copy(branchMapping);
        }

        @NotNull
        public String toString() {
            return "Summary(branches=" + this.branches + ")";
        }

        public int hashCode() {
            BranchMapping branchMapping = this.branches;
            return branchMapping != null ? ((Object)branchMapping).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Summary)) break block3;
                    Summary summary = (Summary)object;
                    if (!Intrinsics.areEqual((Object)this.branches, (Object)summary.branches)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$BranchMapping;", "", "count", "", "covered", "notCovered", "percent", "", "(IIID)V", "getCount", "()I", "getCovered", "getNotCovered", "getPercent", "()D", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.cidr.coverage"})
    public static final class BranchMapping {
        private final int count;
        private final int covered;
        @SerializedName(value="notcovered")
        private final int notCovered;
        private final double percent;

        public final int getCount() {
            return this.count;
        }

        public final int getCovered() {
            return this.covered;
        }

        public final int getNotCovered() {
            return this.notCovered;
        }

        public final double getPercent() {
            return this.percent;
        }

        public BranchMapping(int count, int covered, int notCovered, double percent) {
            this.count = count;
            this.covered = covered;
            this.notCovered = notCovered;
            this.percent = percent;
        }

        public final int component1() {
            return this.count;
        }

        public final int component2() {
            return this.covered;
        }

        public final int component3() {
            return this.notCovered;
        }

        public final double component4() {
            return this.percent;
        }

        @NotNull
        public final BranchMapping copy(int count, int covered, int notCovered, double percent) {
            return new BranchMapping(count, covered, notCovered, percent);
        }

        public static /* synthetic */ BranchMapping copy$default(BranchMapping branchMapping, int n, int n2, int n3, double d, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = branchMapping.count;
            }
            if ((n4 & 2) != 0) {
                n2 = branchMapping.covered;
            }
            if ((n4 & 4) != 0) {
                n3 = branchMapping.notCovered;
            }
            if ((n4 & 8) != 0) {
                d = branchMapping.percent;
            }
            return branchMapping.copy(n, n2, n3, d);
        }

        @NotNull
        public String toString() {
            return "BranchMapping(count=" + this.count + ", covered=" + this.covered + ", notCovered=" + this.notCovered + ", percent=" + this.percent + ")";
        }

        public int hashCode() {
            return ((Integer.hashCode(this.count) * 31 + Integer.hashCode(this.covered)) * 31 + Integer.hashCode(this.notCovered)) * 31 + Double.hashCode(this.percent);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BranchMapping)) break block3;
                    BranchMapping branchMapping = (BranchMapping)object;
                    if (this.count != branchMapping.count || this.covered != branchMapping.covered || this.notCovered != branchMapping.notCovered || Double.compare(this.percent, branchMapping.percent) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonAdapter(value=Adapter.class)
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "", "beginLine", "", "beginColumn", "count", "", "hasCount", "", "isRegionEntry", "(IIJZZ)V", "getBeginColumn", "()I", "getBeginLine", "getCount", "()J", "getHasCount", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "Adapter", "intellij.cidr.coverage"})
    public static final class Segment {
        private final int beginLine;
        private final int beginColumn;
        private final long count;
        private final boolean hasCount;
        private final boolean isRegionEntry;

        public final int getBeginLine() {
            return this.beginLine;
        }

        public final int getBeginColumn() {
            return this.beginColumn;
        }

        public final long getCount() {
            return this.count;
        }

        public final boolean getHasCount() {
            return this.hasCount;
        }

        public final boolean isRegionEntry() {
            return this.isRegionEntry;
        }

        public Segment(int beginLine, int beginColumn, long count, boolean hasCount, boolean isRegionEntry) {
            this.beginLine = beginLine;
            this.beginColumn = beginColumn;
            this.count = count;
            this.hasCount = hasCount;
            this.isRegionEntry = isRegionEntry;
        }

        public final int component1() {
            return this.beginLine;
        }

        public final int component2() {
            return this.beginColumn;
        }

        public final long component3() {
            return this.count;
        }

        public final boolean component4() {
            return this.hasCount;
        }

        public final boolean component5() {
            return this.isRegionEntry;
        }

        @NotNull
        public final Segment copy(int beginLine, int beginColumn, long count, boolean hasCount, boolean isRegionEntry) {
            return new Segment(beginLine, beginColumn, count, hasCount, isRegionEntry);
        }

        public static /* synthetic */ Segment copy$default(Segment segment, int n, int n2, long l, boolean bl, boolean bl2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = segment.beginLine;
            }
            if ((n3 & 2) != 0) {
                n2 = segment.beginColumn;
            }
            if ((n3 & 4) != 0) {
                l = segment.count;
            }
            if ((n3 & 8) != 0) {
                bl = segment.hasCount;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = segment.isRegionEntry;
            }
            return segment.copy(n, n2, l, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Segment(beginLine=" + this.beginLine + ", beginColumn=" + this.beginColumn + ", count=" + this.count + ", hasCount=" + this.hasCount + ", isRegionEntry=" + this.isRegionEntry + ")";
        }

        public int hashCode() {
            int n = ((Integer.hashCode(this.beginLine) * 31 + Integer.hashCode(this.beginColumn)) * 31 + Long.hashCode(this.count)) * 31;
            int n2 = this.hasCount ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.isRegionEntry ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Segment)) break block3;
                    Segment segment = (Segment)object;
                    if (this.beginLine != segment.beginLine || this.beginColumn != segment.beginColumn || this.count != segment.count || this.hasCount != segment.hasCount || this.isRegionEntry != segment.isRegionEntry) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment$Adapter;", "Lcom/google/gson/JsonDeserializer;", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "()V", "isTrue", "", "Lcom/google/gson/JsonElement;", "(Lcom/google/gson/JsonElement;)Z", "deserialize", "json", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.cidr.coverage"})
        public static final class Adapter
        implements JsonDeserializer<Segment> {
            @NotNull
            public Segment deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
                Segment segment;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                JsonArray array = json.getAsJsonArray();
                try {
                    JsonElement jsonElement = array.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"array[0]");
                    int n = jsonElement.getAsInt();
                    JsonElement jsonElement2 = array.get(1);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"array[1]");
                    int n2 = jsonElement2.getAsInt();
                    JsonElement jsonElement3 = array.get(2);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"array[2]");
                    long l = jsonElement3.getAsLong();
                    JsonElement jsonElement4 = array.get(3);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"array[3]");
                    boolean bl = this.isTrue(jsonElement4);
                    JsonElement jsonElement5 = array.get(4);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"array[4]");
                    segment = new Segment(n, n2, l, bl, this.isTrue(jsonElement5));
                }
                catch (Exception e) {
                    throw (Throwable)new InvalidModelException("Invalid segment data: " + json, e);
                }
                return segment;
            }

            private final boolean isTrue(JsonElement $this$isTrue) {
                return Intrinsics.areEqual((Object)$this$isTrue, (Object)new JsonPrimitive((Number)1)) || Intrinsics.areEqual((Object)$this$isTrue, (Object)new JsonPrimitive(Boolean.valueOf(true)));
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0006\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$InvalidModelException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "cause", "(Ljava/lang/String;Ljava/lang/Exception;)V", "intellij.cidr.coverage"})
    public static final class InvalidModelException
    extends Exception {
        public InvalidModelException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public InvalidModelException(@NotNull String message, @NotNull Exception cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Companion;", "", "()V", "fromFile", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "inputPath", "Ljava/nio/file/Path;", "intellij.cidr.coverage"})
    public static final class Companion {
        @NotNull
        public final LLVMCoverageModel fromFile(@NotNull Path inputPath) {
            LLVMCoverageModel lLVMCoverageModel;
            Intrinsics.checkNotNullParameter((Object)inputPath, (String)"inputPath");
            InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(inputPath)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            InputStreamReader rawDataReader = new InputStreamReader(inputStream2, charset);
            Gson gson = new GsonBuilder().create();
            try {
                lLVMCoverageModel = (LLVMCoverageModel)gson.fromJson((Reader)rawDataReader, LLVMCoverageModel.class);
            }
            catch (JsonParseException e) {
                throw (Throwable)new InvalidModelException("Malformed model", (Exception)((Object)e));
            }
            LLVMCoverageModel model = lLVMCoverageModel;
            if (model == null) {
                throw (Throwable)new InvalidModelException("Model is null");
            }
            if (Intrinsics.areEqual((Object)model.getType(), (Object)"llvm.coverage.json.export") ^ true) {
                throw (Throwable)new InvalidModelException("Invalid type: " + model.getType());
            }
            Version version = Version.parseVersion((String)model.getVersion());
            if (version == null || version.major != 2) {
                CidrCoverageLogKt.getCidrCoverageLog().warn("Possibly incompatible llvm-cov output version: " + model.getVersion());
            }
            return model;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

