/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.model.impl;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u00c2\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c2\u0003J;\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\nH\u00d6\u0001R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/external/system/model/impl/ExternalLanguageConfigurationImpl;", "Lcom/jetbrains/cidr/external/system/model/ExternalLanguageConfiguration;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "compilerKind", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "compilerExecutable", "Ljava/io/File;", "compilerSwitches", "", "", "(Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;Ljava/io/File;Ljava/util/List;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getCompilerExecutable", "getCompilerKind", "getCompilerSwitches", "getLanguageKind", "hashCode", "", "resolveCompiler", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "toString", "intellij.cidr.externalSystem"})
public final class ExternalLanguageConfigurationImpl
implements ExternalLanguageConfiguration {
    private final OCLanguageKind languageKind;
    private final OCCompilerKind compilerKind;
    private final File compilerExecutable;
    private final List<String> compilerSwitches;

    @Override
    @NotNull
    public OCLanguageKind getLanguageKind() {
        return this.languageKind;
    }

    @Override
    @Nullable
    public OCCompilerKind getCompilerKind() {
        return this.compilerKind;
    }

    @Override
    @Nullable
    public File getCompilerExecutable() {
        return this.compilerExecutable;
    }

    @Override
    @NotNull
    public List<String> getCompilerSwitches() {
        return this.compilerSwitches;
    }

    @NotNull
    public final OCCompilerKind resolveCompiler(@NotNull Project project, @NotNull CidrToolEnvironment environment2) {
        OCCompilerKind oCCompilerKind;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        if (this.compilerKind != null && Intrinsics.areEqual((Object)this.compilerKind, (Object)UnknownCompilerKind.INSTANCE) ^ true) {
            oCCompilerKind = this.compilerKind;
        } else if (this.compilerExecutable == null) {
            oCCompilerKind = (OCCompilerKind)UnknownCompilerKind.INSTANCE;
        } else {
            Path path = environment2.getHostMachine().getPath(this.compilerExecutable.getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.\u2026(compilerExecutable.path)");
            oCCompilerKind = OCCompilerResolver.Companion.resolve(project, path, environment2);
        }
        return oCCompilerKind;
    }

    public ExternalLanguageConfigurationImpl(@NotNull OCLanguageKind languageKind, @Nullable OCCompilerKind compilerKind, @Nullable File compilerExecutable, @NotNull List<String> compilerSwitches) {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter(compilerSwitches, (String)"compilerSwitches");
        this.languageKind = languageKind;
        this.compilerKind = compilerKind;
        this.compilerExecutable = compilerExecutable;
        this.compilerSwitches = compilerSwitches;
    }

    private final OCLanguageKind component1() {
        return this.languageKind;
    }

    private final OCCompilerKind component2() {
        return this.compilerKind;
    }

    private final File component3() {
        return this.compilerExecutable;
    }

    private final List<String> component4() {
        return this.compilerSwitches;
    }

    @NotNull
    public final ExternalLanguageConfigurationImpl copy(@NotNull OCLanguageKind languageKind, @Nullable OCCompilerKind compilerKind, @Nullable File compilerExecutable, @NotNull List<String> compilerSwitches) {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter(compilerSwitches, (String)"compilerSwitches");
        return new ExternalLanguageConfigurationImpl(languageKind, compilerKind, compilerExecutable, compilerSwitches);
    }

    public static /* synthetic */ ExternalLanguageConfigurationImpl copy$default(ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl, OCLanguageKind oCLanguageKind, OCCompilerKind oCCompilerKind, File file, List list, int n, Object object) {
        if ((n & 1) != 0) {
            oCLanguageKind = externalLanguageConfigurationImpl.languageKind;
        }
        if ((n & 2) != 0) {
            oCCompilerKind = externalLanguageConfigurationImpl.compilerKind;
        }
        if ((n & 4) != 0) {
            file = externalLanguageConfigurationImpl.compilerExecutable;
        }
        if ((n & 8) != 0) {
            list = externalLanguageConfigurationImpl.compilerSwitches;
        }
        return externalLanguageConfigurationImpl.copy(oCLanguageKind, oCCompilerKind, file, list);
    }

    @NotNull
    public String toString() {
        return "ExternalLanguageConfigurationImpl(languageKind=" + this.languageKind + ", compilerKind=" + this.compilerKind + ", compilerExecutable=" + this.compilerExecutable + ", compilerSwitches=" + this.compilerSwitches + ")";
    }

    public int hashCode() {
        OCLanguageKind oCLanguageKind = this.languageKind;
        OCCompilerKind oCCompilerKind = this.compilerKind;
        File file = this.compilerExecutable;
        List<String> list = this.compilerSwitches;
        return (((oCLanguageKind != null ? oCLanguageKind.hashCode() : 0) * 31 + (oCCompilerKind != null ? oCCompilerKind.hashCode() : 0)) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ExternalLanguageConfigurationImpl)) break block3;
                ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl = (ExternalLanguageConfigurationImpl)object;
                if (!Intrinsics.areEqual((Object)this.languageKind, (Object)externalLanguageConfigurationImpl.languageKind) || !Intrinsics.areEqual((Object)this.compilerKind, (Object)externalLanguageConfigurationImpl.compilerKind) || !Intrinsics.areEqual((Object)this.compilerExecutable, (Object)externalLanguageConfigurationImpl.compilerExecutable) || !Intrinsics.areEqual(this.compilerSwitches, externalLanguageConfigurationImpl.compilerSwitches)) break block3;
            }
            return true;
        }
        return false;
    }
}

