/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.util.GraphCopier;
import com.intellij.openapi.graph.view.BaseGraphMouseWheelListener;
import com.intellij.openapi.graph.view.BaseGraphViewControllerMode;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphViewControllerBuilder;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.LocalViewCreator;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGraphStructureViewBuilder
implements StructureViewBuilder {
    @NotNull
    public static final Key<Boolean> LOCAL_VIEW_KEY = Key.create((String)"com.intellij.openapi.graph.builder.components.BasicGraphStructureViewBuilder.LOCAL_VIEW_CLIENT_PROPERTY");
    @NotNull
    public static final StructureViewModel OUR_DUMMY_MODEL = new DummyStructureViewModel();
    @NotNull
    protected static final JBColor OUR_OVERVIEW_FOG_COLOR = new JBColor(new Color(0, 0, 0, 20), new Color(255, 255, 255, 25));
    @NotNull
    private final GraphBuilder<?, ?> myMainBuilder;
    @NotNull
    private final GraphBuilder<?, ?> myLocalViewBuilder;
    @NotNull
    private final LocalViewCreator.AbstractLocalViewCreator myNodeLocalViewCreator;
    @NotNull
    private final LocalViewCreator.AbstractLocalViewCreator myEdgeLocalViewCreator;
    @NotNull
    private LocalViewCreator.AbstractLocalViewCreator myCurrentLocalViewCreator;
    @NotNull
    private final Overview myOverview;
    @NotNull
    private final JBSplitter myComponent;

    protected BaseGraphStructureViewBuilder(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(0);
        }
        this.myMainBuilder = builder;
        this.myOverview = this.createOverview(builder);
        Graph2D mainGraph = builder.getGraph();
        GraphCopier.CopyFactory copyFactory = mainGraph.getGraphCopyFactory();
        Graph2D localViewGraph = (Graph2D)copyFactory.createGraph();
        Graph2DView localView = this.createLocalView(builder, localViewGraph);
        this.myNodeLocalViewCreator = this.createNodeLocalViewCreator(builder, mainGraph, copyFactory, localViewGraph);
        this.myEdgeLocalViewCreator = this.createEdgeLocalViewCreator(builder, mainGraph, copyFactory, localViewGraph);
        this.myCurrentLocalViewCreator = this.myNodeLocalViewCreator;
        EditMode editModeForLocalView = this.createEditModeForLocalView(builder);
        this.myLocalViewBuilder = GraphBuilderFactory.getInstance(builder.getProject()).createGraphBuilder(localViewGraph, localView, new LocalViewGraphDataModel(), new LocalViewGraphPresentationModel(), editModeForLocalView);
        this.myLocalViewBuilder.initialize();
        this.setupViewControllers(editModeForLocalView);
        this.myComponent = this.createDividedPane(this.myOverview.getJComponent(), localView.getJComponent());
        this.updateSplitterOrientation();
        this.updateColors(localView, builder.getView());
    }

    @NotNull
    public static BaseGraphStructureViewBuilder setupFor(@NotNull GraphBuilder<?, ?> builder, @Nullable DataProvider localViewDataProvider) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(1);
        }
        final BaseGraphStructureViewBuilder viewBuilder = new BaseGraphStructureViewBuilder(builder);
        if (localViewDataProvider != null) {
            GraphViewUtil.addDataProvider(viewBuilder.getLocalView(), dataId -> GraphDataKeys.GRAPH_BUILDER.is(dataId) ? viewBuilder.getLocalViewBuilder() : null);
            GraphViewUtil.addDataProvider(viewBuilder.getLocalView(), localViewDataProvider);
        }
        builder.getGraph().addGraph2DSelectionListener(viewBuilder.new SelectionTrigger());
        builder.addCustomUpdater(new CustomGraphUpdater(){

            @Override
            public void update(@NotNull Graph2D graph, @NotNull Graph2DView view) {
                if (graph == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (view == null) {
                    1.$$$reportNull$$$0(1);
                }
                viewBuilder.updateView();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "graph";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "view";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$1";
                objectArray[2] = "update";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        builder.getProject().getMessageBus().connect(builder).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    2.$$$reportNull$$$0(0);
                }
                viewBuilder.updateSplitterOrientation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$2", "stateChanged"));
            }
        });
        BaseGraphStructureViewBuilder baseGraphStructureViewBuilder = viewBuilder;
        if (baseGraphStructureViewBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(2);
        }
        return baseGraphStructureViewBuilder;
    }

    @NotNull
    public StructureView createStructureView(@Nullable FileEditor fileEditor, @NotNull Project project) {
        if (project == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(3);
        }
        return new BasicGraphStructureView(fileEditor);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    protected Overview createOverview(@NotNull GraphBuilder<?, ?> graphBuilder) {
        void builder;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(4);
        }
        Overview overview = GraphManager.getGraphManager().createOverview(builder.getView());
        this.setupBackgroundRenderer(overview);
        overview.getJComponent().putClientProperty("Overview.FogColor", OUR_OVERVIEW_FOG_COLOR);
        overview.getJComponent().addMouseListener(new MouseAdapter((GraphBuilder)builder){
            final /* synthetic */ GraphBuilder val$builder;
            {
                this.val$builder = graphBuilder;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.val$builder.getView().requestFocus();
            }
        });
        Overview overview2 = overview;
        if (overview2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(5);
        }
        return overview2;
    }

    protected void setupBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(6);
        }
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        renderer.setColor(UIUtil.getListBackground());
        view.setBackgroundRenderer(renderer);
    }

    @NotNull
    protected LocalViewCreator.AbstractLocalViewCreator createNodeLocalViewCreator(@NotNull GraphBuilder<?, ?> builder, @NotNull Graph2D modelGraph, @NotNull GraphCopier.CopyFactory copyFactory, @NotNull Graph2D localViewGraph) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(7);
        }
        if (modelGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(8);
        }
        if (copyFactory == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(9);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(10);
        }
        LocalViewCreator.Neighborhood localViewCreator = GraphManager.getGraphManager().createLocalViewCreator_Neighborhood(modelGraph, copyFactory, localViewGraph);
        this.setupLocalViewLayoutChangeOnGlobalLayoutChange(builder, localViewCreator);
        LocalViewCreator.Neighborhood neighborhood = localViewCreator;
        if (neighborhood == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(11);
        }
        return neighborhood;
    }

    @NotNull
    protected LocalViewCreator.AbstractLocalViewCreator createEdgeLocalViewCreator(@NotNull GraphBuilder<?, ?> builder, @NotNull Graph2D modelGraph, @NotNull GraphCopier.CopyFactory copyFactory, @NotNull Graph2D localViewGraph) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(12);
        }
        if (modelGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(13);
        }
        if (copyFactory == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(14);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(15);
        }
        LocalViewCreator.EdgeGroup localViewCreator = GraphManager.getGraphManager().createLocalViewCreator_EdgeGroup(modelGraph, copyFactory, localViewGraph);
        this.setupLocalViewLayoutChangeOnGlobalLayoutChange(builder, localViewCreator);
        LocalViewCreator.EdgeGroup edgeGroup = localViewCreator;
        if (edgeGroup == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(16);
        }
        return edgeGroup;
    }

    protected void setupLocalViewLayoutChangeOnGlobalLayoutChange(@NotNull GraphBuilder<?, ?> builder, final @NotNull LocalViewCreator.AbstractLocalViewCreator localViewCreator) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(17);
        }
        if (localViewCreator == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(18);
        }
        GraphSettings graphViewSettings = builder.getGraphPresentationModel().getSettings();
        localViewCreator.setLayouter(graphViewSettings.getCurrentLayouter());
        graphViewSettings.addListener(builder, new GraphSettings.ChangeListener(){

            @Override
            public void settingsChanged(@NotNull GraphSettings old, @NotNull GraphSettings new_) {
                if (old == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (new_ == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (old.getCurrentLayouter() != new_.getCurrentLayouter()) {
                    localViewCreator.setLayouter(new_.getCurrentLayouter());
                    localViewCreator.updateViewGraph();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "old";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "new_";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$4";
                objectArray[2] = "settingsChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected Graph2DView createLocalView(@NotNull GraphBuilder<?, ?> builder, @NotNull Graph2D localViewGraph) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(19);
        }
        if (localViewGraph == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(20);
        }
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(localViewGraph);
        this.setupBackgroundRenderer(view);
        view.setFitContentOnResize(true);
        view.setScrollBarPolicy(21, 31);
        UIUtil.putClientProperty((JComponent)view.getCanvasComponent(), LOCAL_VIEW_KEY, (Object)Boolean.TRUE);
        Graph2DView graph2DView = view;
        if (graph2DView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(21);
        }
        return graph2DView;
    }

    protected void updateColors(@NotNull Graph2DView localView, @NotNull Graph2DView mainView) {
        if (localView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(22);
        }
        if (mainView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(23);
        }
        localView.setGridColor(mainView.getGridColor());
        GraphViewUtil.copyClientProperty(mainView.getJComponent(), localView.getJComponent(), "selectionbox.fillcolor");
        GraphViewUtil.copyClientProperty(mainView.getJComponent(), localView.getJComponent(), "selectionbox.linecolor");
        GraphViewUtil.copyClientProperty(mainView.getJComponent(), localView.getJComponent(), "magnifier.linecolor");
    }

    @NotNull
    protected EditMode createEditModeForLocalView(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(24);
        }
        EditMode editMode = GraphEditModeFactory.getInstance(builder.getProject()).createEditMode(builder);
        editMode.allowNodeCreation(false);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.allowNodeEditing(false);
        editMode.allowResizeNodes(false);
        editMode.allowMoveLabels(false);
        editMode.allowMovePorts(false);
        editMode.allowLabelSelection(false);
        editMode.allowMoveSelection(false);
        editMode.allowMoving(false);
        editMode.allowMovingWithPopup(true);
        editMode.setAdjustScrollBarPolicy(false);
        editMode.showEdgeTips(true);
        editMode.showNodeTips(true);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(25);
        }
        return editMode2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode) {
        void editMode2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editMode2 == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(26);
        }
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(170);
        ((LocalGraphViewControllerBuilder)((LocalGraphViewControllerBuilder)((LocalGraphViewControllerBuilder)LocalGraphViewControllerBuilder.beginSetupFor(this, this.myLocalViewBuilder).setEditMode((EditMode)editMode2)).setMagnifierViewMode(magnifierViewMode)).setSelectionBoxMode(null)).endSetup();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    protected JBSplitter createDividedPane(@NotNull JComponent jComponent, @NotNull JComponent jComponent2) {
        void second;
        void first;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (first == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(27);
        }
        if (second == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(28);
        }
        OnePixelSplitter pane = new OnePixelSplitter(0.5f);
        pane.setFirstComponent((JComponent)first);
        pane.setSecondComponent((JComponent)second);
        OnePixelSplitter onePixelSplitter = pane;
        if (onePixelSplitter == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(29);
        }
        return onePixelSplitter;
    }

    protected void updateSplitterOrientation() {
        ObjectUtils.consumeIfNotNull((Object)ToolWindowManager.getInstance((Project)this.myMainBuilder.getProject()).getToolWindow("Structure"), tw -> this.myComponent.setOrientation(!tw.getAnchor().isHorizontal()));
    }

    @NotNull
    public GraphBuilder getMainBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myMainBuilder;
        if (graphBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(30);
        }
        return graphBuilder;
    }

    @NotNull
    public GraphBuilder getLocalViewBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myLocalViewBuilder;
        if (graphBuilder == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(31);
        }
        return graphBuilder;
    }

    @NotNull
    protected Optional<Object> getModelGraphNodeObject(@Nullable Node node) {
        Optional<Object> optional = Optional.ofNullable(node).map(it -> this.getCurrentLocalViewCreator().getModelNode((Node)it)).map(it -> this.getMainBuilder().getNodeObject((Node)it));
        if (optional == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(32);
        }
        return optional;
    }

    @NotNull
    protected Optional<Object> getModelGraphEdgeObject(@Nullable Edge edge) {
        Optional<Object> optional = Optional.ofNullable(edge).map(it -> this.getCurrentLocalViewCreator().getModelEdge((Edge)it)).map(it -> this.getMainBuilder().getEdgeObject((Edge)it));
        if (optional == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(33);
        }
        return optional;
    }

    @NotNull
    public Overview getOverview() {
        Overview overview = this.myOverview;
        if (overview == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(34);
        }
        return overview;
    }

    @NotNull
    public JComponent getComponent() {
        JBSplitter jBSplitter = this.myComponent;
        if (jBSplitter == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(35);
        }
        return jBSplitter;
    }

    @NotNull
    public Graph2DView getLocalView() {
        Graph2DView graph2DView = this.myLocalViewBuilder.getView();
        if (graph2DView == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(36);
        }
        return graph2DView;
    }

    @NotNull
    public LocalViewCreator.AbstractLocalViewCreator getCurrentLocalViewCreator() {
        LocalViewCreator.AbstractLocalViewCreator abstractLocalViewCreator = this.myCurrentLocalViewCreator;
        if (abstractLocalViewCreator == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(37);
        }
        return abstractLocalViewCreator;
    }

    public void updateView() {
        this.myCurrentLocalViewCreator.updateViewGraph();
    }

    protected void updateViewOfSelectedNodes(@NotNull List<Node> nodes) {
        if (nodes == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(38);
        }
        this.myCurrentLocalViewCreator = this.myNodeLocalViewCreator;
        this.myCurrentLocalViewCreator.clearFocusNodes();
        for (Node node : nodes) {
            this.myCurrentLocalViewCreator.addFocusNode(node);
        }
        this.myCurrentLocalViewCreator.updateViewGraph();
    }

    protected void updateViewOfSelectedEdges(@NotNull List<Edge> edges) {
        if (edges == null) {
            BaseGraphStructureViewBuilder.$$$reportNull$$$0(39);
        }
        this.myCurrentLocalViewCreator = this.myEdgeLocalViewCreator;
        this.myCurrentLocalViewCreator.clearFocusEdges();
        for (Edge edge : edges) {
            this.myCurrentLocalViewCreator.addFocusEdge(edge);
        }
        this.myCurrentLocalViewCreator.updateViewGraph();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelGraph";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFactory";
                break;
            }
            case 10: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localViewGraph";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localViewCreator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localView";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainView";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setupFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverview";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeLocalViewCreator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdgeLocalViewCreator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalView";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditModeForLocalView";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDividedPane";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainBuilder";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalViewBuilder";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphNodeObject";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelGraphEdgeObject";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverview";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalView";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLocalViewCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupFor";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStructureView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOverview";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupBackgroundRenderer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNodeLocalViewCreator";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEdgeLocalViewCreator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupLocalViewLayoutChangeOnGlobalLayoutChange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLocalView";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createEditModeForLocalView";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDividedPane";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateViewOfSelectedNodes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateViewOfSelectedEdges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class DummyStructureViewModel
    implements StructureViewModel {
        protected DummyStructureViewModel() {
        }

        @Nullable
        public Object getCurrentEditorElement() {
            return null;
        }

        public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(0);
            }
        }

        public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(1);
            }
        }

        public void addModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(2);
            }
        }

        public void removeModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public StructureViewTreeElement getRoot() {
            return new StructureViewTreeElement(){

                public Object getValue() {
                    return null;
                }

                public void navigate(boolean requestFocus) {
                }

                public boolean canNavigate() {
                    return false;
                }

                public boolean canNavigateToSource() {
                    return false;
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    throw new UnsupportedOperationException();
                }

                public TreeElement @NotNull [] getChildren() {
                    if (EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel$1", "getChildren"));
                }
            };
        }

        public void dispose() {
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }

        public Grouper @NotNull [] getGroupers() {
            if (Grouper.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(4);
            }
            return Grouper.EMPTY_ARRAY;
        }

        public Sorter @NotNull [] getSorters() {
            if (Sorter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(5);
            }
            return Sorter.EMPTY_ARRAY;
        }

        public Filter @NotNull [] getFilters() {
            if (Filter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(6);
            }
            return Filter.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$DummyStructureViewModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorPositionListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEditorPositionListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addModelListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeModelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected final class LocalViewGraphPresentationModel
    extends GraphPresentationModel<Node, Edge> {
        @NotNull
        private final GraphSettings mySettings = new GraphSettings();

        protected LocalViewGraphPresentationModel() {
        }

        @Override
        @NotNull
        public NodeRealizer getNodeRealizer(@Nullable Node node) {
            NodeRealizer nodeRealizer = BaseGraphStructureViewBuilder.this.getModelGraphNodeObject(node).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getGraphPresentationModel().getNodeRealizer(it)).orElseGet(() -> GraphManager.getGraphManager().createGraph2DNodeRealizer());
            if (nodeRealizer == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(0);
            }
            return nodeRealizer;
        }

        @Override
        @NotNull
        public EdgeRealizer getEdgeRealizer(@Nullable Edge edge) {
            EdgeRealizer edgeRealizer = BaseGraphStructureViewBuilder.this.getModelGraphEdgeObject(edge).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getGraphPresentationModel().getEdgeRealizer(it)).orElseGet(() -> GraphManager.getGraphManager().createPolyLineEdgeRealizer());
            if (edgeRealizer == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(1);
            }
            return edgeRealizer;
        }

        @Override
        @Nullable
        public NodeCellEditor getCustomNodeCellEditor(@Nullable Node node) {
            return null;
        }

        @Override
        @Nullable
        public String getNodeTooltip(@Nullable Node node) {
            return BaseGraphStructureViewBuilder.this.getModelGraphNodeObject(node).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getGraphPresentationModel().getNodeTooltip(it)).orElse(null);
        }

        @Override
        @Nullable
        public String getEdgeTooltip(@Nullable Edge edge) {
            return BaseGraphStructureViewBuilder.this.getModelGraphEdgeObject(edge).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getGraphPresentationModel().getEdgeTooltip(it)).orElse(null);
        }

        @Override
        public boolean editNode(@Nullable Node node) {
            return false;
        }

        @Override
        public boolean editEdge(@Nullable Edge edge) {
            return false;
        }

        @Override
        @NotNull
        public DefaultActionGroup getNodeActionGroup(@Nullable Node node) {
            return this.getCommonActionGroup();
        }

        @Override
        @NotNull
        public DefaultActionGroup getEdgeActionGroup(@Nullable Edge edge) {
            return this.getCommonActionGroup();
        }

        @Override
        @NotNull
        public DefaultActionGroup getPaperActionGroup() {
            return this.getCommonActionGroup();
        }

        @NotNull
        private DefaultActionGroup getCommonActionGroup() {
            return new DefaultActionGroup(new AnAction[]{GraphViewUtil.getCommonPopupActions()});
        }

        @Override
        public EdgeLabel @NotNull [] getEdgeLabels(@Nullable Edge edge, @NotNull String edgeName) {
            if (edgeName == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(2);
            }
            EdgeLabel[] edgeLabelArray = BaseGraphStructureViewBuilder.this.getModelGraphEdgeObject(edge).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getGraphPresentationModel().getEdgeLabels(edge, edgeName)).orElse(new EdgeLabel[0]);
            if (edgeLabelArray == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(3);
            }
            return edgeLabelArray;
        }

        @Override
        @NotNull
        public GraphSettings getSettings() {
            GraphSettings graphSettings = this.mySettings;
            if (graphSettings == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(4);
            }
            return graphSettings;
        }

        @Override
        public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
            if (view == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(5);
            }
            if (editMode == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(6);
            }
        }

        @Override
        @NotNull
        public EdgeCreationPolicy<Node> getEdgeCreationPolicy() {
            EdgeCreationPolicy<Node> edgeCreationPolicy = EdgeCreationPolicy.EVERYTHING_ACCEPTED_POLICY;
            if (edgeCreationPolicy == null) {
                LocalViewGraphPresentationModel.$$$reportNull$$$0(7);
            }
            return edgeCreationPolicy;
        }

        @Override
        @Nullable
        public DeleteProvider<?, ?> getDeleteProvider() {
            return null;
        }

        @Override
        @NotNull
        public String getActionPlace() {
            return "StructureViewPopup";
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphPresentationModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeRealizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeRealizer";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphPresentationModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeLabels";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeCreationPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getEdgeLabels";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeSettings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected final class LocalViewGraphDataModel
    extends GraphDataModel<Node, Edge> {
        protected LocalViewGraphDataModel() {
        }

        @Override
        @NotNull
        public Collection<Node> getNodes() {
            List<Node> list = Arrays.asList(BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getViewGraph().getNodeArray());
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<Edge> getEdges() {
            List<Edge> list = Arrays.asList(BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getViewGraph().getEdgeArray());
            if (list == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public Node getSourceNode(Edge edge) {
            Node node = edge.source();
            if (node == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(2);
            }
            return node;
        }

        @Override
        @NotNull
        public Node getTargetNode(Edge edge) {
            Node node = edge.target();
            if (node == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(3);
            }
            return node;
        }

        @Override
        @NotNull
        public String getNodeName(Node node) {
            String string = BaseGraphStructureViewBuilder.this.getModelGraphNodeObject(node).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getNodeName(it)).orElse("");
            if (string == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getEdgeName(Edge edge) {
            String string = BaseGraphStructureViewBuilder.this.getModelGraphEdgeObject(edge).map(it -> BaseGraphStructureViewBuilder.this.getMainBuilder().getEdgeName(it)).orElse("");
            if (string == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        public Edge createEdge(@NotNull Node from, @NotNull Node to) {
            if (from == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(6);
            }
            if (to == null) {
                LocalViewGraphDataModel.$$$reportNull$$$0(7);
            }
            return null;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphDataModel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEdgeName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewGraphDataModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createEdge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected final class LocalViewMouseWheelListener
    extends BaseGraphMouseWheelListener {
        LocalViewMouseWheelListener(GraphBuilder<?, ?> builder) {
            if (builder == null) {
                LocalViewMouseWheelListener.$$$reportNull$$$0(0);
            }
            super(builder);
        }

        @Override
        protected void doZoomChange() {
            GraphBuilder localViewBuilder = BaseGraphStructureViewBuilder.this.getLocalViewBuilder();
            Graph2DView localView = localViewBuilder.getView();
            double currentZoomDelta = this.getCurrentZoomDelta();
            Point lastZoomPoint = this.getLastZoomPoint();
            double newZoom = MathUtil.clamp((double)(localView.getZoom() + currentZoomDelta), (double)0.1, (double)20.0);
            double oldX = localView.toWorldCoordX(lastZoomPoint.x);
            double oldY = localView.toWorldCoordY(lastZoomPoint.y);
            localViewBuilder.setZoom(newZoom);
            double newX = localView.toWorldCoordX(lastZoomPoint.x);
            double newY = localView.toWorldCoordY(lastZoomPoint.y);
            double cx = localView.getCenter().getX();
            double cy = localView.getCenter().getY();
            localView.setCenter(cx + oldX - newX, cy + oldY - newY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewMouseWheelListener", "<init>"));
        }
    }

    protected final class LocalViewControllerMode
    extends BaseGraphViewControllerMode {
        LocalViewControllerMode(@NotNull GraphBuilder<?, ?> builder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher, @NotNull EditMode editMode, @NotNull NavigationMode navigationMode, MagnifierViewMode zoomMode) {
            if (builder == null) {
                LocalViewControllerMode.$$$reportNull$$$0(0);
            }
            if (dispatcher == null) {
                LocalViewControllerMode.$$$reportNull$$$0(1);
            }
            if (editMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(2);
            }
            if (navigationMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(3);
            }
            if (zoomMode == null) {
                LocalViewControllerMode.$$$reportNull$$$0(4);
            }
            super(builder, dispatcher, editMode, navigationMode, zoomMode);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                LocalViewControllerMode.$$$reportNull$$$0(5);
            }
            super.mouseClicked(mouseEvent);
            HitInfo hitInfo = this.getHitInfo(mouseEvent);
            Graph2DView mainView = BaseGraphStructureViewBuilder.this.getMainBuilder().getView();
            if (hitInfo.getHitNode() != null) {
                this.onNodeClick(hitInfo, mainView);
            } else if (hitInfo.getHitEdge() != null) {
                this.onEdgeClick(hitInfo, mainView);
            }
        }

        private void onEdgeClick(@NotNull HitInfo hitInfo, @NotNull Graph2DView mainView) {
            if (hitInfo == null) {
                LocalViewControllerMode.$$$reportNull$$$0(6);
            }
            if (mainView == null) {
                LocalViewControllerMode.$$$reportNull$$$0(7);
            }
            Graph2D modelGraph = mainView.getGraph2D();
            Edge modelEdge = BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModelEdge(hitInfo.getHitEdge());
            if (modelEdge != null && GraphManager.getGraphManager().arePhysicalyEqual(modelEdge.getGraph(), modelGraph)) {
                NodeRealizer snr = modelGraph.getRealizer(modelEdge.source());
                NodeRealizer tnr = modelGraph.getRealizer(modelEdge.target());
                Point2D.Double sCenter = new Point2D.Double(snr.getCenterX(), snr.getCenterY());
                Point2D.Double tCenter = new Point2D.Double(tnr.getCenterX(), tnr.getCenterY());
                double minZoom = Math.min((double)mainView.getJComponent().getWidth() / (snr.getWidth() + tnr.getWidth() + Math.abs(sCenter.x - tCenter.x)), (double)mainView.getJComponent().getHeight() / (snr.getHeight() + tnr.getHeight() + Math.abs(sCenter.y - tCenter.y)));
                GraphAnimationService.getInstance().focusView(mainView, Math.min(mainView.getZoom(), minZoom), new Point2D.Double((sCenter.x + tCenter.x) * 0.5, (sCenter.y + tCenter.y) * 0.5), true);
                modelGraph.unselectAll();
                modelGraph.setSelected(modelEdge, true);
                modelGraph.updateViews();
            }
        }

        private void onNodeClick(@NotNull HitInfo hitInfo, @NotNull Graph2DView mainView) {
            if (hitInfo == null) {
                LocalViewControllerMode.$$$reportNull$$$0(8);
            }
            if (mainView == null) {
                LocalViewControllerMode.$$$reportNull$$$0(9);
            }
            Graph2D modelGraph = mainView.getGraph2D();
            Node modelNode = BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModelNode(hitInfo.getHitNode());
            if (modelNode != null && GraphManager.getGraphManager().arePhysicalyEqual(modelNode.getGraph(), modelGraph)) {
                modelGraph.unselectAll();
                NodeRealizer nr = modelGraph.getRealizer(modelNode);
                Point2D.Double center = new Point2D.Double(nr.getCenterX(), nr.getCenterY());
                double minZoom = Math.min((double)mainView.getJComponent().getWidth() / (nr.getWidth() + 40.0), (double)mainView.getJComponent().getHeight() / (nr.getHeight() + 40.0));
                GraphAnimationService.getInstance().focusView(mainView, Math.min(minZoom, mainView.getZoom()), center, true);
                modelGraph.setSelected(modelNode, true);
                modelGraph.updateViews();
            }
        }

        @Override
        protected void moveNode(int key) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationMode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "zoomMode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hitInfo";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainView";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalViewControllerMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEdgeClick";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onNodeClick";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class LocalGraphViewControllerBuilder
    extends GraphViewControllerBuilder<LocalGraphViewControllerBuilder> {
        @NotNull
        private final BaseGraphStructureViewBuilder myStructureViewBuilder;

        private LocalGraphViewControllerBuilder(@NotNull BaseGraphStructureViewBuilder structureViewBuilder, @NotNull GraphBuilder<?, ?> builder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
            if (structureViewBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(1);
            }
            if (dispatcher == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(2);
            }
            super(builder, dispatcher);
            this.myStructureViewBuilder = structureViewBuilder;
        }

        @Override
        @NotNull
        protected LocalGraphViewControllerBuilder self() {
            LocalGraphViewControllerBuilder localGraphViewControllerBuilder = this;
            if (localGraphViewControllerBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(3);
            }
            return localGraphViewControllerBuilder;
        }

        @NotNull
        public static LocalGraphViewControllerBuilder beginSetupFor(@NotNull BaseGraphStructureViewBuilder structureViewBuilder, @NotNull GraphBuilder<?, ?> graphBuilder) {
            if (structureViewBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(4);
            }
            if (graphBuilder == null) {
                LocalGraphViewControllerBuilder.$$$reportNull$$$0(5);
            }
            return new LocalGraphViewControllerBuilder(structureViewBuilder, graphBuilder, (EventDispatcher<GraphBuilderListener>)EventDispatcher.create(GraphBuilderListener.class));
        }

        @Override
        public void endSetup() {
            this.setEditModeConstituents(this.getEditMode());
            Graph2DView view = this.getBuilder().getView();
            JComponent canvas = view.getCanvasComponent();
            BaseGraphStructureViewBuilder baseGraphStructureViewBuilder = this.myStructureViewBuilder;
            Objects.requireNonNull(baseGraphStructureViewBuilder);
            LocalViewControllerMode controllerMode = baseGraphStructureViewBuilder.new LocalViewControllerMode(this.getBuilder(), this.getDispatcher(), this.getEditMode(), this.getNavigationMode(), this.getMagnifierViewMode());
            view.addViewMode(controllerMode);
            controllerMode.setupKeyBindingsTo(canvas);
            canvas.addFocusListener(controllerMode);
            BaseGraphStructureViewBuilder baseGraphStructureViewBuilder2 = this.myStructureViewBuilder;
            Objects.requireNonNull(baseGraphStructureViewBuilder2);
            canvas.addMouseWheelListener(baseGraphStructureViewBuilder2.new LocalViewMouseWheelListener(this.getBuilder()));
            controllerMode.initialize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structureViewBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalGraphViewControllerBuilder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$LocalGraphViewControllerBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "beginSetupFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected final class SelectionTrigger
    implements Graph2DSelectionListener {
        @NotNull
        private final Timer myTimer;
        @Nullable
        private Graph2DSelectionEvent myLastEvent;
        private static final int TIMER_DELAY = 100;

        SelectionTrigger() {
            this.myTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (SelectionTrigger.this.myLastEvent != null) {
                        this.handleEvent(SelectionTrigger.this.myLastEvent);
                    }
                }

                private void handleEvent(@NotNull Graph2DSelectionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (e.isNodeSelection()) {
                        BaseGraphStructureViewBuilder.this.updateViewOfSelectedNodes(GraphSelectionService.getInstance().getSelectedNodes(e.getGraph2D()));
                    } else if (e.isEdgeSelection()) {
                        BaseGraphStructureViewBuilder.this.updateViewOfSelectedEdges(GraphSelectionService.getInstance().getSelectedEdges(e.getGraph2D()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$SelectionTrigger$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEvent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myTimer.setRepeats(false);
        }

        @Override
        public void onGraph2DSelectionEvent(@NotNull Graph2DSelectionEvent e) {
            if (e == null) {
                SelectionTrigger.$$$reportNull$$$0(0);
            }
            if (GraphManager.getGraphManager().arePhysicalyEqual(e.getGraph2D(), BaseGraphStructureViewBuilder.this.getCurrentLocalViewCreator().getModel()) && (e.isNodeSelection() || e.isEdgeSelection())) {
                this.myLastEvent = e;
                this.myTimer.restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$SelectionTrigger", "onGraph2DSelectionEvent"));
        }
    }

    protected final class BasicGraphStructureView
    implements StructureView {
        @Nullable
        private final FileEditor myFileEditor;

        private BasicGraphStructureView(FileEditor editor) {
            this.myFileEditor = editor;
        }

        @Nullable
        public FileEditor getFileEditor() {
            return this.myFileEditor;
        }

        public boolean navigateToSelectedElement(boolean requestFocus) {
            return false;
        }

        @NotNull
        public JComponent getComponent() {
            JBSplitter jBSplitter = BaseGraphStructureViewBuilder.this.myComponent;
            if (jBSplitter == null) {
                BasicGraphStructureView.$$$reportNull$$$0(0);
            }
            return jBSplitter;
        }

        public void centerSelectedRow() {
        }

        public void restoreState() {
        }

        public void storeState() {
        }

        @NotNull
        public StructureViewModel getTreeModel() {
            StructureViewModel structureViewModel = OUR_DUMMY_MODEL;
            if (structureViewModel == null) {
                BasicGraphStructureView.$$$reportNull$$$0(1);
            }
            return structureViewModel;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/graph/builder/components/BaseGraphStructureViewBuilder$BasicGraphStructureView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeModel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

