/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

class PerforceChangeListCalculator {
    private final ChangeListManagerGate myAddGate;
    private final PerforceNumberNameSynchronizer mySynchronizer;
    private final ConnectionKey myConnectionKey;

    PerforceChangeListCalculator(Project project, P4Connection connection, ChangeListManagerGate addGate) {
        this.myConnectionKey = connection.getConnectionKey();
        this.myAddGate = addGate;
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(project);
    }

    @NotNull
    ChangeList convert(PerforceChange perforceChange) {
        LocalChangeList list = this.myAddGate.findChangeList(this.mySynchronizer.getName(this.myConnectionKey, perforceChange.getChangeList()));
        Object object = list != null ? list : this.findOrCreateDefaultList();
        if (object == null) {
            PerforceChangeListCalculator.$$$reportNull$$$0(0);
        }
        return object;
    }

    private ChangeList findOrCreateDefaultList() {
        for (String name : LocalChangeList.getAllDefaultNames()) {
            LocalChangeList list = this.myAddGate.findChangeList(name);
            if (list == null) continue;
            return list;
        }
        return this.myAddGate.addChangeList(LocalChangeList.getDefaultName(), "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceChangeListCalculator", "convert"));
    }
}

