/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.switchtoif;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.ArrayList;
import java.util.List;

final class CaseUtil {
    private CaseUtil() {
    }

    private static boolean canBeCaseLabel(JSExpression expression, boolean isStrictEq) {
        if (expression == null) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)expression)) {
            return ExpressionUtil.isConstantExpression((JSExpression)expression, (boolean)isStrictEq);
        }
        if (!ExpressionUtil.isConstantExpression((JSExpression)expression, (boolean)true)) {
            return false;
        }
        if (!(expression instanceof JSReferenceExpression) || isStrictEq) {
            return true;
        }
        PsiElement resolveResult = ((JSReferenceExpression)expression).resolve();
        if (resolveResult instanceof TypeScriptEnumField) {
            return true;
        }
        if (resolveResult instanceof JSInitializerOwner) {
            JSExpression initializer = ((JSInitializerOwner)resolveResult).getInitializerOrStub();
            return initializer != null && JSTypeUtils.isLiteralOrCompositeWithLiteralType((JSType)JSResolveUtil.getExpressionJSType((JSExpression)initializer));
        }
        if (resolveResult instanceof JSTypeOwner) {
            return JSTypeUtils.isLiteralOrCompositeWithLiteralType((JSType)((JSTypeOwner)resolveResult).getJSType());
        }
        return false;
    }

    public static boolean containsHiddenBreak(JSCaseClause caseClause) {
        for (JSSourceElement statement : caseClause.getStatementListItems()) {
            if (!CaseUtil.containsHiddenBreak(statement, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHiddenBreak(List<? extends PsiElement> elements) {
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSStatement) || !CaseUtil.containsHiddenBreak((JSSourceElement)((JSStatement)psiElement), true)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsHiddenBreak(JSSourceElement statement, boolean isTopLevel) {
        if (statement instanceof JSBlockStatement) {
            JSSourceElement[] statements;
            for (JSSourceElement childStatement : statements = ((JSBlockStatement)statement).getStatementListItems()) {
                if (!CaseUtil.containsHiddenBreak(childStatement, false)) continue;
                return true;
            }
        } else {
            if (statement instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)statement;
                return CaseUtil.containsHiddenBreak((JSSourceElement)ifStatement.getThen(), false) || CaseUtil.containsHiddenBreak((JSSourceElement)ifStatement.getElse(), false);
            }
            if (statement instanceof JSBreakStatement) {
                if (isTopLevel) {
                    return false;
                }
                String identifier = ((JSBreakStatement)statement).getLabel();
                return identifier == null || identifier.length() == 0;
            }
        }
        return false;
    }

    public static boolean isUsedByStatementList(JSVariable var, List<? extends PsiElement> elements) {
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSElement) || !VariableAccessUtil.isLocalVariableUsed((JSVariable)var, (PsiElement)psiElement)) continue;
            return true;
        }
        return false;
    }

    public static String findUniqueLabel(JSStatement statement, String baseName) {
        JSStatement ancestor = statement;
        while (ancestor.getParent() != null && !(ancestor instanceof PsiFile)) {
            ancestor = (JSElement)ancestor.getParent();
        }
        if (!CaseUtil.checkForLabel(baseName, (JSElement)ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (CaseUtil.checkForLabel(name = baseName + val, (JSElement)ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, JSElement ancestor) {
        return SyntaxTraverser.psiTraverser((PsiElement)ancestor).filter(JSLabeledStatement.class).filter(s -> name.equals(s.getLabel())).isNotEmpty();
    }

    public static JSExpression getCaseExpression(JSIfStatement statement) {
        JSExpression condition = statement.getCondition();
        List<JSExpression> possibleCaseExpressions = CaseUtil.determinePossibleCaseExpressions(condition);
        if (possibleCaseExpressions != null) {
            for (JSExpression caseExpression : possibleCaseExpressions) {
                if (SideEffectChecker.mayHaveSideEffects((JSExpression)caseExpression)) continue;
                JSIfStatement statementToCheck = statement;
                while (CaseUtil.canBeMadeIntoCase(statementToCheck.getCondition(), caseExpression)) {
                    JSStatement elseBranch = statementToCheck.getElse();
                    if (!(elseBranch instanceof JSIfStatement)) {
                        return caseExpression;
                    }
                    statementToCheck = (JSIfStatement)elseBranch;
                }
            }
        }
        return null;
    }

    private static List<JSExpression> determinePossibleCaseExpressions(JSExpression exp) {
        JSExpression expToCheck = JSParenthesesUtils.stripParentheses((JSExpression)exp);
        ArrayList<JSExpression> out = new ArrayList<JSExpression>(10);
        if (expToCheck instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExp = (JSBinaryExpression)expToCheck;
            IElementType operation = binaryExp.getOperationSign();
            JSExpression lhs = binaryExp.getLOperand();
            JSExpression rhs = binaryExp.getROperand();
            if (operation == null) {
                return ContainerUtil.emptyList();
            }
            if (operation.equals(JSTokenTypes.OROR)) {
                return CaseUtil.determinePossibleCaseExpressions(lhs);
            }
            boolean doubleEq = operation.equals(JSTokenTypes.EQEQ);
            boolean tripleEq = operation.equals(JSTokenTypes.EQEQEQ);
            if (doubleEq || tripleEq) {
                if (CaseUtil.canBeCaseLabel(lhs, tripleEq) && rhs != null) {
                    out.add(rhs);
                }
                if (CaseUtil.canBeCaseLabel(rhs, tripleEq)) {
                    out.add(lhs);
                }
            }
        }
        return out;
    }

    private static boolean canBeMadeIntoCase(JSExpression exp, JSExpression caseExpression) {
        JSExpression expToCheck = JSParenthesesUtils.stripParentheses((JSExpression)exp);
        if (!(expToCheck instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExp = (JSBinaryExpression)expToCheck;
        IElementType operation = binaryExp.getOperationSign();
        JSExpression leftOperand = binaryExp.getLOperand();
        JSExpression rightOperand = binaryExp.getROperand();
        if (operation == null) {
            return false;
        }
        if (operation.equals(JSTokenTypes.OROR)) {
            return CaseUtil.canBeMadeIntoCase(leftOperand, caseExpression) && CaseUtil.canBeMadeIntoCase(rightOperand, caseExpression);
        }
        boolean doubleEq = operation.equals(JSTokenTypes.EQEQ);
        boolean tripleEq = operation.equals(JSTokenTypes.EQEQEQ);
        if (doubleEq || tripleEq) {
            return CaseUtil.canBeCaseLabel(leftOperand, tripleEq) && EquivalenceChecker.expressionsAreEquivalent((JSExpression)caseExpression, (JSExpression)rightOperand) || CaseUtil.canBeCaseLabel(rightOperand, tripleEq) && EquivalenceChecker.expressionsAreEquivalent((JSExpression)caseExpression, (JSExpression)leftOperand);
        }
        return false;
    }
}

