/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeIfAndIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";

    @IntentionName
    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message("trivialif.merge-if-and.display-name", new Object[0]);
        if (string == null) {
            JSMergeIfAndIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("trivialif.merge-if-and.family-name", new Object[0]);
        if (string == null) {
            JSMergeIfAndIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new MergeIfAndPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSMergeIfAndIntention.$$$reportNull$$$0(2);
        }
        assert (element.getParent() != null);
        assert (element.getParent() instanceof JSIfStatement || element instanceof JSIfStatement);
        JSIfStatement parentStatement = (JSIfStatement)(element.getParent() instanceof JSIfStatement ? element.getParent() : element);
        JSIfStatement childStatement = (JSIfStatement)ControlFlowUtils.stripBraces((JSStatement)parentStatement.getThen());
        JSExpression childCondition = childStatement.getCondition();
        JSExpression parentCondition = parentStatement.getCondition();
        String childConditionText = JSParenthesesUtils.getParenthesized((JSExpression)childCondition, (int)14);
        String parentConditionText = JSParenthesesUtils.getParenthesized((JSExpression)parentCondition, (int)14);
        JSStatement childThenBranch = childStatement.getThen();
        String statement = IF_STATEMENT_PREFIX + parentConditionText + " && " + childConditionText + ")" + childThenBranch.getText();
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)parentStatement, (String)statement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergeIfAndPredicate
    implements JSElementPredicate {
        private MergeIfAndPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            if (element == null) {
                MergeIfAndPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)(ifStatement = (JSIfStatement)parent))) {
                return false;
            }
            JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
            JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getElse());
            if (thenBranch == null || elseBranch != null) {
                return false;
            }
            if (!(thenBranch instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement childIfStatement = (JSIfStatement)thenBranch;
            return childIfStatement.getElse() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfAndIntention$MergeIfAndPredicate", "satisfiedBy"));
        }
    }
}

