/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.render;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderingUtil {
    public static final Key<Boolean> ALWAYS_PAINT_SELECTION_AS_FOCUSED = Key.create("ALWAYS_PAINT_SELECTION_AS_FOCUSED");
    @ApiStatus.Experimental
    public static final Key<Boolean> PAINT_HOVERED_BACKGROUND = Key.create("PAINT_HOVERED_BACKGROUND");
    @ApiStatus.Internal
    public static final Key<JComponent> FOCUSABLE_SIBLING = Key.create("FOCUSABLE_SIBLING");
    @ApiStatus.Internal
    public static final Key<Supplier<Color>> CUSTOM_SELECTION_BACKGROUND = Key.create("CUSTOM_SELECTION_BACKGROUND");

    @Nullable
    public static Icon getIcon(@Nullable Icon icon, boolean selected) {
        return !selected || icon == null || StartupUiUtil.isUnderDarcula() ? icon : IconLoader.getDarkIcon(icon, true);
    }

    @NotNull
    public static Color getBackground(@NotNull JList<?> list, boolean selected) {
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(0);
        }
        return selected ? RenderingUtil.getSelectionBackground(list) : RenderingUtil.getBackground(list);
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table, boolean selected) {
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(1);
        }
        return selected ? RenderingUtil.getSelectionBackground(table) : RenderingUtil.getBackground(table);
    }

    @NotNull
    public static Color getBackground(@NotNull JTree tree, boolean selected) {
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(2);
        }
        return selected ? RenderingUtil.getSelectionBackground(tree) : RenderingUtil.getBackground(tree);
    }

    @NotNull
    public static Color getBackground(@NotNull JList<?> list) {
        Color background;
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(3);
        }
        Color color = (background = list.getBackground()) != null ? background : JBUI.CurrentTheme.List.BACKGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table) {
        Color background;
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(5);
        }
        Color color = (background = table.getBackground()) != null ? background : JBUI.CurrentTheme.Table.BACKGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(6);
        }
        return color;
    }

    @NotNull
    public static Color getBackground(@NotNull JTree tree) {
        JTable table;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(7);
        }
        if ((table = RenderingUtil.getTableFor(tree)) != null) {
            return RenderingUtil.getBackground(table);
        }
        Color background = tree.getBackground();
        Color color = background != null ? background : JBUI.CurrentTheme.Tree.BACKGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(8);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JList<?> list) {
        Color background;
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(9);
        }
        Color color = (background = RenderingUtil.getCustomSelectionBackground(list)) != null ? background : JBUI.CurrentTheme.List.Selection.background(RenderingUtil.isFocused(list));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(10);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JTable table) {
        Color background;
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(11);
        }
        Color color = (background = RenderingUtil.getCustomSelectionBackground(table)) != null ? background : JBUI.CurrentTheme.Table.Selection.background(RenderingUtil.isFocused(table));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(12);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionBackground(@NotNull JTree tree) {
        JTable table;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(13);
        }
        if ((table = RenderingUtil.getTableFor(tree)) != null) {
            return RenderingUtil.getSelectionBackground(table);
        }
        Color background = RenderingUtil.getCustomSelectionBackground(tree);
        Color color = background != null ? background : JBUI.CurrentTheme.Tree.Selection.background(RenderingUtil.isFocused(tree));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(14);
        }
        return color;
    }

    @NotNull
    public static Color getForeground(@NotNull JList<?> list, boolean selected) {
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(15);
        }
        return selected ? RenderingUtil.getSelectionForeground(list) : RenderingUtil.getForeground(list);
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table, boolean selected) {
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(16);
        }
        return selected ? RenderingUtil.getSelectionForeground(table) : RenderingUtil.getForeground(table);
    }

    @NotNull
    public static Color getForeground(@NotNull JTree tree, boolean selected) {
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(17);
        }
        return selected ? RenderingUtil.getSelectionForeground(tree) : RenderingUtil.getForeground(tree);
    }

    @NotNull
    public static Color getForeground(@NotNull JList<?> list) {
        Color foreground;
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(18);
        }
        Color color = (foreground = list.getForeground()) != null ? foreground : JBUI.CurrentTheme.List.FOREGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(19);
        }
        return color;
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table) {
        Color foreground;
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(20);
        }
        Color color = (foreground = table.getForeground()) != null ? foreground : JBUI.CurrentTheme.Table.FOREGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(21);
        }
        return color;
    }

    @NotNull
    public static Color getForeground(@NotNull JTree tree) {
        JTable table;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(22);
        }
        if ((table = RenderingUtil.getTableFor(tree)) != null) {
            return RenderingUtil.getForeground(table);
        }
        Color foreground = tree.getForeground();
        Color color = foreground != null ? foreground : JBUI.CurrentTheme.Tree.FOREGROUND;
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(23);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JList<?> list) {
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(24);
        }
        Color color = JBUI.CurrentTheme.List.Selection.foreground(RenderingUtil.isFocused(list));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(25);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JTable table) {
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(26);
        }
        Color color = JBUI.CurrentTheme.Table.Selection.foreground(RenderingUtil.isFocused(table));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(27);
        }
        return color;
    }

    @NotNull
    public static Color getSelectionForeground(@NotNull JTree tree) {
        JTable table;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(28);
        }
        if ((table = RenderingUtil.getTableFor(tree)) != null) {
            return RenderingUtil.getSelectionForeground(table);
        }
        Color color = JBUI.CurrentTheme.Tree.Selection.foreground(RenderingUtil.isFocused(tree));
        if (color == null) {
            RenderingUtil.$$$reportNull$$$0(29);
        }
        return color;
    }

    @ApiStatus.Internal
    public static boolean isHoverPaintingDisabled(@NotNull JComponent component) {
        if (component == null) {
            RenderingUtil.$$$reportNull$$$0(30);
        }
        return Boolean.FALSE.equals(component.getClientProperty(PAINT_HOVERED_BACKGROUND));
    }

    @Nullable
    public static Color getHoverBackground(@NotNull JList<?> list) {
        if (list == null) {
            RenderingUtil.$$$reportNull$$$0(31);
        }
        if (RenderingUtil.isHoverPaintingDisabled(list)) {
            return null;
        }
        return JBUI.CurrentTheme.List.Hover.background(RenderingUtil.isFocused(list));
    }

    @Nullable
    public static Color getHoverBackground(@NotNull JTable table) {
        if (table == null) {
            RenderingUtil.$$$reportNull$$$0(32);
        }
        if (RenderingUtil.isHoverPaintingDisabled(table)) {
            return null;
        }
        return JBUI.CurrentTheme.Table.Hover.background(RenderingUtil.isFocused(table));
    }

    @Nullable
    public static Color getHoverBackground(@NotNull JTree tree) {
        JTable table;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(33);
        }
        if ((table = RenderingUtil.getTableFor(tree)) != null) {
            return RenderingUtil.getHoverBackground(table);
        }
        if (RenderingUtil.isHoverPaintingDisabled(tree)) {
            return null;
        }
        return JBUI.CurrentTheme.Tree.Hover.background(RenderingUtil.isFocused(tree));
    }

    public static boolean isFocused(@NotNull JComponent component) {
        if (component == null) {
            RenderingUtil.$$$reportNull$$$0(34);
        }
        if (RenderingUtil.isFocusedImpl(component)) {
            return true;
        }
        JComponent sibling = UIUtil.getClientProperty((Object)component, FOCUSABLE_SIBLING);
        return sibling != null && RenderingUtil.isFocusedImpl(sibling);
    }

    private static boolean isFocusedImpl(@NotNull JComponent component) {
        if (component == null) {
            RenderingUtil.$$$reportNull$$$0(35);
        }
        return component.hasFocus() || UIUtil.isClientPropertyTrue(component, ALWAYS_PAINT_SELECTION_AS_FOCUSED);
    }

    private static JTable getTableFor(@NotNull JTree tree) {
        JComponent sibling;
        if (tree == null) {
            RenderingUtil.$$$reportNull$$$0(36);
        }
        return (sibling = UIUtil.getClientProperty((Object)tree, FOCUSABLE_SIBLING)) instanceof JTable ? (JTable)sibling : null;
    }

    private static Color getCustomSelectionBackground(@NotNull JComponent component) {
        Supplier<Color> supplier;
        if (component == null) {
            RenderingUtil.$$$reportNull$$$0(37);
        }
        return (supplier = UIUtil.getClientProperty((Object)component, CUSTOM_SELECTION_BACKGROUND)) == null ? null : supplier.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 16: 
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 17: 
            case 22: 
            case 28: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/render/RenderingUtil";
                break;
            }
            case 30: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/render/RenderingUtil";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackground";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBackground";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeground";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBackground";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionBackground";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getForeground";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionForeground";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isHoverPaintingDisabled";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getHoverBackground";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFocused";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isFocusedImpl";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTableFor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSelectionBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

