/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.ArrayBackedFMap;
import com.intellij.util.fmap.EmptyFMap;
import com.intellij.util.fmap.MapBackedFMap;
import com.intellij.util.fmap.OneKeyFMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="toMap().entrySet().toArray()")
@ApiStatus.NonExtendable
public interface FMap<@NotNull K, @NotNull V> {
    public static <K, V> FMap<K, V> empty() {
        return EmptyFMap.INSTANCE;
    }

    @NotNull
    public static <K, V> FMap<K, V> of(K key, V value) {
        return new OneKeyFMap<K, V>(key, value);
    }

    @NotNull
    public static <K, V> FMap<K, V> of(K key1, V value1, K key2, V value2) {
        if (!1.$assertionsDisabled && key1.equals(key2)) {
            throw new AssertionError();
        }
        return new TwoKeysFMap<K, V>(key1, value1, key2, value2);
    }

    @NotNull
    public static <K, V> FMap<K, V> from(@NotNull Map<K, V> map2) {
        if (map2 == null) {
            FMap.$$$reportNull$$$0(0);
        }
        if (map2.isEmpty()) {
            FMap<K, V> fMap = FMap.empty();
            if (fMap == null) {
                FMap.$$$reportNull$$$0(1);
            }
            return fMap;
        }
        if (map2.size() == 1) {
            Map.Entry<K, V> entry = map2.entrySet().iterator().next();
            return FMap.of(entry.getKey(), entry.getValue());
        }
        if (map2.size() == 2) {
            Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
            Map.Entry<K, V> entry1 = iterator.next();
            Map.Entry<K, V> entry2 = iterator.next();
            return FMap.of(entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
        }
        if (map2.size() <= 8) {
            return new ArrayBackedFMap<K, V>(map2);
        }
        return new MapBackedFMap<K, V>(new HashMap<K, V>(map2));
    }

    @NotNull
    public FMap<K, V> plus(K var1, V var2);

    @NotNull
    public FMap<K, V> minus(K var1);

    @Nullable
    public V get(K var1);

    public boolean isEmpty();

    public int size();

    @NotNull
    public Collection<K> keys();

    @NotNull
    public Map<K, V> toMap();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/fmap/FMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/fmap/FMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

