/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.CLionClangInspectionBridgeProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAppliedDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlightKey;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangInfoProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangWarningProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangdQuickFix;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.lsp4j.CodeAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangErrorsAnnotatorPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final int HINTS_LIMIT = 32;
    private static final int HINT_LENGTH_LIMIT = 240;
    private static final Logger LOG = Logger.getInstance((String)ClangErrorsAnnotatorPass.class.getName());
    private static final IdentityHashMap<HighlightSeverity, Boolean> SUPPRESSED = new IdentityHashMap();
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final TextRange myRestrictRange;
    @NotNull
    private final HighlightInfoHolder myHolder;
    private int myParseVersion;

    public ClangErrorsAnnotatorPass(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Document document, @NotNull TextRange restrictRange) {
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(2);
        }
        if (restrictRange == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(3);
        }
        super(file.getProject(), document);
        this.myParseVersion = -1;
        this.myFile = file;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHolder = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(4);
        }
        this.myHolder.clear();
        this.myParseVersion = -1;
        if (!ClangUtils.isClangdOn(this.myProject)) {
            return;
        }
        if (!ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        if (!ClangUtils.isClangdShowErrors(this.myProject)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ClangAppliedDiagnostic.clearDiagnostics((UserDataHolder)this.myFile);
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            this.myParseVersion = response.getVersion();
            ClangUtils.traceClangd(LOG, "Getting highlightings and diagnostics for " + virtualFile.getName() + "[" + this.myParseVersion + "].");
            CompletableFuture highlightingsFuture = response.getHighlightings();
            List highlightings = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), highlightingsFuture, "highlightings");
            if (highlightings != null) {
                this.makeHighlightings(service.getClangIdeFacade(), highlightings);
            }
            CompletableFuture diagnosticsFuture = response.getDiagnostics();
            List diagnostics = (List)ClangErrorsAnnotatorPass.waitForClangFuture(this.myProject, virtualFile, response.getVersion(), diagnosticsFuture, "diagnostics");
            if (diagnostics != null) {
                Trustworthiness trustworthiness = response.getTrustworthiness();
                this.makeAnnotations(service.getClangIdeFacade(), trustworthiness, diagnostics);
            }
        });
    }

    @Nullable
    private static <T> T waitForClangFuture(@NotNull Project project, @NotNull VirtualFile virtualFile, int curFileVersion, @NotNull Future<Supplier<T>> future, @NonNls @NotNull String waitingForWhat) {
        if (project == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(6);
        }
        if (future == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(7);
        }
        if (waitingForWhat == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(8);
        }
        try {
            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (long)Long.MAX_VALUE, (String)waitingForWhat);
            if (supplier != null) {
                ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                return supplier.get();
            }
            ClangUtils.warnClangd(LOG, waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
        }
        catch (IndexOutOfBoundsException ex) {
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
            int version = service.getVersion(virtualFile);
            LOG.error("Got IOOBE when applying " + waitingForWhat + " for version " + curFileVersion + " while the latest version is [" + version + "]", (Throwable)ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] took too much time.");
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.warnClangd(LOG, "Waiting for " + waitingForWhat + " for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ex.getMessage(), ex);
        }
        return null;
    }

    private void makeAnnotations(@NotNull ClangIdeFacade facade, @NotNull Trustworthiness trustworthiness, @Nullable List<ClangDiagnostic> diags) {
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(9);
        }
        if (trustworthiness == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(10);
        }
        if (!ContainerUtil.isEmpty(diags)) {
            ClangErrorsAnnotatorPass.filterDiagnostics(this.myFile, trustworthiness, diags).stream().sorted((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            }).forEachOrdered(diag -> {
                HighlightInfo annotation = ClangErrorsAnnotatorPass.makeAnnotation(facade, diag, this.myFile, this.myEditor.getDocument(), this.myHolder);
                if (annotation != null) {
                    ClangAppliedDiagnostic.putDiagnostic((UserDataHolder)this.myFile, annotation, diag);
                }
            });
        }
    }

    private void makeHighlightings(@NotNull ClangIdeFacade facade, @Nullable List<ClangHighlighting> highlightings) {
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(11);
        }
        if (!ContainerUtil.isEmpty(highlightings)) {
            ArrayList<ClangHighlighting> sortedHighlightings = new ArrayList<ClangHighlighting>(highlightings);
            sortedHighlightings.sort((l, r) -> {
                int byLine = l.getStartLine() - r.getStartLine();
                return byLine != 0 ? byLine : l.getStartColumn() - r.getStartColumn();
            });
            for (ClangHighlighting highlighting : sortedHighlightings) {
                this.makeHighlighting(highlighting, facade.getFileFacade(this.myFile.getVirtualFile(), this.myEditor.getDocument()), this.myHolder);
            }
        }
    }

    @Nullable
    public static HighlightInfo makeAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Document document, @NotNull HighlightInfoHolder holder) {
        ClangFileFacade fileFacade;
        HighlightInfo specialAnnotation;
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(12);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(13);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(14);
        }
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(16);
        }
        if ((specialAnnotation = ClangErrorsAnnotatorPass.makeSpecialAnnotation(facade, diagnostic, file, fileFacade = facade.getFileFacade(file.getViewProvider().getVirtualFile(), document), holder)) != null) {
            return specialAnnotation;
        }
        return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade, diagnostic, file, fileFacade, holder, null);
    }

    @Nullable
    private static HighlightInfo makeSpecialAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder) {
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(17);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(18);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(19);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(20);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(21);
        }
        String code = diagnostic.getCode();
        if (ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diagnostic)) {
            String inspectionName;
            Class<? extends OCInspectionBase> UIInspectionCls = ClangdBridge.getUnusedIncludesInspection();
            String string = inspectionName = UIInspectionCls != null ? OCInspectionUtil.getInspectionShortName(UIInspectionCls) : "UnusedIncludes";
            if (inspectionName == null) {
                return null;
            }
            assert (code != null) : "to fix the warning";
            CLionClangInspectionBridgeProblemGroup problemGroup = new CLionClangInspectionBridgeProblemGroup(inspectionName, code);
            return ClangErrorsAnnotatorPass.makeSimpleAnnotation(facade, diagnostic, file, fileFacade, holder, problemGroup);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo makeSimpleAnnotation(@NotNull ClangIdeFacade facade, @NotNull ClangDiagnostic diagnostic, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder, @Nullable ProblemGroup problemGroup) {
        TextRange clangRange;
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(22);
        }
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(23);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(24);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(25);
        }
        if (holder == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(26);
        }
        if ((clangRange = ClangErrorsAnnotatorPass.createClangTextRange(diagnostic, fileFacade)) == null) {
            return null;
        }
        String diagnosticMessage = diagnostic.getMessage();
        List<String> sufficesToRemove = Arrays.asList(" (fix available)", " (fixes available)");
        for (String s : sufficesToRemove) {
            if (!diagnosticMessage.endsWith(s)) continue;
            diagnosticMessage = diagnosticMessage.substring(0, diagnosticMessage.length() - s.length());
        }
        String tooltip = ClangErrorsAnnotatorPass.renderTooltip(facade, diagnosticMessage, diagnostic.getNotes(), file, fileFacade);
        ArrayList<IntentionWrapper> fixes = new ArrayList<IntentionWrapper>(ContainerUtil.map(diagnostic.getClangdFixits(), f -> new ClangdQuickFix((CodeAction)f)));
        if (problemGroup == null) {
            if (diagnostic.getCode() != null && diagnostic.getCode().startsWith("-W")) {
                problemGroup = new ClangWarningProblemGroup(file, clangRange, diagnostic.getCode());
                if (diagnostic.getClangdFixits().isEmpty() && diagnostic.getClionFixits().isEmpty()) {
                    EmptyIntentionAction fixToRegister = new EmptyIntentionAction(ClangWarningProblemGroup.getClangProblemName());
                    fixes.add(new IntentionWrapper((IntentionAction)fixToRegister, file));
                }
            } else {
                problemGroup = new ClangErrorProblemGroup(diagnostic.getCode());
            }
        }
        HighlightInfoType highlightInfoType = ClangErrorsAnnotatorPass.getHighlightInfoType(diagnostic, file.getProject());
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(clangRange).description(diagnosticMessage).escapedToolTip(tooltip).problemGroup(problemGroup);
        if (ClangErrorsAnnotatorPass.isAnnotationAtEndOfLine((Segment)clangRange, fileFacade.getText())) {
            builder.endOfLine();
        }
        HighlightInfo clangAnnotation = builder.create();
        holder.add(clangAnnotation);
        QuickFixAction.registerQuickFixActions((HighlightInfo)clangAnnotation, (TextRange)clangRange, fixes);
        return clangAnnotation;
    }

    private void makeHighlighting(@NotNull ClangHighlighting highlighting, @NotNull ClangFileFacade fileFacade, @NotNull HighlightInfoHolder holder) {
        block11: {
            TextRange clangRange;
            if (highlighting == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(27);
            }
            if (fileFacade == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(28);
            }
            if (holder == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(29);
            }
            if ((clangRange = ClangErrorsAnnotatorPass.createClangTextRange(highlighting, fileFacade)) == null) {
                return;
            }
            if (clangRange.getLength() > 0) {
                try {
                    EditorColorsScheme scheme;
                    Field field = OCHighlightingKeys.class.getDeclaredField(highlighting.getType());
                    Object textAttributesKey = field.get(OCHighlightingKeys.class);
                    if ((textAttributesKey == OCHighlightingKeys.PARAMETER || textAttributesKey == OCHighlightingKeys.LOCAL_VARIABLE) && RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)(scheme = EditorColorsManager.getInstance().getGlobalScheme()), (Language)this.myFile.getLanguage())) {
                        return;
                    }
                    if (!(textAttributesKey instanceof TextAttributesKey)) {
                        throw new IllegalArgumentException("Incorrect highlighting type " + highlighting.getType());
                    }
                    TextAttributesKey key = (TextAttributesKey)textAttributesKey;
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).problemGroup((ProblemGroup)new ClangInfoProblemGroup()).range(clangRange).textAttributes(key).create();
                    holder.add(info);
                }
                catch (NoSuchFieldException e) {
                    assert (false) : "Unknown highlighting type: " + highlighting.getType();
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)("Can't get highlighting type " + highlighting.getType()));
                }
            }
        }
    }

    public void doApplyInformationToEditor() {
        if (ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangdShowErrors(this.myProject) && this.myParseVersion >= 0) {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            ClangUtils.traceClangd(LOG, "Applying diags for " + virtualFile.getName() + "[" + this.myParseVersion + "].");
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        for (int i2 = 0; i2 < this.myHolder.size(); ++i2) {
            HighlightInfo info = this.myHolder.get(i2);
            highlights.add(info);
        }
        this.updateHighlights(highlights);
    }

    private void updateHighlights(@NotNull List<HighlightInfo> newHighlights) {
        if (newHighlights == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(30);
        }
        HashMap<ClangHighlightKey, HighlightInfo> oldHighlightsMap = new HashMap<ClangHighlightKey, HighlightInfo>();
        DaemonCodeAnalyzerEx.processHighlights((Document)this.myDocument, (Project)this.myFile.getProject(), null, (int)0, (int)this.myFile.getTextLength(), higlightInfo -> {
            if (higlightInfo.getProblemGroup() instanceof ClangProblemGroup) {
                oldHighlightsMap.put(new ClangHighlightKey((HighlightInfo)higlightInfo), (HighlightInfo)higlightInfo);
            }
            return true;
        });
        List<HighlightInfo> mergedHighlights = this.mergeHighlights(newHighlights, oldHighlightsMap);
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), mergedHighlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @NotNull
    private List<HighlightInfo> mergeHighlights(@NotNull List<HighlightInfo> newHighlights, @NotNull Map<ClangHighlightKey, HighlightInfo> oldHighlightsMap) {
        if (newHighlights == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(31);
        }
        if (oldHighlightsMap == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(32);
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(newHighlights.size());
        for (HighlightInfo newHiglight : newHighlights) {
            if (this.myRestrictRange.containsOffset(newHiglight.getStartOffset()) && this.myRestrictRange.containsOffset(newHiglight.getEndOffset())) {
                result.add(newHiglight);
                continue;
            }
            HighlightInfo oldHighlight = oldHighlightsMap.get(new ClangHighlightKey(newHiglight));
            result.add(oldHighlight != null ? ClangErrorsAnnotatorPass.mergeHighlights(newHiglight, oldHighlight, this.myDocument, this.getColorsScheme()) : newHiglight);
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private static List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(34);
        }
        if (trustworthiness == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(35);
        }
        if (diags == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(36);
        }
        List list = ContainerUtil.filter(diags, diag -> {
            HighlightSeverity severity = ClangErrorsAnnotatorPass.getHighlightSeverity(diag);
            if (SUPPRESSED.containsKey(severity)) {
                return false;
            }
            if (ClangErrorsAnnotatorPass.isIgnoredDiagnostic(diag)) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            if (severity == HighlightSeverity.ERROR && (trustworthiness.hasNoCompilationCommand() || trustworthiness.isCompilationCommandGuessed())) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            if (trustworthiness.hasNoTarget() && diag.getCode() != null) {
                switch (diag.getCode()) {
                    case "pragma_options_align_mac68k_target_unsupported": 
                    case "tls_var_aligned_over_maximum": 
                    case "seh_try_unsupported": 
                    case "asm_invalid_global_var_reg": 
                    case "asm_unknown_register_name": 
                    case "builtin_target_unsupported": 
                    case "type_unsupported": 
                    case "objc_method_unsupported_param_ret_type": 
                    case "attribute_unsupported": 
                    case "attribute_section_invalid_for_target": 
                    case "atomic_load_store_uses_lib": {
                        ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                        return false;
                    }
                }
            }
            if (ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diag) && !OCInspectionUtil.isInspectionEnabled((Project)file.getProject(), ClangdBridge.getUnusedIncludesInspection())) {
                ClangErrorsAnnotatorPass.reportSuppressed(file, diag);
                return false;
            }
            return true;
        });
        if (list == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static void reportSuppressed(@NotNull PsiFile file, @NotNull ClangDiagnostic diag) {
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(38);
        }
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(39);
        }
        String path = file.getVirtualFile() != null ? file.getVirtualFile().getPath() : "<no-file>";
        String message = "suppressed [" + diag.getCode() + "] " + path + ": " + diag.getMessage();
        if (ClangErrorsAnnotatorPass.isDriverDiagnostic(diag) || ClangErrorsAnnotatorPass.isTargetRelatedDiagnostic(diag)) {
            LOG.warn(message);
        } else {
            ClangUtils.warnClangd(LOG, message);
        }
    }

    private static boolean isAnnotationAtEndOfLine(@NotNull Segment annotation, @NotNull CharSequence text) {
        if (annotation == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(40);
        }
        if (text == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(41);
        }
        if (annotation.getStartOffset() != annotation.getEndOffset()) {
            return false;
        }
        if (text.length() <= annotation.getStartOffset()) {
            return true;
        }
        char firstChar = text.charAt(annotation.getStartOffset());
        return firstChar == '\n' || firstChar == '\r';
    }

    @Nullable
    private static TextRange createClangTextRange(@NotNull ClangDiagnostic diag, @NotNull ClangFileFacade helper) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(42);
        }
        if (helper == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(43);
        }
        CidrConcurrentUtilsKt.checkCanceled();
        try {
            int startLineOffset = helper.getLineStartOffset(diag.getStartLine());
            int endLineOffset = helper.getLineStartOffset(diag.getEndLine());
            return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static TextRange createClangTextRange(@NotNull ClangHighlighting diag, @NotNull ClangFileFacade helper) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(44);
        }
        if (helper == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(45);
        }
        CidrConcurrentUtilsKt.checkCanceled();
        try {
            int startLineOffset = helper.getLineStartOffset(diag.getStartLine());
            int endLineOffset = helper.getLineStartOffset(diag.getEndLine());
            return new TextRange(startLineOffset + diag.getStartColumn(), endLineOffset + diag.getEndColumn());
        }
        catch (IndexOutOfBoundsException ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(46);
        }
        HighlightSeverity severity = diag.getSeverity() == HighlightSeverity.ERROR ? HighlightSeverity.ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? HighlightSeverity.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION ? HighlightSeverity.WEAK_WARNING : HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING));
        HighlightSeverity highlightSeverity = severity;
        if (highlightSeverity == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(47);
        }
        return highlightSeverity;
    }

    @NotNull
    public static ProblemHighlightType clangdSeverity2ProblemHighlightType(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(48);
        }
        ProblemHighlightType type = ClangErrorsAnnotatorPass.isUnusedIncludeDirectiveDiagnostic(diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangErrorsAnnotatorPass.isUnusedDiagnostic(diag) ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : (ClangErrorsAnnotatorPass.isUnresolvedIdentifierDiagnostic(diag) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : (diag.getSeverity() == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : (diag.getSeverity() == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (diag.getSeverity() == HighlightSeverity.INFORMATION ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING)))));
        ProblemHighlightType problemHighlightType = type;
        if (problemHighlightType == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(49);
        }
        return problemHighlightType;
    }

    @NotNull
    private static HighlightInfoType getHighlightInfoType(@NotNull ClangDiagnostic diag, @NotNull Project project) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(50);
        }
        if (project == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(51);
        }
        ProblemHighlightType type = ClangErrorsAnnotatorPass.clangdSeverity2ProblemHighlightType(diag);
        HighlightSeverity severity = ClangErrorsAnnotatorPass.getHighlightSeverity(diag);
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
        if (highlightInfoType == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(52);
        }
        return highlightInfoType;
    }

    private static boolean isUnresolvedIdentifierDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name;
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(53);
        }
        if ((name = diagnostic.getCode()) != null) {
            switch (name) {
                case "undeclared_var_use": 
                case "undeclared_var_use_suggest": 
                case "no_member": 
                case "unknown_typename": 
                case "unknown_typename_suggest": 
                case "-Wimplicit-function-declaration": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isUnusedDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        String name;
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(54);
        }
        return (name = diagnostic.getCode()) != null && (name.startsWith("warn_unused_") || name.startsWith("-Wunused"));
    }

    private static boolean isUnusedIncludeDirectiveDiagnostic(@NotNull ClangDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(55);
        }
        return StringUtil.equals((CharSequence)"clion_unused_include", (CharSequence)diagnostic.getCode());
    }

    public static boolean isIgnoredDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(56);
        }
        return ClangErrorsAnnotatorPass.isDriverDiagnostic(diag) || ClangErrorsAnnotatorPass.isTargetRelatedDiagnostic(diag) || ClangErrorsAnnotatorPass.isUnknownWarningOptionDiagnostic(diag) || ClangErrorsAnnotatorPass.isFromIncludedFile(diag);
    }

    private static boolean isDriverDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(57);
        }
        return diag.getCode() != null && diag.getCode().startsWith("drv_");
    }

    private static boolean isTargetRelatedDiagnostic(@NotNull ClangDiagnostic diag) {
        String code;
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(58);
        }
        if ((code = diag.getCode()) != null) {
            switch (code) {
                case "target_unknown_abi": 
                case "target_unknown_cpu": 
                case "target_unknown_fpmath": {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isUnknownWarningOptionDiagnostic(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(59);
        }
        return Objects.equals(diag.getCode(), "-Wunknown-warning-option");
    }

    private static boolean isFromIncludedFile(@NotNull ClangDiagnostic diag) {
        if (diag == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(60);
        }
        return StringUtil.startsWith((CharSequence)diag.getMessage(), (CharSequence)"In included file:");
    }

    @NotNull
    @NlsSafe
    private static String renderTooltip(@NotNull ClangIdeFacade facade, @NlsSafe @NotNull String message, @Nullable List<String> notes, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade) {
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(61);
        }
        if (message == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(62);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(63);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(64);
        }
        HtmlBuilder tooltip = new HtmlBuilder();
        tooltip.append(message);
        if (notes != null) {
            int counter = 0;
            for (String note : notes) {
                tooltip.br();
                if (++counter >= 32) {
                    tooltip.append("...");
                    break;
                }
                ClangPreparedNote clangNote = ClangErrorsAnnotatorPass.parseAndPrepareNote(facade, note, file, fileFacade);
                if (clangNote != null) {
                    tooltip.appendLink("#navigation/" + clangNote.path + ":" + clangNote.offset, StringUtil.shortenTextWithEllipsis((String)clangNote.message, (int)240, (int)0));
                    continue;
                }
                tooltip.append(note);
            }
        }
        String string = tooltip.wrapWithHtmlBody().toString();
        if (string == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Nullable
    private static ClangPreparedNote parseAndPrepareNote(@NotNull ClangIdeFacade facade, @NotNull String note, @NotNull PsiFile file, @NotNull ClangFileFacade fileFacade) {
        if (facade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(66);
        }
        if (note == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(67);
        }
        if (file == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(68);
        }
        if (fileFacade == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(69);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ClangLanguageServiceUtils.ClangNote parsedNote = ClangLanguageServiceUtils.parseNote(note);
        if (parsedNote != null) {
            String path = parsedNote.path;
            if (path.contentEquals(file.getName())) {
                path = file.getVirtualFile().getPath();
            } else {
                VirtualFile vf = CidrLangUtil.findBestFile((Project)file.getProject(), (String)parsedNote.path, (int)parsedNote.line, candidate -> ClangdBridge.isInProjectSourcesOrLibraries(file.getProject(), candidate));
                ClangFileFacade clangFileFacade = fileFacade = vf != null ? facade.getFileFacade(vf) : null;
            }
            if (fileFacade == null) {
                ClangUtils.warnClangd(LOG, "Failed to find a document for " + path);
                return null;
            }
            return new ClangPreparedNote(parsedNote.message, path, fileFacade.getLineStartOffset(Math.max(0, parsedNote.line - 1)) + Math.max(0, parsedNote.character - 1));
        }
        return null;
    }

    @NotNull
    public static HighlightInfo mergeHighlights(@NotNull HighlightInfo newHighlight, @NotNull HighlightInfo oldHighlight, @Nullable Document document, @Nullable EditorColorsScheme scheme) {
        TextAttributes textAttributes;
        ProblemGroup clangProblemGroup;
        if (newHighlight == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(70);
        }
        if (oldHighlight == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(71);
        }
        if (newHighlight.getProblemGroup() instanceof ClangInfoProblemGroup) {
            HighlightInfo highlightInfo = newHighlight;
            if (highlightInfo == null) {
                ClangErrorsAnnotatorPass.$$$reportNull$$$0(72);
            }
            return highlightInfo;
        }
        HighlightInfo.Builder mergedBuilder = HighlightInfo.newHighlightInfo((HighlightInfoType)newHighlight.type).range(new TextRange(newHighlight.startOffset, newHighlight.endOffset)).description(newHighlight.getDescription()).severity(newHighlight.getSeverity());
        if (newHighlight.isAfterEndOfLine()) {
            mergedBuilder.endOfLine();
        }
        if (newHighlight.getToolTip() != null) {
            mergedBuilder.escapedToolTip(newHighlight.getToolTip());
        }
        if ((clangProblemGroup = newHighlight.getProblemGroup()) != null) {
            mergedBuilder.problemGroup(clangProblemGroup);
        }
        if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes = oldHighlight.getTextAttributes(null, scheme), document, newHighlight.startOffset, newHighlight.endOffset)) {
            mergedBuilder.textAttributes(textAttributes);
        } else {
            textAttributes = newHighlight.getTextAttributes(null, scheme);
            if (ClangErrorsAnnotatorPass.canApplyTextAttributes(textAttributes, document, newHighlight.startOffset, newHighlight.endOffset)) {
                mergedBuilder.textAttributes(textAttributes);
            }
        }
        HighlightInfo mergedHighlight = mergedBuilder.createUnconditionally();
        List fixes = oldHighlight.quickFixActionRanges;
        if (fixes != null) {
            TextRange range = new TextRange(newHighlight.getStartOffset(), newHighlight.getEndOffset());
            for (Pair fix : fixes) {
                String displayName = ((HighlightInfo.IntentionActionDescriptor)fix.first).getDisplayName();
                HighlightDisplayKey displayKey = displayName != null ? HighlightDisplayKey.find((String)displayName) : null;
                mergedHighlight.registerFix(((HighlightInfo.IntentionActionDescriptor)fix.first).getAction(), null, displayName, range, displayKey);
            }
        }
        HighlightInfo highlightInfo = mergedHighlight;
        if (highlightInfo == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(73);
        }
        return highlightInfo;
    }

    private static boolean canApplyTextAttributes(@Nullable TextAttributes textAttributes, @Nullable Document document, int from, int to) {
        if (textAttributes == null) {
            return false;
        }
        if (document == null) {
            return true;
        }
        return ClangErrorsAnnotatorPass.hasVisibleUnderline(textAttributes) || ClangErrorsAnnotatorPass.hasVisibleCharacters(document, from, to);
    }

    private static boolean hasVisibleUnderline(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(74);
        }
        return attributes.getErrorStripeColor() != null;
    }

    private static boolean hasVisibleCharacters(@NotNull Document document, int from, int to) {
        if (document == null) {
            ClangErrorsAnnotatorPass.$$$reportNull$$$0(75);
        }
        assert (from <= to) : "Why 'from' offset is greater than 'to' offset?";
        if (from == to) {
            return false;
        }
        CharSequence sequence = document.getImmutableCharSequence();
        for (int offset = from; offset < to; ++offset) {
            if (Character.isWhitespace(sequence.charAt(offset))) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPRESSED.put(HighlightSeverity.INFORMATION, true);
        SUPPRESSED.put(HighlightSeverity.WEAK_WARNING, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 37: 
            case 47: 
            case 49: 
            case 52: 
            case 65: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 37: 
            case 47: 
            case 49: 
            case 52: 
            case 65: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 15: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingForWhat";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 22: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 16: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFacade";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighting";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHighlights";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldHighlightsMap";
                break;
            }
            case 33: 
            case 37: 
            case 47: 
            case 49: 
            case 52: 
            case 65: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diags";
                break;
            }
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diag";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHighlight";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldHighlight";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass";
                break;
            }
            case 33: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeHighlights";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDiagnostics";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "clangdSeverity2ProblemHighlightType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForClangFuture";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeHighlightings";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotation";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "makeSpecialAnnotation";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeSimpleAnnotation";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "makeHighlighting";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlights";
                break;
            }
            case 31: 
            case 32: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "mergeHighlights";
                break;
            }
            case 33: 
            case 37: 
            case 47: 
            case 49: 
            case 52: 
            case 65: 
            case 72: 
            case 73: {
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "filterDiagnostics";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "reportSuppressed";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationAtEndOfLine";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createClangTextRange";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightSeverity";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "clangdSeverity2ProblemHighlightType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedIdentifierDiagnostic";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedDiagnostic";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedIncludeDirectiveDiagnostic";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredDiagnostic";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isDriverDiagnostic";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isTargetRelatedDiagnostic";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownWarningOptionDiagnostic";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isFromIncludedFile";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "renderTooltip";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "parseAndPrepareNote";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "hasVisibleUnderline";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "hasVisibleCharacters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 37: 
            case 47: 
            case 49: 
            case 52: 
            case 65: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ClangPreparedNote {
        @NlsSafe
        @NotNull
        final String message;
        @NlsSafe
        @NotNull
        final String path;
        final int offset;

        private ClangPreparedNote(@NlsSafe @NotNull String message, @NlsSafe @NotNull String path, int offset) {
            if (message == null) {
                ClangPreparedNote.$$$reportNull$$$0(0);
            }
            if (path == null) {
                ClangPreparedNote.$$$reportNull$$$0(1);
            }
            this.message = message;
            this.path = path;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangErrorsAnnotatorPass$ClangPreparedNote";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

