/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdQuickFix
implements IntentionAction,
LocalQuickFix {
    @NotNull
    private final CodeAction myFixit;

    public ClangdQuickFix(@NotNull CodeAction fixit) {
        if (fixit == null) {
            ClangdQuickFix.$$$reportNull$$$0(0);
        }
        this.myFixit = fixit;
    }

    private void invoke(PsiFile file, @NotNull Project project) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        HashMap<Document, List> editsByDocument = new HashMap<Document, List>();
        for (Map.Entry change : this.myFixit.getEdit().getChanges().entrySet()) {
            Document document;
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)change.getKey());
            if (virtualFile == null || (document = documentManager.getDocument(virtualFile)) == null) continue;
            List edits = editsByDocument.computeIfAbsent(document, d -> new ArrayList());
            edits.addAll((Collection)change.getValue());
        }
        if (editsByDocument.isEmpty()) {
            return;
        }
        for (Map.Entry documentEdits : editsByDocument.entrySet()) {
            Document document = (Document)documentEdits.getKey();
            List edits = (List)documentEdits.getValue();
            edits.stream().sorted(ClangdQuickFix.getEditsComparator()).forEach(edit -> document.replaceString(ClangdQuickFix.getDocOffset(document, edit.getRange().getStart()), ClangdQuickFix.getDocOffset(document, edit.getRange().getEnd()), (CharSequence)edit.getNewText()));
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    @NotNull
    public String getText() {
        String string = this.getTextInternal();
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(5);
        }
        if (FileModificationService.getInstance().prepareFileForWrite(file)) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            this.invoke(file, project);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ClangdQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            ClangdQuickFix.$$$reportNull$$$0(7);
        }
        PsiFile file = descriptor.getPsiElement().getContainingFile();
        this.invoke(file.getProject(), null, file);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = ClangdBundle.message("language.cpp.clangd.quick.fix", new Object[0]);
        if (string == null) {
            ClangdQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @IntentionName
    private String getTextInternal() {
        return StringUtil.capitalize((String)this.myFixit.getTitle());
    }

    @NotNull
    private static Comparator<? super TextEdit> getEditsComparator() {
        Comparator comparator = (o1, o2) -> {
            Position lhsStart = o1.getRange().getStart();
            Position rhsStart = o2.getRange().getStart();
            if (lhsStart.getLine() != rhsStart.getLine()) {
                return rhsStart.getLine() - lhsStart.getLine();
            }
            return rhsStart.getCharacter() - lhsStart.getCharacter();
        };
        if (comparator == null) {
            ClangdQuickFix.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    private static int getDocOffset(@NotNull Document doc, @NotNull Position pos) {
        if (doc == null) {
            ClangdQuickFix.$$$reportNull$$$0(10);
        }
        if (pos == null) {
            ClangdQuickFix.$$$reportNull$$$0(11);
        }
        return doc.getLineStartOffset(pos.getLine()) + pos.getCharacter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixit";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangdQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangdQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditsComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDocOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

