/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ProcessServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilterImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessorProviderImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspaceImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangDaemonContextImpl
implements ClangDaemonContext {
    private static final Logger LOG = Logger.getInstance((String)ClangDaemonContextImpl.class.getName());
    private final boolean myIsCustomClangdUsed;
    private final boolean myIsIndexer;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myDescriptor;
    @NotNull
    private final String myClangdModulesPath;
    @NotNull
    private final ClangdSettings mySettings;
    @NotNull
    private final MessageBus myMessageBus;
    private final boolean myOwnMessageBus;
    @NotNull
    private final ClangLocalWorkspace myLocalWorkspace;
    @NotNull
    private final ClangRemoteWorkspace myRemoteWorkspace;
    @NotNull
    private final ClangIdeFacade myIdeFacade;
    @NotNull
    private final ServerConnectionProvider myServerConnectionProvider;
    @NotNull
    private final ClangClientServerProvider myClientServerProvider;
    @NotNull
    private final ClangServerAccessorProvider myServerAccessorProvider;
    @NotNull
    private final ClangCrashHandler myGuard;
    @NotNull
    private final ClangTelemetry myTelemetry;
    @NotNull
    private final ClangUrlConverter myUrlConverter;
    @NotNull
    private final Charset myProtocolCharset;
    @NotNull
    private final ClangMessagesFilter myMessagesFilter;
    private final int myKeepAsts;
    private volatile boolean isStopped;
    private boolean myQobjectDefsSpecified;

    private ClangDaemonContextImpl(boolean isIndexer, boolean isCustomClangd, @NotNull String descriptor, @NotNull Project project, @NotNull ClangdSettings settings, @NotNull ServerConnectionProvider serverConnectionProvider, @NotNull ClangClientServerProvider clientServerProvider, @NotNull ClangServerAccessorProvider serverAccessorProvider, @NotNull ClangUrlConverter converter, @NotNull ClangIdeFacade facade, @Nullable MessageBus messageBus, @NotNull String clangdModulesPath, int keepAsts) {
        if (descriptor == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(2);
        }
        if (serverConnectionProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(3);
        }
        if (clientServerProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(4);
        }
        if (serverAccessorProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(5);
        }
        if (converter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(6);
        }
        if (facade == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(7);
        }
        if (clangdModulesPath == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(8);
        }
        this.isStopped = false;
        this.myQobjectDefsSpecified = false;
        this.myIsIndexer = isIndexer;
        this.myDescriptor = descriptor;
        this.myIsCustomClangdUsed = isCustomClangd;
        this.myProject = project;
        this.mySettings = settings;
        this.myServerConnectionProvider = serverConnectionProvider;
        this.myClientServerProvider = clientServerProvider;
        this.myServerAccessorProvider = serverAccessorProvider;
        this.myUrlConverter = converter;
        this.myIdeFacade = facade;
        this.myMessageBus = messageBus != null ? messageBus : ClangDaemonContextImpl.createDefaultMessageBus(this);
        this.myOwnMessageBus = messageBus == null;
        this.myClangdModulesPath = clangdModulesPath;
        this.myKeepAsts = keepAsts;
        this.myLocalWorkspace = new ClangLocalWorkspaceImpl(converter);
        this.myRemoteWorkspace = new ClangRemoteWorkspaceImpl();
        this.myGuard = new ClangCrashHandler(this);
        this.myTelemetry = new ClangTelemetry(this);
        this.myProtocolCharset = StandardCharsets.UTF_8;
        this.myMessagesFilter = new ClangMessagesFilterImpl(this);
    }

    @Override
    public boolean isCustomClangdUsed() {
        return this.myIsCustomClangdUsed;
    }

    @Override
    @NotNull
    @NonNls
    public String getDescriptor() {
        String string = this.myDescriptor;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Override
    public boolean isIndexer() {
        return this.myIsIndexer;
    }

    @Override
    @NotNull
    public String getClangdModulesPath() {
        String string = this.myClangdModulesPath;
        if (string == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public ClangdSettings getSettings() {
        ClangdSettings clangdSettings = this.mySettings;
        if (clangdSettings == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(12);
        }
        return clangdSettings;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(13);
        }
        return messageBus;
    }

    @Override
    @NotNull
    public ClangLocalWorkspace getLocalWorkspace() {
        ClangLocalWorkspace clangLocalWorkspace = this.myLocalWorkspace;
        if (clangLocalWorkspace == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(14);
        }
        return clangLocalWorkspace;
    }

    @Override
    @NotNull
    public ClangRemoteWorkspace getRemoteWorkspace() {
        ClangRemoteWorkspace clangRemoteWorkspace = this.myRemoteWorkspace;
        if (clangRemoteWorkspace == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(15);
        }
        return clangRemoteWorkspace;
    }

    @Override
    @NotNull
    public ClangIdeFacade getIdeFacade() {
        ClangIdeFacade clangIdeFacade = this.myIdeFacade;
        if (clangIdeFacade == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(16);
        }
        return clangIdeFacade;
    }

    @Override
    @NotNull
    public ServerConnectionProvider getConnectionProvider() {
        ServerConnectionProvider serverConnectionProvider = this.myServerConnectionProvider;
        if (serverConnectionProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(17);
        }
        return serverConnectionProvider;
    }

    @Override
    @NotNull
    public ClangClientServerProvider getClientServerProvider() {
        ClangClientServerProvider clangClientServerProvider = this.myClientServerProvider;
        if (clangClientServerProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(18);
        }
        return clangClientServerProvider;
    }

    @Override
    @NotNull
    public ClangServerAccessorProvider getServerAccessorProvider() {
        ClangServerAccessorProvider clangServerAccessorProvider = this.myServerAccessorProvider;
        if (clangServerAccessorProvider == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(19);
        }
        return clangServerAccessorProvider;
    }

    @Override
    @NotNull
    public ClangCrashHandler getCrashHandler() {
        ClangCrashHandler clangCrashHandler = this.myGuard;
        if (clangCrashHandler == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(20);
        }
        return clangCrashHandler;
    }

    @Override
    @NotNull
    public ClangTelemetry getTelemetry() {
        ClangTelemetry clangTelemetry = this.myTelemetry;
        if (clangTelemetry == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(21);
        }
        return clangTelemetry;
    }

    @Override
    @NotNull
    public ClangUrlConverter getUrlConverter() {
        ClangUrlConverter clangUrlConverter = this.myUrlConverter;
        if (clangUrlConverter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(22);
        }
        return clangUrlConverter;
    }

    @Override
    @NotNull
    public Charset getProtocolCharset() {
        Charset charset = this.myProtocolCharset;
        if (charset == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(23);
        }
        return charset;
    }

    @Override
    @NotNull
    public ClangMessagesFilter getMessagesFilter() {
        ClangMessagesFilter clangMessagesFilter = this.myMessagesFilter;
        if (clangMessagesFilter == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(24);
        }
        return clangMessagesFilter;
    }

    @Override
    public int getKeepAsts() {
        return this.myKeepAsts;
    }

    @Override
    public boolean shouldStartServerImmediately() {
        return this.myProject.getUserData(START_SERVER_IMMEDIATELY) != null;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public boolean canPublishMessage() {
        return !this.isStopped && !this.myMessageBus.isDisposed();
    }

    public void dispose() {
        this.isStopped = true;
        this.myIdeFacade.stop();
        if (this.myOwnMessageBus) {
            Disposer.dispose((Disposable)this.myMessageBus);
        }
    }

    @NotNull
    private static MessageBus createDefaultMessageBus(final @NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(25);
        }
        MessageBus messageBus = MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(){

            @NotNull
            public Object createListener(@NotNull ListenerDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Not supported.");
            }

            public boolean isDisposed() {
                return context.isStopped();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$1", "createListener"));
            }
        });
        if (messageBus == null) {
            ClangDaemonContextImpl.$$$reportNull$$$0(26);
        }
        return messageBus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConnectionProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientServerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverAccessorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdModulesPath";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdModulesPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalWorkspace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteWorkspace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeFacade";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientServerProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerAccessorProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCrashHandler";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlConverter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolCharset";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagesFilter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultMessageBus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultMessageBus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        @NotNull
        @NonNls
        private final String myDescriptor;
        @NotNull
        private final Project myProject;
        @Nullable
        private ClangdSettings mySettings;
        @Nullable
        private ClangIdeFacade myFacade;
        @Nullable
        private ClangUrlConverter myConverter;
        @Nullable
        private File myClangdPath;
        @Nullable
        private MessageBus myMessageBus;
        @Nullable
        private ClangServerAccessorProvider myServerAccessorProvider;
        private boolean myIsCustomClangdPath;
        private boolean myIsIndexer;
        @NotNull
        private String myClangdModulesPath;
        @Nullable
        private Integer myKeepAsts;

        public Builder(@NotNull @NonNls String descriptor, @NotNull Project project) {
            if (descriptor == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIsCustomClangdPath = false;
            this.myIsIndexer = false;
            this.myClangdModulesPath = "";
            this.myKeepAsts = null;
            this.myDescriptor = descriptor;
            this.myProject = project;
            this.mySettings = ClangdSettings.getInstance(project);
        }

        @NotNull
        public Builder setSettings(@NotNull ClangdSettings settings) {
            if (settings == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setIdeFacade(@NotNull ClangIdeFacade facade) {
            if (facade == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myFacade = facade;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setUrlConverter(@NotNull ClangUrlConverter converter) {
            if (converter == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myConverter = converter;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setClangdPath(@NotNull File clangdPath) {
            if (clangdPath == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myClangdPath = clangdPath;
            this.myIsCustomClangdPath = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder setMessageBus(@NotNull MessageBus messageBus) {
            if (messageBus == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myMessageBus = messageBus;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder setIndexer(boolean indexer) {
            this.myIsIndexer = indexer;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setClangdModulesPath(@NotNull String clangdModulesPath) {
            if (clangdModulesPath == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myClangdModulesPath = clangdModulesPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder setServerAccessorProvider(@NotNull ClangServerAccessorProvider provider) {
            if (provider == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myServerAccessorProvider = provider;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public Builder setKeepAsts(int keepAsts) {
            this.myKeepAsts = keepAsts;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder;
        }

        @NotNull
        public ClangDaemonContextImpl create() {
            File clangdPath = this.getClangdPath();
            LOG.info("Using clangd from: " + clangdPath);
            int keepAsts = this.myKeepAsts != null ? this.myKeepAsts : EditorWindow.getTabLimit();
            ProcessServerConnectionProvider connectionProvider = new ProcessServerConnectionProvider(this.myProject, clangdPath.getAbsolutePath(), this.myIsIndexer, keepAsts);
            ClangClientServerProviderImpl clientServerProvider = new ClangClientServerProviderImpl();
            return new ClangDaemonContextImpl(this.myIsIndexer, this.myIsCustomClangdPath, this.myDescriptor, this.myProject, this.getSettings(), connectionProvider, clientServerProvider, this.getServerAccessorProvider(), this.getUrlConverter(), this.getIdeFacade(), this.getMessageBus(), this.myClangdModulesPath, keepAsts);
        }

        @NotNull
        private ClangIdeFacade getIdeFacade() {
            ClangIdeFacade facade = (ClangIdeFacade)this.myProject.getUserData(ClangDaemonContext.IDE_FACADE_KEY);
            if (facade != null) {
                ClangIdeFacade clangIdeFacade = facade;
                if (clangIdeFacade == null) {
                    Builder.$$$reportNull$$$0(18);
                }
                return clangIdeFacade;
            }
            if (this.myFacade != null) {
                ClangIdeFacade clangIdeFacade = this.myFacade;
                if (clangIdeFacade == null) {
                    Builder.$$$reportNull$$$0(19);
                }
                return clangIdeFacade;
            }
            return new ClangIdeFacadeImpl(this.myDescriptor);
        }

        @NotNull
        private ClangdSettings getSettings() {
            if (this.mySettings != null) {
                ClangdSettings clangdSettings = this.mySettings;
                if (clangdSettings == null) {
                    Builder.$$$reportNull$$$0(20);
                }
                return clangdSettings;
            }
            ClangdSettings clangdSettings = ClangdSettings.getInstance(this.myProject);
            if (clangdSettings == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return clangdSettings;
        }

        @NotNull
        private ClangUrlConverter getUrlConverter() {
            if (this.myConverter != null) {
                ClangUrlConverter clangUrlConverter = this.myConverter;
                if (clangUrlConverter == null) {
                    Builder.$$$reportNull$$$0(22);
                }
                return clangUrlConverter;
            }
            ClangUrlConverter urlConverter = (ClangUrlConverter)this.myProject.getUserData(ClangDaemonContext.URL_CONVERTER_KEY);
            return urlConverter != null ? urlConverter : new ClangUrlConverter();
        }

        @NotNull
        public ClangServerAccessorProvider getServerAccessorProvider() {
            return this.myServerAccessorProvider != null ? this.myServerAccessorProvider : new ClangServerAccessorProviderImpl();
        }

        @NotNull
        private File getClangdPath() {
            if (this.myClangdPath != null) {
                File file = this.myClangdPath;
                if (file == null) {
                    Builder.$$$reportNull$$$0(23);
                }
                return file;
            }
            Pair<File, Boolean> pathAndIsCustom = ClangUtils.getClangdPath();
            this.myIsCustomClangdPath = (Boolean)pathAndIsCustom.second;
            File file = (File)pathAndIsCustom.first;
            if (file == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return file;
        }

        @Nullable
        private MessageBus getMessageBus() {
            return this.myMessageBus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangdPath";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBus";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clangdModulesPath";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangDaemonContextImpl$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIdeFacade";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUrlConverter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClangdPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMessageBus";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIndexer";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClangdModulesPath";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setServerAccessorProvider";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKeepAsts";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeFacade";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlConverter";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClangdPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSettings";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setIdeFacade";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setUrlConverter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setClangdPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setMessageBus";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setClangdModulesPath";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setServerAccessorProvider";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

