/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClazyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangDFAConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangNamehintConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyConfigParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionGlobalCompletionCacheParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.UnusedIncludesInspectionMode;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangHeavyRequestBuilder;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangReparseNotification
extends ClangFileBasedNotification<ReparseData> {
    @NotNull
    private final ClangParseResponse myResponse;
    @NotNull
    private final String myMacrosUrl;
    private final int myMacrosVersion;
    @NotNull
    private final String myMacroDefinitions;

    @NotNull
    public static ClangInteractionPromise<ClangReparseNotification> createPromise(@NotNull ClangHeavyRequestBuilder builder, @NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, int macrosVersion) {
        if (builder == null) {
            ClangReparseNotification.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            ClangReparseNotification.$$$reportNull$$$0(2);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(3);
        }
        if (macrosUrl == null) {
            ClangReparseNotification.$$$reportNull$$$0(4);
        }
        CompletableFuture<ClangReparseNotification> futureRequest = builder.later(() -> ClangReparseNotification.create(context, virtualFile, response, macrosUrl, macrosVersion));
        ClangInteractionPromise<ClangReparseNotification> clangInteractionPromise = new ClangInteractionPromiseImpl.Builder<ClangReparseNotification>(ClangReparseNotification.class, futureRequest).addReadAccessedProperties(response.getUrl(), ClangProperty.Content).addReadAccessedProperties(ClangRequestsHelper.getMacrosFileUrl(context, response.getUrl()), ClangProperty.Content).addWriteAccessedProperties(response.getUrl(), ClangProperty.Ast).addRejectedHandler(() -> ClangLanguageServiceUtils.finishOperation(response, false)).create();
        if (clangInteractionPromise == null) {
            ClangReparseNotification.$$$reportNull$$$0(5);
        }
        return clangInteractionPromise;
    }

    @Nullable
    private static ClangReparseNotification create(@NotNull ClangDaemonContext context, @NotNull VirtualFile virtualFile, @NotNull ClangParseResponse response, @NotNull String macrosUrl, int macrosVersion) {
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            ClangReparseNotification.$$$reportNull$$$0(7);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(8);
        }
        if (macrosUrl == null) {
            ClangReparseNotification.$$$reportNull$$$0(9);
        }
        if (context.getProject().isDisposed()) {
            return null;
        }
        Project project = context.getProject();
        String url = response.getUrl();
        int version = response.getVersion();
        boolean cancellable = response.isCancellable();
        if (ClangRequestsHelper.isAllowedByGuard(context, url)) {
            String macros;
            ClionCompileCommandParams compileParams;
            Trustworthiness trustworthiness;
            String macrosPath = context.getUrlConverter().fromUri(context.getUrlConverter().toUri(macrosUrl));
            ClangdCompilationCommand cc = context.getIdeFacade().getCompilationCommand(context.getUrlConverter(), project, virtualFile, macrosPath);
            if (cc != null) {
                trustworthiness = cc.trustworthiness;
                compileParams = cc.ccParams;
                macros = cc.ppDefines;
                if (!ContainerUtil.exists(compileParams.getCommandLine(), arg -> arg.startsWith("--target="))) {
                    trustworthiness = trustworthiness.with(4);
                }
            } else {
                trustworthiness = ClangdBridge.isClangdOnlyMode() ? new Trustworthiness() : new Trustworthiness(1);
                String targetURI = context.getUrlConverter().toUri(virtualFile.getUrl());
                compileParams = new ClionCompileCommandParams(targetURI, targetURI, "", Collections.emptyList(), "/dev/null");
                macros = "";
            }
            response.putUserData(ClangParseResponse.TRUSTWORTHINESS, trustworthiness);
            ClionClangTidyConfigParams clangTidyConfig = context.getIdeFacade().getClangTidyConfig(project, virtualFile);
            ClionClangNamehintConfigParams clangNamehintConfig = context.getIdeFacade().getNamehintConfig();
            UnusedIncludesInspectionMode unusedInspectionMode = context.getIdeFacade().getUnusedIncludesInspectionMode(project, virtualFile);
            CLionClazyConfigParams clazyConfig = context.getIdeFacade().getClazyConfig(project, virtualFile);
            ClionWantDiagnostics WantDiags = cancellable ? ClionWantDiagnostics.Auto : ClionWantDiagnostics.Yes;
            ClionClangDFAConfigParams dfaOptions = context.getIdeFacade().getDFAOptions(project, virtualFile);
            ClionGlobalCompletionCacheParams globalCompletionCacheParams = context.getIdeFacade().getGlobalCompletionCacheParams(project, virtualFile);
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(context.getUrlConverter().toUri(url));
            docId.setVersion(Integer.valueOf(version));
            ClionReparseTextDocumentParams params = new ClionReparseTextDocumentParams(docId, compileParams, clangTidyConfig, clangNamehintConfig, unusedInspectionMode, clazyConfig, WantDiags, dfaOptions, globalCompletionCacheParams);
            if (!ClangReparseNotification.areNamehintsEnabled(clangNamehintConfig)) {
                response.getNamehints().complete(null);
            }
            if (!globalCompletionCacheParams.getEnabled()) {
                response.getCompletionCacheReady().complete(false);
            }
            ReparseData reparseData = new ReparseData(context, url, params);
            return new ClangReparseNotification(context, response, reparseData, macrosUrl, macrosVersion, StringUtil.notNullize((String)macros));
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)("File [" + url + "] was banned!"), (Throwable)new Exception());
        }
        return null;
    }

    private ClangReparseNotification(@NotNull ClangDaemonContext context, @NotNull ClangParseResponse response, @NotNull ReparseData data, @NotNull String macrosUrl, int macrosVersion, @NotNull String macroDefinitions) {
        if (context == null) {
            ClangReparseNotification.$$$reportNull$$$0(10);
        }
        if (response == null) {
            ClangReparseNotification.$$$reportNull$$$0(11);
        }
        if (data == null) {
            ClangReparseNotification.$$$reportNull$$$0(12);
        }
        if (macrosUrl == null) {
            ClangReparseNotification.$$$reportNull$$$0(13);
        }
        if (macroDefinitions == null) {
            ClangReparseNotification.$$$reportNull$$$0(14);
        }
        super(context, response.getUrl(), response.getVersion(), true, data);
        this.myResponse = response;
        this.myMacrosUrl = macrosUrl;
        this.myMacrosVersion = macrosVersion;
        this.myMacroDefinitions = macroDefinitions;
    }

    private static void sendQObjectDefsIfRequired(ClangDaemonContext context, @NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(15);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(16);
        }
        if (ws.apply(ClangRequestsHelper.getQobjectDefsUrl(), rf -> rf.getContent()) != null) {
            return;
        }
        VersionedTextDocumentIdentifier docIdQobject = new VersionedTextDocumentIdentifier();
        docIdQobject.setUri(context.getUrlConverter().toUri(ClangRequestsHelper.getQobjectDefsUrl()));
        docIdQobject.setVersion(Integer.valueOf(0));
        TextDocumentContentChangeEvent changeEventQobject = new TextDocumentContentChangeEvent();
        changeEventQobject.setText(ClangRequestsHelper.getQobjectDefsContent());
        ClangChangeNotification.create(context, ClangRequestsHelper.getQobjectDefsUrl(), 0, new DidChangeTextDocumentParams(docIdQobject, Collections.singletonList(changeEventQobject)), false).send(server, ws);
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(17);
        }
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(18);
        }
        assert (ws.isOpenedRemotely(this.myUrl));
        if (ClangDebugLevel.isWarnOrMore()) {
            ClangUtils.warnClangd(LOG, "Reparsing file " + this.myUrl + " of version " + ((ReparseData)this.myParams).params.getTextDocument().getVersion());
        }
        this.myContext.getTelemetry().getGeneralTelemetry().notifyReparseSent(this);
        String prevMacrosContent = ws.apply(this.myMacrosUrl, rf -> rf.getContent());
        if (!Objects.equals(prevMacrosContent, this.myMacroDefinitions)) {
            VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier();
            docId.setUri(this.myContext.getUrlConverter().toUri(this.myMacrosUrl));
            docId.setVersion(Integer.valueOf(this.myMacrosVersion));
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(this.myMacroDefinitions);
            ClangChangeNotification.create(this.myContext, this.myMacrosUrl, this.myMacrosVersion, new DidChangeTextDocumentParams(docId, Collections.singletonList(changeEvent)), false).send(server, ws);
        }
        if (ClangRequestsHelper.containsQtCore(((ReparseData)this.myParams).params.getCompilationCommand().getCommandLine())) {
            ClangReparseNotification.sendQObjectDefsIfRequired(this.myContext, server, ws);
        }
        if (ClangReparseNotification.doSend(server, (ReparseData)this.myParams)) {
            ClangLanguageServiceUtils.finishOperation(this.myResponse, true);
            return true;
        }
        return false;
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(19);
        }
        super.onSkipped(ws);
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    public void onRejected() {
        super.onRejected();
        ClangLanguageServiceUtils.finishOperation(this.myResponse, false);
    }

    @Override
    protected void toNextRemoteState(@NotNull ClangRemoteWorkspace ws, @NotNull ReparseData params) {
        if (ws == null) {
            ClangReparseNotification.$$$reportNull$$$0(20);
        }
        if (params == null) {
            ClangReparseNotification.$$$reportNull$$$0(21);
        }
        super.toNextRemoteState(ws, params);
        this.myResponse.putUserData(ClangParseResponse.UNSAVED_FILES, ws.getUnsavedFiles());
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull ReparseData params) {
        if (wf == null) {
            ClangReparseNotification.$$$reportNull$$$0(22);
        }
        if (params == null) {
            ClangReparseNotification.$$$reportNull$$$0(23);
        }
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, params.params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull ReparseData data) {
        if (server == null) {
            ClangReparseNotification.$$$reportNull$$$0(24);
        }
        if (data == null) {
            ClangReparseNotification.$$$reportNull$$$0(25);
        }
        server.clionReparse(data.params);
        return true;
    }

    private static boolean areNamehintsEnabled(@Nullable ClionClangNamehintConfigParams params) {
        return params != null && params.isEnableNamehints();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macrosUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroDefinitions";
                break;
            }
            case 15: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ws";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPromise";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sendQObjectDefsIfRequired";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sendNotificationImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onSkipped";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toNextRemoteState";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doSend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReparseData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionReparseTextDocumentParams params;

        ReparseData(@NotNull ClangDaemonContext context, @NotNull String url, @NotNull ClionReparseTextDocumentParams params) {
            if (context == null) {
                ReparseData.$$$reportNull$$$0(0);
            }
            if (url == null) {
                ReparseData.$$$reportNull$$$0(1);
            }
            if (params == null) {
                ReparseData.$$$reportNull$$$0(2);
            }
            this.context = context;
            this.url = url;
            this.params = params;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangReparseNotification$ReparseData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

