/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import java.util.List;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangRequestsHelper {
    @NlsSafe
    @NotNull
    private static final String MACRO_PREDEFINES_BASE_PATH = "/clion_clangd_inmemory_directory/macros";

    private ClangRequestsHelper() {
        throw new AssertionError();
    }

    public static boolean isMacroFile(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(0);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(1);
        }
        return ClangRequestsHelper.isMacroFile(context.getUrlConverter(), url);
    }

    public static boolean isMacroFile(@NotNull ClangUrlConverter converter, @NlsSafe @NotNull String url) {
        if (converter == null) {
            ClangRequestsHelper.$$$reportNull$$$0(2);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(3);
        }
        return ClangRequestsHelper.isMacroPath(converter.fromUri(converter.toUri(url)));
    }

    public static boolean isMacroPath(@NlsSafe @NotNull String path) {
        if (path == null) {
            ClangRequestsHelper.$$$reportNull$$$0(4);
        }
        return path.contains(MACRO_PREDEFINES_BASE_PATH);
    }

    public static boolean isAllowedByGuard(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(5);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(6);
        }
        return !context.getCrashHandler().isBanned(url);
    }

    static boolean isMacroLSPSymbolKind(@Nullable SymbolKind kind) {
        return kind == SymbolKind.Module;
    }

    public static String getMacrosFileUrl(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(7);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(8);
        }
        return "file://" + ClangRequestsHelper.getMacrosFilePath(context, url);
    }

    @NlsSafe
    @NotNull
    public static String getMacrosFilePath(@NotNull ClangDaemonContext context, @NlsSafe @NotNull String url) {
        if (context == null) {
            ClangRequestsHelper.$$$reportNull$$$0(9);
        }
        if (url == null) {
            ClangRequestsHelper.$$$reportNull$$$0(10);
        }
        if (!context.getUrlConverter().isAcceptable(url)) {
            return SystemInfo.isWindows ? "C:/clion_clangd_inmemory_directory/macros/__wrong_url_" : "/clion_clangd_inmemory_directory/macros/__wrong_url_";
        }
        Object path = context.getUrlConverter().fromUri(context.getUrlConverter().toUri(url));
        if (SystemInfo.isWindows && ((String)path).length() > 2 && Character.isLetter(((String)path).charAt(0)) && ((String)path).charAt(1) == ':' && ((String)path).charAt(2) == '/') {
            char driveLetter = ((String)path).charAt(0);
            Object object = path = driveLetter + ":/clion_clangd_inmemory_directory/macros" + (String)(((String)(path = ((String)path).replaceFirst(":", ""))).startsWith("/") ? path : "/" + (String)path);
            if (object == null) {
                ClangRequestsHelper.$$$reportNull$$$0(11);
            }
            return object;
        }
        String string = MACRO_PREDEFINES_BASE_PATH + (String)(((String)path).startsWith("/") ? path : "/" + (String)path);
        if (string == null) {
            ClangRequestsHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static String getMacrosParentPath() {
        return (SystemInfo.isWindows ? "C:" : "") + MACRO_PREDEFINES_BASE_PATH;
    }

    public static String getQobjectDefsUrl() {
        return "file://" + ClangRequestsHelper.getQobjectDefsPath();
    }

    public static String getQobjectDefsPath() {
        return ClangRequestsHelper.getMacrosParentPath() + "/QtCore/qobjectdefs.h";
    }

    public static boolean containsQtCore(List<String> compileCommand) {
        for (String arg : compileCommand) {
            if (!arg.startsWith("-I") || !arg.contains("QtCore")) continue;
            return true;
        }
        return false;
    }

    public static String getQobjectDefsContent() {
        return "#include_next <qobjectdefs.h>\n#pragma once\n#pragma clang diagnostic push\n#pragma clang diagnostic ignored \"-Wmacro-redefined\"\n#define __CLION_QT_SIGNAL_ANNOTATION __attribute__((annotate(\"signal_from_qt\")))\n#define __CLION_QT_SLOT_ANNOTATION __attribute__((annotate(\"slot_from_qt\")))\n#ifdef signals\n#define signals public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNALS\n#define Q_SIGNALS public __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef Q_SIGNAL\n#define Q_SIGNAL __CLION_QT_SIGNAL_ANNOTATION\n#endif\n#ifdef slots\n#define slots __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOTS\n#define Q_SLOTS __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef Q_SLOT\n#define Q_SLOT __CLION_QT_SLOT_ANNOTATION\n#endif\n#ifdef SIGNAL\n#define SIGNAL(arg) qFlagLocation(#arg)\n#endif\n#ifdef SLOT\n#define SLOT(arg) qFlagLocation(#arg)\n#endif\n#pragma clang diagnostic pop\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangRequestsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangRequestsHelper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacrosFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMacroFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMacroPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedByGuard";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMacrosFileUrl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMacrosFilePath";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

