/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.table.JBTable;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.BuildPreambleError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangPreambleTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry.ClangTelemetryListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdInfoPanelKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0010\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002J\u0013\u0010\u0013\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdInfoPanel;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "indexerStatus", "", "getIndexerStatus", "()Ljava/lang/String;", "setIndexerStatus", "(Ljava/lang/String;)V", "mainStatus", "getMainStatus", "setMainStatus", "getProject", "()Lcom/intellij/openapi/project/Project;", "makePidText", "Lcom/intellij/openapi/util/NlsSafe;", "status", "makePreambleStatsText", "updatePid", "", "pidLabel", "Ljavax/swing/JLabel;", "intellij.c.clangd"})
public final class ClangdInfoPanel
extends ClangdPanelBase {
    @NotNull
    private String mainStatus;
    @NotNull
    private String indexerStatus;
    @NotNull
    private final Project project;

    @NotNull
    public final String getMainStatus() {
        return this.mainStatus;
    }

    public final void setMainStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.mainStatus = string;
    }

    @NotNull
    public final String getIndexerStatus() {
        return this.indexerStatus;
    }

    public final void setIndexerStatus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indexerStatus = string;
    }

    private final void updatePid(JLabel pidLabel) {
        pidLabel.setText(this.makePidText(this.project, this.mainStatus, this.indexerStatus));
    }

    @NotNull
    public final String makePreambleStatsText(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        FileEditor fileEditor = fileEditorManager.getSelectedEditor();
        String curFile = fileEditor != null && (fileEditor = fileEditor.getFile()) != null ? fileEditor.getPath() : null;
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted(project);
        Intrinsics.checkNotNullExpressionValue((Object)clangLanguageService, (String)"ClangLanguageServiceProvider.getIfStarted(project)");
        ClangTelemetry telemetry = clangLanguageService.getTelemetry();
        if (curFile != null && telemetry != null) {
            ClangPreambleTelemetry clangPreambleTelemetry = telemetry.getPreambleTelemetry();
            Intrinsics.checkNotNullExpressionValue((Object)clangPreambleTelemetry, (String)"telemetry.preambleTelemetry");
            ClangPreambleTelemetry preambleTelemetry = clangPreambleTelemetry;
            int preambleParses = preambleTelemetry.getPreambleParses(curFile);
            int preambleReuses = preambleTelemetry.getPreambleReuses(curFile);
            int preambleFailures = preambleTelemetry.getPreambleFailures(curFile);
            int preambleDidntHitTarget = preambleTelemetry.getPreambleFailures(curFile, BuildPreambleError.DidntHitTargetFile);
            int preambleCancels = preambleTelemetry.getPreambleCancels(curFile);
            return "Preamble [reparsed: " + (preambleParses - preambleCancels) + ", " + "cancelled: " + preambleCancels + ", " + "reused: " + preambleReuses + ", " + "failed: " + preambleFailures + " (" + preambleDidntHitTarget + " didn't hit)]";
        }
        return "Preamble [reparsed: N/A, cancelled: N/A, reused: N/A, failed: N/A, empty: N/A]";
    }

    private final String makePidText(Project project, @Nls String status, @Nls String indexerStatus) {
        Object object = ClangLanguageServiceProvider.getProvider(project);
        Integer pid = object != null && (object = object.getIfStarted()) != null ? Integer.valueOf(object.getServerPid()) : null;
        Object object2 = ClangLanguageServiceProvider.getProvider(project);
        Integer indexerPid = object2 != null && (object2 = object2.getIfStartedIndexer()) != null ? Integer.valueOf(object2.getServerPid()) : null;
        StringBuilder stringBuilder = new StringBuilder().append("Clangd server PID: ");
        Object object3 = pid;
        if (object3 == null || (object3 = String.valueOf((Integer)object3)) == null) {
            object3 = "Unknown";
        }
        StringBuilder stringBuilder2 = stringBuilder.append((String)object3).append(" [").append(status).append("], ").append("Clangd indexer PID: ");
        Object object4 = indexerPid;
        if (object4 == null || (object4 = String.valueOf((Integer)object4)) == null) {
            object4 = "Unknown";
        }
        return stringBuilder2.append((String)object4).append(" [").append(indexerStatus).append(']').toString();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public ClangdInfoPanel(@NotNull Project project) {
        ClangLanguageService indexer;
        void it;
        void modulesPathPanel;
        void pidPanel;
        void preamblePanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainStatus = "Running";
        this.indexerStatus = "Running";
        Object object = ClangLanguageServiceProvider.getProvider(this.project);
        String modulesPath = object != null && (object = object.getIfStartedIndexer()) != null ? object.getClangdModulesPath() : null;
        JPanel centerPanel = new JPanel(new BorderLayout());
        final JLabel memoryLabel = new JLabel("Memory usage info: N/A");
        final JLabel preambleLabel = new JLabel(this.makePreambleStatsText(this.project));
        final JLabel pidLabel = new JLabel(this.makePidText(this.project, this.mainStatus, this.indexerStatus));
        JLabel modulesPathLabel = new JLabel("Clangd modules path: " + modulesPath);
        AbstractTableModel perFileModel2 = new AbstractTableModel(){
            @NotNull
            private List<ClangMemoryUsageInfo.PerFile> perFile;

            @NotNull
            public final List<ClangMemoryUsageInfo.PerFile> getPerFile() {
                return this.perFile;
            }

            public final void setPerFile(@NotNull List<ClangMemoryUsageInfo.PerFile> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.perFile = list;
            }

            public int getRowCount() {
                return this.perFile.size();
            }

            public int getColumnCount() {
                return 2;
            }

            @Nullable
            public String getValueAt(int rowIndex, int columnIndex) {
                String string;
                switch (columnIndex) {
                    case 0: {
                        string = this.perFile.get(rowIndex).getPath();
                        break;
                    }
                    case 1: {
                        string = ClangdInfoPanelKt.access$kb2Mb(this.perFile.get(rowIndex).getKb());
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                return string;
            }
            {
                this.perFile = CollectionsKt.emptyList();
            }
        };
        JBTable table = new JBTable((TableModel)perFileModel2);
        centerPanel.add((Component)memoryLabel, "First");
        JPanel jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel jPanel2 = jPanel;
        JPanel jPanel3 = centerPanel;
        boolean bl3 = false;
        preamblePanel.add((Component)preambleLabel, "First");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        boolean bl4 = false;
        boolean bl5 = false;
        JPanel jPanel5 = jPanel4;
        void var19_20 = preamblePanel;
        boolean bl6 = false;
        pidPanel.add((Component)pidLabel, "First");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        boolean bl7 = false;
        boolean bl8 = false;
        JPanel jPanel7 = jPanel6;
        void var25_26 = pidPanel;
        boolean bl9 = false;
        modulesPathPanel.add((Component)modulesPathLabel, "First");
        JPanel jPanel8 = new JPanel(new BorderLayout());
        boolean bl10 = false;
        boolean bl11 = false;
        JPanel jPanel9 = jPanel8;
        void var31_32 = modulesPathPanel;
        boolean bl12 = false;
        it.add((Component)new JLabel(ClangdBundle.message("language.cpp.clangd.info.panel.per.file.label", new Object[0])), "First");
        it.add((Component)table, "Center");
        Unit unit = Unit.INSTANCE;
        var31_32.add(jPanel8);
        Unit unit2 = Unit.INSTANCE;
        var25_26.add(jPanel6);
        Unit unit3 = Unit.INSTANCE;
        var19_20.add(jPanel4);
        Unit unit4 = Unit.INSTANCE;
        jPanel3.add((Component)jPanel, "Center");
        this.add(centerPanel);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(perFileModel2, table){
            final /* synthetic */ perFileModel.1 $perFileModel;
            final /* synthetic */ JBTable $table;

            @Override
            public void onServerRunning() {
                this.setMainStatus("Running");
                this.updatePid(pidLabel);
            }

            @Override
            public void onServerFailure() {
                this.setMainStatus("Failure");
                this.updatePid(pidLabel);
            }

            @Override
            public void onServerShutDown() {
                this.setMainStatus("Shut Down");
                this.updatePid(pidLabel);
            }

            @Override
            public void onMemoryUsageInfoReceived(@NotNull ClangMemoryUsageInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                memoryLabel.setText("Memory usage info: working set: " + ClangdInfoPanelKt.access$kb2Mb(info.getWorkingSet()) + ", " + "drafts: " + ClangdInfoPanelKt.access$kb2Mb(info.getDrafts()) + ", " + "unsaved: " + ClangdInfoPanelKt.access$kb2Mb(info.getUnsaved()));
                this.$perFileModel.setPerFile(info.getPerFile());
                this.$table.updateUI();
            }
            {
                this.$perFileModel = $captured_local_variable$3;
                this.$table = $captured_local_variable$4;
            }
        });
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider(this.project);
        ClangLanguageService clangLanguageService = indexer = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStartedIndexer() : null;
        if (indexer != null && !indexer.isDummy()) {
            indexer.getMessageBus().connect((Disposable)this).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

                @Override
                public void onServerRunning() {
                    this.setIndexerStatus("Running");
                    this.updatePid(pidLabel);
                }

                @Override
                public void onServerFailure() {
                    this.setIndexerStatus("Failure");
                    this.updatePid(pidLabel);
                }

                @Override
                public void onServerShutDown() {
                    this.setIndexerStatus("Shut Down");
                    this.updatePid(pidLabel);
                }
            });
        }
        this.project.getMessageBus().connect((Disposable)this).subscribe(ClangTelemetryListener.TOPIC, (Object)new ClangTelemetryListener(){

            @Override
            public void onPreambleTelemetry(@NotNull ClangTelemetry telemetry) {
                Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
                preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
            }
        });
        this.project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                preambleLabel.setText(this.makePreambleStatsText(this.getProject()));
            }
        });
    }
}

