/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.io;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.cpp.assertions.CPPAssertions;
import com.jetbrains.cidr.cpp.io.CPPPathTestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u0002\u001a@\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00022!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00050\u0005*\u00020\u0005H\u0002\" \u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"BOURNE_COMPATIBLE_SHELLS", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "bourneShell", "Ljava/nio/file/Path;", "getBourneShell", "()Ljava/nio/file/Path;", "findInLocalPath", "Lkotlin/sequences/Sequence;", "executable", "withProjectDirectory", "T", "tmpdirPrefix", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "projectDirectory", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deleteRecursively", "kotlin.jvm.PlatformType", "intellij.clion.testFramework"})
@JvmName(name="CPPPathTestUtils")
public final class CPPPathTestUtils {
    @NonNls
    private static final LinkedHashSet<String> BOURNE_COMPATIBLE_SHELLS = SetsKt.linkedSetOf((Object[])new String[]{"bash", "zsh", "fish", "ksh", "dash", "sh"});

    @NotNull
    public static final Path getBourneShell() {
        return (Path)CPPAssertions.assumeNotNull$default(SequencesKt.firstOrNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)BOURNE_COMPATIBLE_SHELLS), (Function1)bourneShell.1.INSTANCE)), null, 1, null);
    }

    private static final Path deleteRecursively(Path $this$deleteRecursively) throws IOException {
        return Files.walkFileTree($this$deleteRecursively, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                try {
                    Files.delete(file2);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file2, @Nullable IOException exc) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                try {
                    Files.delete(file2);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) throws IOException {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (exc != null) {
                    throw (Throwable)exc;
                }
                try {
                    Files.delete(dir);
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withProjectDirectory(@Nullable String tmpdirPrefix, @NotNull Function1<? super Path, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Path path = Files.createTempDirectory(tmpdirPrefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(tmpdirPrefix)");
        Path projectDirectory = path;
        try {
            object = block.invoke((Object)projectDirectory);
        }
        finally {
            CPPPathTestUtils.deleteRecursively(projectDirectory);
        }
        return (T)object;
    }

    public static /* synthetic */ Object withProjectDirectory$default(String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return CPPPathTestUtils.withProjectDirectory(string, function1);
    }

    @NotNull
    public static final Sequence<Path> findInLocalPath(@NotNull String executable) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        if (SystemInfo.isWindows) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = ".bat";
            stringArray2[1] = ".com";
            stringArray = stringArray2;
            stringArray2[2] = ".exe";
        } else {
            stringArray = new String[]{};
        }
        String[] exeSuffixes = stringArray;
        Sequence basenames2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(exeSuffixes, executable, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ String[] $exeSuffixes;
            final /* synthetic */ String $executable;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block11: {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            var3_4 = this.$exeSuffixes;
                            var4_5 = false;
                            if (!(var3_4.length == 0)) break;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)this.$executable, (Continuation)this);
                            if (v0 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl43
                        }
                        case 1: {
                            var2_3 = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl43
                        }
                    }
                    $this$any$iv = this.$exeSuffixes;
                    $i$f$any = false;
                    var5_6 = $this$any$iv;
                    var6_7 = var5_6.length;
                    for (var7_8 = 0; var7_8 < var6_7; ++var7_8) {
                        exeSuffix = element$iv = var5_6[var7_8];
                        $i$a$-any-CPPPathTestUtils$findInLocalPath$basenames$1$1 = false;
                        if (!Boxing.boxBoolean((boolean)StringsKt.endsWith$default((String)this.$executable, (String)exeSuffix, (boolean)false, (int)2, null)).booleanValue()) continue;
                        v1 = true;
                        break block11;
                    }
                    v1 = false;
                }
                if (v1) {
                    this.L$0 = var2_3;
                    this.label = 2;
                    v2 = var2_3.yield((Object)this.$executable, (Continuation)this);
                    if (v2 == var11_2) {
                        return var11_2;
                    }
                }
                ** GOTO lbl43
                {
                    case 2: {
                        var2_3 = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 4 sources

                        this.L$0 = null;
                        this.label = 3;
                        v3 = var2_3.yieldAll(SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])this.$exeSuffixes), (Function1)((Function1)new Function1<String, String>(this){
                            final /* synthetic */ findInLocalPath.basenames.1 this$0;

                            @NotNull
                            public final String invoke(@NotNull String exeSuffix) {
                                Intrinsics.checkNotNullParameter((Object)exeSuffix, (String)"exeSuffix");
                                return this.this$0.$executable + exeSuffix;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })), (Continuation)this);
                        if (v3 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl52
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl52:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$exeSuffixes = stringArray;
                this.$executable = string;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        String string = System.getenv("PATH");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getenv(\"PATH\")");
        return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)string, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null)), (Function1)findInLocalPath.1.INSTANCE), (Function1)((Function1)new Function1<Path, Sequence<? extends Path>>(basenames2){
            final /* synthetic */ Sequence $basenames;

            @NotNull
            public final Sequence<Path> invoke(Path pathEntry) {
                return SequencesKt.map((Sequence)this.$basenames, (Function1)((Function1)new Function1<String, Path>(pathEntry){
                    final /* synthetic */ Path $pathEntry;

                    public final Path invoke(@NotNull String basename) {
                        Intrinsics.checkNotNullParameter((Object)basename, (String)"basename");
                        return this.$pathEntry.resolve(basename);
                    }
                    {
                        this.$pathEntry = path;
                        super(1);
                    }
                }));
            }
            {
                this.$basenames = sequence;
                super(1);
            }
        })), (Function1)findInLocalPath.3.INSTANCE), (Function1)findInLocalPath.4.INSTANCE);
    }
}

