/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.ProcessOutputListener;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrExecutionFixture<PROJECT_FIXTURE_TYPE extends CidrProjectFixture>
extends Assert {
    @NotNull
    protected List<CheckedFutureResult> myResultsToCheck;
    @NotNull
    protected final PROJECT_FIXTURE_TYPE myProjectFixture;
    protected ProcessHandler myProcessHandler;
    protected ExecutionConsole myConsole;
    protected ExecutionResult myExecutionResult;
    @NotNull
    protected ConfigurationTypeBase myConfigurationType;
    @Nullable
    protected String myTargetName;
    @Nullable
    protected String myConfigurationName;
    private ExecutionTarget myExecutionTarget;
    private CommandLineState myState;
    private final Disposable myDisposable;
    public static final int TIMEOUT = 30000;
    public Starter<ExecutionResult> RUN_STARTER;
    public Starter<XDebugSession> DEBUG_STARTER;
    public Starter<XDebugSession> DEBUG_STARTER_MUTED_BREAKS;

    protected CidrExecutionFixture(@NotNull PROJECT_FIXTURE_TYPE fixture, @NotNull ConfigurationTypeBase configurationType) {
        if (fixture == null) {
            CidrExecutionFixture.$$$reportNull$$$0(0);
        }
        if (configurationType == null) {
            CidrExecutionFixture.$$$reportNull$$$0(1);
        }
        this(fixture, configurationType, null, null);
    }

    protected CidrExecutionFixture(@NotNull PROJECT_FIXTURE_TYPE fixture, @NotNull ConfigurationTypeBase configurationType, @Nullable String targetName, @Nullable String configurationName) {
        if (fixture == null) {
            CidrExecutionFixture.$$$reportNull$$$0(2);
        }
        if (configurationType == null) {
            CidrExecutionFixture.$$$reportNull$$$0(3);
        }
        this.myResultsToCheck = new ArrayList<CheckedFutureResult>();
        this.myDisposable = Disposer.newDisposable();
        this.RUN_STARTER = new Starter<ExecutionResult>(){

            @Override
            public Executor executor() {
                return DefaultRunExecutor.getRunExecutorInstance();
            }

            @Override
            public ExecutionResult start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
                final ExecutionResult result = state.execute(executor, (ProgramRunner)runner);
                Disposer.register((Disposable)CidrExecutionFixture.this.myDisposable, (Disposable)new Disposable(){

                    public void dispose() {
                        ExecutionConsole console = result.getExecutionConsole();
                        if (!Disposer.isDisposed((Disposable)console)) {
                            UIUtil.invokeAndWaitIfNeeded(() -> Disposer.dispose((Disposable)console));
                        }
                    }
                });
                return result;
            }
        };
        this.DEBUG_STARTER = new Starter<XDebugSession>(){

            @Override
            public Executor executor() {
                return DefaultDebugExecutor.getDebugExecutorInstance();
            }

            @Override
            public XDebugSession start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
                return runner.startDebugSession((CidrCommandLineState)state, env, false, listeners);
            }
        };
        this.DEBUG_STARTER_MUTED_BREAKS = new Starter<XDebugSession>(){

            @Override
            public Executor executor() {
                return DefaultDebugExecutor.getDebugExecutorInstance();
            }

            @Override
            public XDebugSession start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
                return runner.startDebugSession((CidrCommandLineState)state, env, true, listeners);
            }
        };
        this.myProjectFixture = fixture;
        this.myConfigurationType = configurationType;
        this.myTargetName = targetName;
        this.myConfigurationName = configurationName;
    }

    public void initTargetAndConfiguration(String targetName, String configurationName) {
        this.myTargetName = targetName;
        this.myConfigurationName = configurationName;
    }

    public void setConfigurationType(@NotNull ConfigurationTypeBase configurationType) {
        if (configurationType == null) {
            CidrExecutionFixture.$$$reportNull$$$0(4);
        }
        this.myConfigurationType = configurationType;
    }

    public abstract void buildIfNeeded() throws Exception;

    public ExecutionConsole getConsole() {
        return this.myConsole;
    }

    @NotNull
    public ConfigurationTypeBase getConfigurationType() {
        ConfigurationTypeBase configurationTypeBase = this.myConfigurationType;
        if (configurationTypeBase == null) {
            CidrExecutionFixture.$$$reportNull$$$0(5);
        }
        return configurationTypeBase;
    }

    @NotNull
    public PROJECT_FIXTURE_TYPE getProjectFixture() {
        PROJECT_FIXTURE_TYPE PROJECT_FIXTURE_TYPE = this.myProjectFixture;
        if (PROJECT_FIXTURE_TYPE == null) {
            CidrExecutionFixture.$$$reportNull$$$0(6);
        }
        return PROJECT_FIXTURE_TYPE;
    }

    public CommandLineState getState() {
        return this.myState;
    }

    public <T> T startRunDebug(@NotNull CidrRunProfile runConfiguration, @Nullable ExecutionTarget executionTarget, boolean build2, @NotNull Starter<T> starter, XDebugSessionListener ... listeners) throws Exception {
        if (runConfiguration == null) {
            CidrExecutionFixture.$$$reportNull$$$0(7);
        }
        if (starter == null) {
            CidrExecutionFixture.$$$reportNull$$$0(8);
        }
        return this.startRunDebug(runConfiguration, null, executionTarget, build2, starter, listeners);
    }

    public <T> T startRunDebug(@NotNull CidrRunProfile runConfiguration, @Nullable RunnerSettings settings, @Nullable ExecutionTarget executionTarget, boolean build2, @NotNull Starter<T> starter, XDebugSessionListener ... listeners) throws Exception {
        if (runConfiguration == null) {
            CidrExecutionFixture.$$$reportNull$$$0(9);
        }
        if (starter == null) {
            CidrExecutionFixture.$$$reportNull$$$0(10);
        }
        if (build2 && runConfiguration instanceof CidrRunConfiguration) {
            ((CidrProjectFixture)this.myProjectFixture).buildIfNeeded((CidrRunConfiguration)runConfiguration, executionTarget);
        }
        Executor executor = starter.executor();
        CidrRunner runner = (CidrRunner)ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
        CidrExecutionFixture.assertNotNull((Object)runner);
        CidrExecutionFixture.assertTrue((boolean)runner.canRun(executor.getId(), (RunProfile)runConfiguration));
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(((CidrProjectFixture)this.myProjectFixture).getProject(), executor).runner((ProgramRunner)runner).runnerSettings(settings).target(executionTarget).runProfile((RunProfile)runConfiguration).build();
        CommandLineState state = runConfiguration.getState(executor, env);
        CidrExecutionFixture.assertNotNull((Object)state);
        if (state instanceof CidrTestCommandLineState) {
            for (BeforeRunTask task : ((CidrTestCommandLineState)state).getConfiguration().getBeforeRunTasks()) {
                if (task.getProviderId() != CidrBeforeTestRunTaskProvider.ID || !task.isEnabled()) continue;
                ((CidrTestCommandLineState)state).prepareTestExecutionEnvironment((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
        }
        CidrExecutionFixture.assertConfigurationSettings(runConfiguration);
        this.myExecutionTarget = executionTarget;
        this.myState = state;
        return (T)WriteAction.computeAndWait(() -> starter.start(executor, runner, state, env, listeners));
    }

    private static void assertConfigurationSettings(@NotNull CidrRunProfile runConfiguration) throws RuntimeConfigurationException {
        if (runConfiguration == null) {
            CidrExecutionFixture.$$$reportNull$$$0(11);
        }
        if (runConfiguration instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runConfiguration).checkSettingsBeforeRun();
        } else if (runConfiguration instanceof RunConfiguration) {
            ((RunConfiguration)runConfiguration).checkConfiguration();
        }
    }

    public void startRunSession() throws Exception {
        this.startRunSession((String)null);
    }

    public void startRunSession(@Nullable String parameters) throws Exception {
        this.startRunSession(parameters, null);
    }

    public void startRunSession(@Nullable ProcessListener listener) throws Exception {
        this.startRunSession(null, listener);
    }

    public void startRunSession(@Nullable String parameters, @Nullable ProcessListener listener) throws Exception {
        this.startRunSession(this.getBuildConfigurationData(), (Consumer<CidrRunConfiguration>)((Consumer)config -> config.setProgramParameters(parameters)), listener);
    }

    public void startRunSession(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable ProcessListener listener) throws Exception {
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(12);
        }
        this.initRunSession(listener, this.startRun(buildTargetAndConfigurationData, configurator));
    }

    protected ExecutionResult startRun(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(13);
        }
        RunnerAndConfigurationSettings settings = this.createRunConfiguration(buildTargetAndConfigurationData, configurator);
        return this.startRunDebug((CidrRunProfile)((CidrRunConfiguration)settings.getConfiguration()), null, true, this.RUN_STARTER, new XDebugSessionListener[0]);
    }

    @NotNull
    public abstract String getTestExecutablePath(@NotNull String var1) throws Exception;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.disposeSession();
        Disposer.dispose((Disposable)this.myDisposable);
        for (CheckedFutureResult each : this.myResultsToCheck) {
            each.tryGet();
        }
    }

    public void disposeSession() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.destroyProcess();
            CidrExecutionFixture.waitFor(this.myProcessHandler);
        }
        if (this.myConsole != null) {
            WriteAction.runAndWait(() -> {
                Disposer.dispose((Disposable)this.myConsole);
                this.myConsole = null;
            });
        }
    }

    public String runAndWait(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Long timeoutMs) throws Exception {
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(14);
        }
        ProcessOutputListener listener = new ProcessOutputListener();
        this.startRunSession(buildTargetAndConfigurationData, configurator, (ProcessListener)listener);
        CidrExecutionFixture.assertTrue((String)"Execution time out", (boolean)CidrExecutionFixture.waitFor(this.myProcessHandler, timeoutMs == null ? 30000L : timeoutMs));
        return listener.getAllOutput().replace("\r", "");
    }

    public String runAndWait(@Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.runAndWait(this.getBuildConfigurationData(), configurator, null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.runAndWait(targetName, configurationName, configurator, null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Long timeoutMs) throws Exception {
        return this.runAndWait(this.createBuildConfigurationData(targetName, configurationName), configurator, timeoutMs);
    }

    public String runAndWait() throws Exception {
        return this.runAndWait(null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName) throws Exception {
        return this.runAndWait(targetName, configurationName, null);
    }

    protected void initRunSession(ProcessListener listener, ExecutionResult result) {
        this.disposeSession();
        this.myConsole = result.getExecutionConsole();
        this.myProcessHandler = result.getProcessHandler();
        this.myExecutionResult = result;
        if (listener != null) {
            this.myProcessHandler.addProcessListener(listener);
        }
        this.myProcessHandler.startNotify();
    }

    public boolean waitForProcessHandler() {
        return CidrExecutionFixture.waitFor(this.myProcessHandler);
    }

    public static <T> T waitFor(BlockingQueue<T> q) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, 30000L);
    }

    public static <T> T waitFor(BlockingQueue<T> q, long timeout) throws InterruptedException {
        return q.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(ProcessHandler p) {
        return CidrExecutionFixture.waitFor(p, 30000L);
    }

    public static boolean waitFor(ProcessHandler p, long timeout) {
        return p.waitFor(timeout);
    }

    public static boolean waitFor(Semaphore s) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, 30000L);
    }

    public static boolean waitFor(Semaphore s, long timeout) throws InterruptedException {
        return s.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(CountDownLatch latch) throws InterruptedException {
        return CidrExecutionFixture.waitFor(latch, 30000L);
    }

    public static boolean waitFor(CountDownLatch latch, long timeout) throws InterruptedException {
        return latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public static <T> T waitFor(FutureResult<T> f) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, 30000L);
    }

    public static <T> T waitFor(FutureResult<T> f, long timeout) throws InterruptedException {
        try {
            Object result = f.get(timeout, TimeUnit.MILLISECONDS);
            f.reset();
            return (T)result;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getProcessInput() {
        return this.myProcessHandler.getProcessInput();
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static void assertOutput(@RegExp String expectedRegex, String output) {
        String regex = ".*?\n" + expectedRegex + "\nProcess finished with exit code 0\n";
        CidrExecutionFixture.assertTrue((String)(output + "\ndoes not match regex:\n" + regex), (boolean)output.matches(regex));
    }

    public void assertApplicationStopped(int pid, boolean appStopped) {
        ProcessInfo found2 = null;
        for (ProcessInfo each : OSProcessUtil.getProcessList()) {
            if (pid != each.getPid()) continue;
            found2 = each;
        }
        if (appStopped) {
            CidrExecutionFixture.assertNull((String)"Process should be stopped", found2);
        } else {
            CidrExecutionFixture.assertNotNull((String)("Process " + pid + " should be running"), found2);
        }
    }

    @NotNull
    public BuildTargetAndConfigurationData getBuildConfigurationData() {
        BuildTargetAndConfigurationData buildTargetAndConfigurationData = this.createBuildConfigurationData(this.myTargetName, this.myConfigurationName);
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(15);
        }
        return buildTargetAndConfigurationData;
    }

    @NotNull
    public BuildTargetAndConfigurationData createBuildConfigurationData(@Nullable String targetName, @Nullable String configName) {
        return new BuildTargetAndConfigurationData(((CidrProjectFixture)this.myProjectFixture).getProjectName(), targetName, configName);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(16);
        }
        return this.createRunConfiguration(this.myConfigurationType, buildTargetAndConfigurationData, configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(ConfigurationTypeBase type, Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.createRunConfiguration(type, this.myTargetName, this.myConfigurationName, configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @Nullable String targetName, @Nullable String configName, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        if (type == null) {
            CidrExecutionFixture.$$$reportNull$$$0(17);
        }
        return this.createRunConfiguration(type, this.createBuildConfigurationData(targetName, configName), configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        if (type == null) {
            CidrExecutionFixture.$$$reportNull$$$0(18);
        }
        if (buildTargetAndConfigurationData == null) {
            CidrExecutionFixture.$$$reportNull$$$0(19);
        }
        return ((CidrProjectFixture)this.myProjectFixture).createRunConfiguration("__test__", type, buildTargetAndConfigurationData, true, true, configurator);
    }

    public <T> CheckedFutureResult<T> createCheckedResult() {
        return new CheckedFutureResult();
    }

    public void startRerunSession() {
        CidrRerunFailedTestsAction action = (CidrRerunFailedTestsAction)((DefaultExecutionResult)this.myExecutionResult).getRestartActions()[0];
        ExecutionResult result = this.restartRunDebug(action, this.RUN_STARTER);
        this.myConsole = result.getExecutionConsole();
        this.myProcessHandler = result.getProcessHandler();
        this.myExecutionResult = result;
        this.myProcessHandler.startNotify();
    }

    protected <T> T restartRunDebug(@NotNull CidrRerunFailedTestsAction rerunAction, @NotNull Starter<T> starter) {
        if (rerunAction == null) {
            CidrExecutionFixture.$$$reportNull$$$0(20);
        }
        if (starter == null) {
            CidrExecutionFixture.$$$reportNull$$$0(21);
        }
        EdtTestUtil.runInEdtAndWait(PlatformTestUtil::dispatchAllEventsInIdeEventQueue);
        try {
            return (T)WriteAction.computeAndWait(() -> {
                CidrRunProfile profile = (CidrRunProfile)rerunAction.getRunProfile(null);
                CidrExecutionFixture.assertNotNull((Object)profile);
                return this.startRunDebug(profile, this.myExecutionTarget, false, starter, new XDebugSessionListener[0]);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrExecutionFixture";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 8: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTargetAndConfigurationData";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrExecutionFixture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFixture";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationType";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startRunDebug";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertConfigurationSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startRunSession";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startRun";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runAndWait";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "restartRunDebug";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class CheckedFutureResult<T>
    extends FutureResult<T> {
        public CheckedFutureResult() {
            CidrExecutionFixture.this.myResultsToCheck.add(this);
        }

        public synchronized void set(@Nullable T result) {
            this.checkNotSet();
            super.set(result);
        }

        public synchronized void setException(@NotNull Throwable e) {
            if (e == null) {
                CheckedFutureResult.$$$reportNull$$$0(0);
            }
            this.checkNotSet();
            super.setException(e);
        }

        private void checkNotSet() {
            try {
                Object alreadySet;
                try {
                    alreadySet = this.tryGet();
                }
                catch (ExecutionException e) {
                    throw new AssertionError((Object)("result is already set to exception" + e));
                }
                if (alreadySet != null) {
                    throw new AssertionError((Object)("result is already set: " + alreadySet));
                }
            }
            catch (AssertionError error) {
                this.reset();
                this.setException((Throwable)((Object)error));
                throw error;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/CidrExecutionFixture$CheckedFutureResult", "setException"));
        }
    }

    public static interface Starter<T> {
        public Executor executor();

        public T start(Executor var1, CidrRunner var2, CommandLineState var3, ExecutionEnvironment var4, XDebugSessionListener ... var5) throws com.intellij.execution.ExecutionException;
    }
}

