/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrProjectMarkup;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggingTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, PROJECT_MARKUP extends CidrProjectMarkup>
extends CidrDebuggerTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, PROJECT_MARKUP> {
    public CidrDebuggingTestCase(DebuggerDriverKind backend, String targetName, String fixtureProjectFileRelativePath, String fixtureProjectRelativeFilesToCopyPath) {
        super(backend, targetName, new CidrTestProjectDescription(fixtureProjectFileRelativePath, fixtureProjectRelativeFilesToCopyPath));
    }

    public CidrDebuggingTestCase(DebuggerDriverKind backend, String targetName, String fixtureProjectFileRelativePath) {
        super(backend, targetName, new CidrTestProjectDescription(fixtureProjectFileRelativePath));
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            CidrDebuggingTestCase.$$$reportNull$$$0(0);
        }
        return symbolsKind;
    }

    @Override
    public void afterProjectOpened() throws Exception {
        super.afterProjectOpened();
        this.setDefaultSettings();
    }

    private void setDefaultSettings() {
        CidrDebuggerSettings.getInstance().RENDERERS_ENABLED = true;
        CidrDebuggerSettings.getInstance().COCOA_RENDERERS_ENABLED = true;
        CidrDebuggerSettings.getInstance().STL_RENDERERS_ENABLED = true;
        CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED = true;
        CidrDebuggerSettings.getInstance().HEX_FORMATTING_ENABLED = false;
        CidrDebuggerSettings.getInstance().HEX_AS_SECONDARY_FORMATTING_ENABLED = true;
        CidrDebuggerSettings.getInstance().LLDB_NATVIS_RENDERERS_ENABLED = true;
        this.getProject().putUserData(CidrValue.DO_NOT_SHOW_ADDRESSES, (Object)true);
    }

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause() throws Exception {
        return this.startDebugSessionAndWaitForPause(null);
    }

    public BlockingQueue<CidrDebuggingFixture.DebuggerState> startDebugSessionAndWaitForPause(@Nullable String parameters) throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> stateQueue = this.myDebuggingFixture.startDebugSessionWithListener(parameters);
        CidrDebuggingFixture.DebuggerState state = CidrDebuggingFixture.waitFor(stateQueue, this.getStartupTimeout());
        CidrDebuggingTestCase.assertNotNull((String)("Timed out (" + this.getStartupTimeout() + ") while waiting for the debugger to pause"), (Object)state);
        CidrDebuggingTestCase.assertEquals((Object)CidrDebuggingFixture.DebuggerState.PAUSED, (Object)state);
        XDebuggerTestUtil.waitForSwing();
        return stateQueue;
    }

    public long getStartupTimeout() {
        return 120000L;
    }

    protected CidrDebugProcess getDebugProcess() {
        return this.myDebuggingFixture.getDebugProcess();
    }

    public XDebugSession getSession() {
        return this.myDebuggingFixture.getSession();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myDebuggingFixture != null) {
                this.myDebuggingFixture.tearDown();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    public List<XValue> collectVars(int frame) {
        XStackFrame frame1 = XDebuggerTestUtil.getFrameAt((XDebugSession)this.myDebuggingFixture.getSession(), (int)frame);
        return XDebuggerTestUtil.collectChildren((XValueContainer)frame1);
    }

    protected DebuggerDriver getSessionDriver() {
        return this.myDebuggingFixture.getDebugProcess().getDriverInTests();
    }

    protected long getCurrentThreadId() {
        return this.myDebuggingFixture.getDebugProcess().getCurrentThreadId();
    }

    public Pair<XValue, String> evaluate(String expression) {
        return XDebuggerTestUtil.evaluate((XDebugSession)this.getSession(), (String)expression, (long)60000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggingTestCase", "shouldBuildSymbolTables"));
    }
}

