/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.codeinsight;

import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import java.awt.Component;
import junit.framework.TestCase;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class CidrScratchTestUtils {
    public static void assertScratchIsSource(@NotNull FileType type, @NotNull CodeInsightTestFixture fixture) {
        if (type == null) {
            CidrScratchTestUtils.$$$reportNull$$$0(0);
        }
        if (fixture == null) {
            CidrScratchTestUtils.$$$reportNull$$$0(1);
        }
        Project project2 = fixture.getProject();
        PsiFile file2 = fixture.configureByText("foo." + type.getDefaultExtension(), " ");
        SymbolTableProvider provider = SymbolTableProvider.getProvider((PsiFile)file2);
        TestCase.assertNotNull((Object)provider);
        Editor editor = fixture.getEditor();
        editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
        AnAction action = ActionManager.getInstance().getAction("NewScratchFile");
        DataContext context = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        action.actionPerformed(AnActionEvent.createFromDataContext((String)"EditorTab", null, (DataContext)context));
        VirtualFile scratchFile = StreamEx.of((Object[])FileEditorManager.getInstance((Project)project2).getAllEditors()).map(e -> e.getFile()).findFirst(ScratchUtil::isScratch).orElse(null);
        TestCase.assertNotNull((Object)scratchFile);
        TestCase.assertTrue((boolean)SymbolTableProvider.isSourceFile((Project)project2, (VirtualFile)scratchFile));
        TestCase.assertEquals((Object)provider, (Object)SymbolTableProvider.findProvider((Project)project2, (VirtualFile)scratchFile));
        PsiFile scratchPsi = OCInclusionContextUtil.findCachedPsiFile((VirtualFile)scratchFile, (Project)project2);
        TestCase.assertNotNull((Object)scratchFile);
        TestCase.assertTrue((boolean)SymbolTableProvider.isSourceFile((PsiFile)scratchPsi));
        TestCase.assertEquals((Object)provider, (Object)SymbolTableProvider.getProvider((PsiFile)scratchPsi));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fixture";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/codeinsight/CidrScratchTestUtils";
        objectArray[2] = "assertScratchIsSource";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

