/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.renderers.UmlNodesListRenderer;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UmlLineToAction
extends DiagramAction {
    public UmlLineToAction(@Nls String name, @Nls String description) {
        super(name, description, UmlIcons.Dependencies);
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        PsiFile[] psiFileArray;
        PsiFile psiFile;
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(1);
        }
        DiagramNode selected = UmlLineToAction.getSelectedNodes(e).get(0);
        DiagramEdgeCreationPolicy<?> policy = UmlLineToAction.getProvider(e).getEdgeCreationPolicy();
        ArrayList nodes = new ArrayList();
        DiagramBuilder builder = UmlLineToAction.getBuilder(e);
        for (DiagramNode<?> node : builder.getNodeObjects()) {
            if (selected.equals(node) || node instanceof DiagramNoteNode || !policy.acceptTarget(node) || !policy.acceptTargetWithSource(node, selected)) continue;
            nodes.add(node);
        }
        PsiFile psiFile2 = psiFile = selected.getIdentifyingElement() instanceof PsiElement ? ((PsiElement)selected.getIdentifyingElement()).getContainingFile() : null;
        if (psiFile != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiFile})) {
            Messages.showErrorDialog((Project)psiFile.getProject(), (String)DiagramBundle.message("file.is.readonly", psiFile.getName()), (String)DiagramBundle.message("error", new Object[0]));
            return;
        }
        DiagramDataModel model = UmlLineToAction.getDataModel(e);
        JBList list = new JBList(nodes);
        list.setCellRenderer(UmlNodesListRenderer.INSTANCE);
        Runnable callback = () -> {
            DiagramNode target = (DiagramNode)list.getSelectedValue();
            if (target != null) {
                model.createEdge(selected, target);
                builder.update(true, false);
                builder.update(false, true);
            }
        };
        if (psiFile == null) {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        } else {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = psiFile;
        }
        PsiFile[] files = psiFileArray;
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(DiagramBundle.message("popup.title.select.target.node", new Object[0])).setFilteringEnabled((Function)new Namer()).setAutoselectOnMouseMove(true).setItemChoosenCallback(DiagramAction.createCallback(builder, new PopupCallback.Adapter(callback, this.getActionName(), files))).createPopup();
        GraphCanvasLocationService.getInstance().showInGraphCenter(popup, builder.getGraphBuilder());
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlLineToAction.$$$reportNull$$$0(2);
        }
        DiagramEdgeCreationPolicy policy = UmlLineToAction.getProvider(e).getEdgeCreationPolicy();
        List<DiagramNode> selected = UmlLineToAction.getSelectedNodes(e);
        boolean enabled = selected.size() == 1 && !(selected.get(0) instanceof DiagramNoteNode) && UmlLineToAction.getBuilder(e).getNodeObjects().size() > 1 && policy.acceptSource(selected.get(0));
        e.getPresentation().setEnabled(enabled);
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.create.line", new Object[0]);
        if (string == null) {
            UmlLineToAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlLineToAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlLineToAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Namer
    implements Function<Object, String> {
        private Namer() {
        }

        public String fun(Object o) {
            DiagramNode node = (DiagramNode)o;
            return node.getProvider().getElementManager().getElementTitle(node.getIdentifyingElement());
        }
    }
}

