/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.core.actions.DeleteSelectionWrapper;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlViewStructure
extends DiagramAction {
    @Override
    @NotNull
    @Nls
    public String getActionName() {
        String string = DiagramBundle.message("action.name.show.diagram.structure", new Object[0]);
        if (string == null) {
            UmlViewStructure.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlViewStructure.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlViewStructure.$$$reportNull$$$0(2);
        }
        DiagramBuilder builder = UmlViewStructure.getBuilder(e);
        Project project = e.getProject();
        if (builder == null || project == null) {
            return;
        }
        Map nodeNames = builder.getNodeObjects().stream().filter(node -> node != null && !(node instanceof DiagramNoteNode)).collect(Collectors.toMap(Function.identity(), it -> Objects.requireNonNullElse(UmlViewStructure.getNodeName(it), "")));
        PopupChooserBuilder popupBuilder = (PopupChooserBuilder)JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.sorted(Utils.getNodesExceptNotes(builder), Comparator.comparing(nodeNames::get)));
        JList popupList = (JList)popupBuilder.getChooserComponent();
        Ref popupRef = Ref.create();
        ActionListener elementRemoveListener = UmlViewStructure.createElementRemoveListener(builder, popupList, (Ref<JBPopup>)popupRef);
        JBPopup popup = popupBuilder.setTitle(DiagramBundle.message("uml.structure.view", new Object[0])).setResizable(true).setMovable(true).setRequestFocus(true).setSelectionMode(2).setNamerForFiltering(nodeNames::get).setRenderer(UmlViewStructure.createListCellRenderer()).setItemsChosenCallback(UmlViewStructure.createOnItemsChosenCallback(builder)).registerKeyboardAction(KeyStroke.getKeyStroke(127, 0), elementRemoveListener).registerKeyboardAction(KeyStroke.getKeyStroke(8, 0), elementRemoveListener).createPopup();
        popupRef.set((Object)popup);
        GraphCanvasLocationService.getInstance().showInGraphCenter(popup, builder.getGraphBuilder());
    }

    @NotNull
    private static Consumer<? super Set<? extends DiagramNode>> createOnItemsChosenCallback(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            UmlViewStructure.$$$reportNull$$$0(3);
        }
        Consumer consumer = modelNodes -> {
            Graph2D graph = builder.getGraph();
            List nodes = ContainerUtil.mapNotNull((Collection)modelNodes, builder::getNode);
            graph.unselectNodes();
            GraphSelectionService.getInstance().selectAllNodes(graph, (Collection)nodes, true);
            GraphAnimationService.getInstance().focusViewOnNodes(builder.getGraphBuilder(), (Collection)nodes, true);
            builder.getGraphBuilder().updateView();
        };
        if (consumer == null) {
            UmlViewStructure.$$$reportNull$$$0(4);
        }
        return consumer;
    }

    @NotNull
    private static ListCellRenderer<DiagramNode> createListCellRenderer() {
        ListCellRenderer<DiagramNode> listCellRenderer = (_list, value, _index, isSelected, _cellHasFocus) -> {
            SimpleColoredComponent component = new SimpleColoredComponent();
            component.setIpad((Insets)JBUI.insets((int)0, (int)15));
            if (isSelected) {
                component.setBackground(UIUtil.getListSelectionBackground((boolean)true));
                component.setForeground(UIUtil.getListSelectionForeground((boolean)true));
            }
            if (value != null) {
                component.setIcon(value.getIcon());
                component.setTransparentIconBackground(true);
                ObjectUtils.consumeIfNotNull((Object)UmlViewStructure.getNodeName(value), arg_0 -> ((SimpleColoredComponent)component).append(arg_0));
            }
            return component;
        };
        if (listCellRenderer == null) {
            UmlViewStructure.$$$reportNull$$$0(5);
        }
        return listCellRenderer;
    }

    @NotNull
    private static ActionListener createElementRemoveListener(@NotNull DiagramBuilder builder, @NotNull JList<DiagramNode> jList, @NotNull Ref<JBPopup> popup) {
        if (builder == null) {
            UmlViewStructure.$$$reportNull$$$0(6);
        }
        if (jList == null) {
            UmlViewStructure.$$$reportNull$$$0(7);
        }
        if (popup == null) {
            UmlViewStructure.$$$reportNull$$$0(8);
        }
        ActionListener actionListener = event -> {
            int newSelectionIndex = Math.max(0, Arrays.stream(jList.getSelectedIndices()).min().orElse(0) - 1);
            for (int index : jList.getSelectedIndices()) {
                DiagramNode node = (DiagramNode)jList.getModel().getElementAt(index);
                UmlViewStructure.removeSelectedNode(builder, event, node);
                ListUtil.removeItem(jList.getModel(), (int)index);
            }
            if (jList.getModel().getSize() == 0) {
                ((JBPopup)popup.get()).cancel();
            }
            jList.setSelectedIndex(newSelectionIndex);
        };
        if (actionListener == null) {
            UmlViewStructure.$$$reportNull$$$0(9);
        }
        return actionListener;
    }

    private static void removeSelectedNode(final @NotNull DiagramBuilder builder, @NotNull ActionEvent event, final @NotNull DiagramNode node) {
        if (builder == null) {
            UmlViewStructure.$$$reportNull$$$0(10);
        }
        if (event == null) {
            UmlViewStructure.$$$reportNull$$$0(11);
        }
        if (node == null) {
            UmlViewStructure.$$$reportNull$$$0(12);
        }
        DeleteSelectionWrapper removeAction = new DeleteSelectionWrapper(null, builder){

            @Override
            @NotNull
            public List<Node> getSelectedNodes() {
                List<Node> list = Collections.singletonList(builder.getNode(node));
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/core/actions/UmlViewStructure$1", "getSelectedNodes"));
            }
        };
        removeAction.actionPerformed(event);
        builder.getDataModel().refreshDataModel();
        builder.update(true, true);
    }

    @Nls
    private static String getNodeName(@Nullable DiagramNode node) {
        if (node != null) {
            DiagramBuilder builder = (DiagramBuilder)node.getUserData(Utils.GRAPH_BUILDER);
            if (builder != null) {
                SimpleColoredText name = builder.getProvider().getElementManager().getItemName(node.getIdentifyingElement(), builder);
                return name == null ? node.getTooltip() : name.toString();
            }
            return node.getTooltip();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlViewStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlViewStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOnItemsChosenCallback";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createListCellRenderer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementRemoveListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createOnItemsChosenCallback";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createElementRemoveListener";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

