/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.jigsaw;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.java.jigsaw.JigsawUmlProvider;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JigsawUmlElementManager
extends AbstractDiagramElementManager<PsiJavaModule> {
    JigsawUmlElementManager(@NotNull JigsawUmlProvider provider) {
        if (provider == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(0);
        }
        this.setUmlProvider(provider);
    }

    @Override
    @Nullable
    public PsiJavaModule findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(1);
        }
        Collection<PsiJavaModule> javaModules = JigsawUmlElementManager.findJavaModulesInDataContext(context, true);
        return (PsiJavaModule)ContainerUtil.getFirstItem(javaModules);
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(2);
        }
        return JigsawUmlElementManager.findJavaModulesInDataContext(context, false);
    }

    @NotNull
    private static Collection<PsiJavaModule> findJavaModulesInDataContext(DataContext context, boolean findFirst) {
        VirtualFile[] selectedFiles;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            Set<PsiJavaModule> set = Collections.emptySet();
            if (set == null) {
                JigsawUmlElementManager.$$$reportNull$$$0(3);
            }
            return set;
        }
        HashSet<PsiJavaModule> javaModules = new HashSet<PsiJavaModule>();
        Module[] selectedModules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context);
        if (selectedModules != null) {
            for (Module module : selectedModules) {
                if (JigsawUmlElementManager.addJavaModuleDefinition(project, javaModules, module, findFirst)) {
                    HashSet<PsiJavaModule> hashSet = javaModules;
                    if (hashSet == null) {
                        JigsawUmlElementManager.$$$reportNull$$$0(4);
                    }
                    return hashSet;
                }
                OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries();
                enumerator.forEachModule(subModule -> !JigsawUmlElementManager.addJavaModuleDefinition(project, javaModules, subModule, findFirst));
                if (!findFirst || javaModules.isEmpty()) continue;
                HashSet<PsiJavaModule> hashSet = javaModules;
                if (hashSet == null) {
                    JigsawUmlElementManager.$$$reportNull$$$0(5);
                }
                return hashSet;
            }
        }
        if ((selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context)) != null) {
            for (VirtualFile virtualFile : selectedFiles) {
                PsiJavaModule javaModule = JigsawUmlElementManager.findJavaModuleForVirtualFile(project, virtualFile);
                if (javaModule == null) continue;
                javaModules.add(javaModule);
                if (!findFirst) continue;
                HashSet<PsiJavaModule> hashSet = javaModules;
                if (hashSet == null) {
                    JigsawUmlElementManager.$$$reportNull$$$0(6);
                }
                return hashSet;
            }
        }
        if (javaModules.isEmpty() && (selectedModules != null || selectedFiles != null)) {
            GlobalSearchScope projectScope = ProjectScope.getProjectScope((Project)project);
            JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
            for (String name : index.getAllKeys(project)) {
                javaModules.addAll(index.get(name, project, projectScope));
                if (!findFirst || javaModules.isEmpty()) continue;
                HashSet<PsiJavaModule> hashSet = javaModules;
                if (hashSet == null) {
                    JigsawUmlElementManager.$$$reportNull$$$0(7);
                }
                return hashSet;
            }
        }
        HashSet<PsiJavaModule> hashSet = javaModules;
        if (hashSet == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private static boolean addJavaModuleDefinition(@NotNull Project project, @NotNull Set<PsiJavaModule> javaModules, @NotNull Module module, boolean findFirst) {
        PsiJavaModule javaModule;
        VirtualFile[] sourceRoots;
        if (project == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(9);
        }
        if (javaModules == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(10);
        }
        if (module == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(11);
        }
        if ((sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false)).length != 0 && (javaModule = JigsawUmlElementManager.findJavaModuleForVirtualFile(project, sourceRoots[0])) != null) {
            javaModules.add(javaModule);
            if (findFirst) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiJavaModule findJavaModuleForVirtualFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(12);
        }
        PsiFileSystemItem psiElement = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)virtualFile);
        return JavaModuleGraphUtil.findDescriptorByElement((PsiElement)psiElement);
    }

    @Override
    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof PsiJavaModule || element instanceof PsiElement && JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)element)) != null;
    }

    @Override
    @Nullable
    public String getElementTitle(PsiJavaModule element) {
        return element.getName();
    }

    @Override
    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(13);
        }
        return element instanceof PsiJavaModule ? new SimpleColoredText(((PsiJavaModule)element).getName(), DEFAULT_TITLE_ATTR) : null;
    }

    @Override
    @Nullable
    @Nls
    public String getNodeTooltip(PsiJavaModule element) {
        return element.getName();
    }

    @Override
    @Nullable
    public String getEditorTitle(PsiJavaModule element, @NotNull DiagramState presentation, @NotNull Collection<PsiJavaModule> additionalElements) {
        if (presentation == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(14);
        }
        if (additionalElements == null) {
            JigsawUmlElementManager.$$$reportNull$$$0(15);
        }
        return DiagramBundle.message("uml.jigsaw.presentable.name", new Object[0]);
    }

    @Override
    public int getTitleAttributes(PsiJavaModule element) {
        return PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)element) ? 4 : super.getTitleAttributes(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/jigsaw/JigsawUmlElementManager";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/jigsaw/JigsawUmlElementManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaModulesInDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addJavaModuleDefinition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findJavaModuleForVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

