/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.util.ExceptionUtilRt;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;

@ApiStatus.Experimental
public final class MessageBuilder {
    @Nullable
    private String myGroup;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myText;
    @Nullable
    private Exception myException;
    @NotNull
    private Message.Kind myKind;
    @Nullable
    private String myFilePath;
    private int myLine;
    private int myColumn;

    private MessageBuilder(@NotNull String title, @NotNull String text) {
        if (title == null) {
            MessageBuilder.$$$reportNull$$$0(0);
        }
        if (text == null) {
            MessageBuilder.$$$reportNull$$$0(1);
        }
        this.myKind = Message.Kind.INFO;
        this.myTitle = title;
        this.myText = text;
    }

    public static MessageBuilder create(@NotNull String title, @NotNull String text) {
        if (title == null) {
            MessageBuilder.$$$reportNull$$$0(2);
        }
        if (text == null) {
            MessageBuilder.$$$reportNull$$$0(3);
        }
        return new MessageBuilder(title, text);
    }

    public MessageBuilder warning() {
        this.myKind = Message.Kind.WARNING;
        return this;
    }

    public MessageBuilder error() {
        this.myKind = Message.Kind.ERROR;
        return this;
    }

    public MessageBuilder withGroup(String group) {
        this.myGroup = group;
        return this;
    }

    public MessageBuilder withException(Exception e) {
        this.myException = e;
        return this;
    }

    public MessageBuilder withLocation(String filePath, int line, int column) {
        this.myFilePath = filePath;
        this.myLine = line;
        this.myColumn = column;
        return this;
    }

    @NotNull
    public Message build() {
        String text = this.myText;
        if (this.myException != null) {
            text = this.myException.getStackTrace().length > 0 ? text + "\n\n" + MessageBuilder.getErrorMessage(this.myException) : text + "\n\n" + this.myException.getMessage();
        }
        Message.FilePosition filePosition = this.myFilePath == null ? null : new Message.FilePosition(this.myFilePath, this.myLine, this.myColumn);
        return new Message(this.myTitle, text, this.myGroup, this.myKind, filePosition);
    }

    public String buildJson() {
        return new GsonBuilder().create().toJson((Object)this.build());
    }

    @Contract(value="null -> null; !null->!null")
    private static String getErrorMessage(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        ExternalSystemException esException = (ExternalSystemException)ExceptionUtilRt.findCause((Throwable)e, ExternalSystemException.class);
        if (esException != null && esException != e) {
            sw.append("\nCaused by: ").append(esException.getOriginalReason());
        }
        return sw.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/MessageBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

