/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.emojipicker.messages.EmojipickerBundle;
import org.jetbrains.plugins.emojipicker.ui.EmojiPicker;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;
import org.jetbrains.plugins.emojipicker.ui.EmojiSkinTonesPanel;

public class EmojiSearchField
extends ExtendableTextField {
    private static final ExtendableTextComponent.Extension SEARCH_ICON_EXTENSION = new ExtendableTextComponent.Extension(){

        public Icon getIcon(boolean hovered) {
            return AllIcons.Actions.Search;
        }

        public boolean isIconBeforeText() {
            return true;
        }

        public int getIconGap() {
            return JBUIScale.scale((int)6);
        }
    };
    private final EmojiPicker myEmojiPicker;
    private final EmojiPickerStyle myStyle;
    private final List<ExtendableTextComponent.Extension> myExtensions;
    private final ExtendableTextComponent.Extension mySkinToneExtension;

    EmojiSearchField(final EmojiPicker emojiPicker, EmojiPickerStyle style) {
        this.myEmojiPicker = emojiPicker;
        this.myStyle = style;
        this.mySkinToneExtension = new ExtendableTextComponent.Extension(){

            public Icon getIcon(boolean hovered) {
                return emojiPicker.getCurrentSkinToneIcon(hovered);
            }

            public boolean isIconBeforeText() {
                return false;
            }

            public int getIconGap() {
                return JBUIScale.scale((int)6);
            }

            public Runnable getActionOnClick() {
                return emojiPicker::openSkinToneSelectionPanel;
            }

            @NlsContexts.Tooltip
            public String getTooltip() {
                return EmojipickerBundle.message("message.EmojiPicker.ChangeSkinTone", new Object[0]);
            }
        };
        this.myExtensions = List.of(SEARCH_ICON_EXTENSION, this.mySkinToneExtension);
        JBDimension size = new JBDimension(0, 40);
        this.setPreferredSize((Dimension)size);
        this.setMinimumSize((Dimension)size);
        this.setExtensions(new ExtendableTextComponent.Extension[]{SEARCH_ICON_EXTENSION});
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)0, (int)8));
        this.setBackground(this.myStyle.myBackgroundColor);
        this.setFocusTraversalKeysEnabled(false);
        this.setLayout(new BorderLayout());
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                emojiPicker.search(EmojiSearchField.this.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/emojipicker/ui/EmojiSearchField$3", "textChanged"));
            }
        });
        this.addKeyListener(new KeyAdapter(){

            void handle(KeyEvent e, boolean typed) {
                boolean mayIntercept;
                int c = typed ? e.getKeyChar() : e.getKeyCode();
                boolean bl = mayIntercept = c == 32 || c == 10;
                if (mayIntercept == typed && emojiPicker.handleKey(c, e.getModifiersEx())) {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.handle(e, true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.handle(e, false);
            }
        });
    }

    void update() {
        this.setExtensions(this.myExtensions);
    }

    public Point getSkinToneIconCenter() {
        return new Point(this.getWidth() - this.getInsets().right - this.mySkinToneExtension.getIconGap() - this.mySkinToneExtension.getIcon(false).getIconWidth() / 2, this.getHeight() / 2);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myEmojiPicker.getCurrentFocusTarget() instanceof EmojiSkinTonesPanel) {
            g.setColor(this.myStyle.myFocusBorderColor);
            double size = (double)JBUIScale.scale((float)34.0f) - 4.0;
            Point center = this.getSkinToneIconCenter();
            RectanglePainter2D.DRAW.paint((Graphics2D)g, (double)center.x - size / 2.0, (double)center.y - size / 2.0, size, size, (Object)6.0);
        }
    }
}

