/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestScopeSerialization;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestFramework;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestUtil {
    @NonNls
    static final String TEST_METHOD_NAME = "test_method";
    @NonNls
    static final String _IMPL_NAME = "_impl";
    private static final Pattern REGISTRAR = Pattern.compile(".*_registrar\\d+");
    @NonNls
    private static final String REGISTRAR_TYPE = "auto_test_unit_registrar";
    @NonNls
    private static final String MAKE_TEST_CASE = "make_test_case";
    @NonNls
    private static final String MAKE_TEST_CASE_DATA_GEN = "make_test_case_gen";
    @NonNls
    private static final String MAKE_TEST_CASE_TEMPLATE_GEN = "template_test_case_gen";
    @NonNls
    private static final String INVOKER_SUFFIX = "_invoker";

    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(0);
        }
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final Project project = file.getProject();
        final VirtualFile virtualFile = file.getVirtualFile();
        final CidrBoostTestFramework testFramework = CidrBoostTestFramework.getInstance();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(project).value((Object)virtualFile);
        Processor<OCSymbol> processor = new Processor<OCSymbol>(){
            final Stack<OCNamespaceSymbol> namespaces = new Stack();
            final Stack<String> suites = new Stack();
            String myLastSuiteQName;

            public boolean process(@NotNull OCSymbol symbol) {
                List arguments;
                OCArgumentList argumentList;
                OCDeclarator declarator;
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project);
                if (psiFile == null || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)psiFile);
                if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    this.namespaces.push((Object)((OCNamespaceSymbol)symbol));
                    List membersList = ((OCNamespaceSymbol)symbol).getMembersList();
                    if (membersList != null) {
                        for (OCSymbol nsSymbol : membersList) {
                            this.process(nsSymbol);
                        }
                    }
                    String endNamespace = ((OCNamespaceSymbol)this.namespaces.pop()).getName();
                    if (this.suites.size() > 0 && ((String)this.suites.peek()).equals(endNamespace)) {
                        this.suites.pop();
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE && REGISTRAR.matcher(symbol.getName()).find() && CidrBoostTestUtil.REGISTRAR_TYPE.equals(symbol.getType().getName()) && (declarator = (OCDeclarator)symbol.locateDefinition(project)) != null && (argumentList = declarator.getArgumentList()) != null && (arguments = argumentList.getArguments()).size() > 0) {
                    OCReferenceElement testFactoryRefElement;
                    OCExpression ref;
                    OCExpression expression = (OCExpression)arguments.get(0);
                    if (expression instanceof OCLiteralExpression) {
                        String suiteQName;
                        OCNamespaceSymbol nsSymbol;
                        String suiteName = ((OCLiteralExpression)expression).getEscapedLiteralText();
                        if (!this.namespaces.isEmpty() && (nsSymbol = (OCNamespaceSymbol)this.namespaces.peek()).getName().equals(suiteName) && (suiteQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)nsSymbol, (OCResolveContext)context)) != null) {
                            this.suites.push((Object)suiteName);
                            links.put(suiteQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)CidrTestScopeElementImpl.createPathFromParts(this.suites), (long)symbol.getComplexOffset(), (String)suiteQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.NAMESPACE, testFramework.getGenerator()));
                            this.myLastSuiteQName = suiteQName;
                        }
                    } else if (expression instanceof OCCallExpression && (ref = ((OCCallExpression)expression).getFunctionReferenceExpression()) instanceof OCReferenceExpression && (testFactoryRefElement = ((OCReferenceExpression)ref).getReferenceElement()) != null) {
                        String functionName = testFactoryRefElement.getCanonicalText();
                        List makeTestCaseArgs = ((OCCallExpression)expression).getArgumentList().getArguments();
                        Pair<String, String> pair = null;
                        boolean testAsSuite = false;
                        if (CidrBoostTestUtil.MAKE_TEST_CASE.equals(functionName)) {
                            pair = CidrBoostTestUtil.processOrdinalTest(makeTestCaseArgs, context);
                        } else if (CidrBoostTestUtil.MAKE_TEST_CASE_DATA_GEN.equals(functionName)) {
                            pair = CidrBoostTestUtil.processDataGeneratorTest(testFactoryRefElement, makeTestCaseArgs);
                            testAsSuite = true;
                        } else if (CidrBoostTestUtil.MAKE_TEST_CASE_TEMPLATE_GEN.equals(functionName)) {
                            pair = CidrBoostTestUtil.processTemplateGeneratorTest(testFactoryRefElement, makeTestCaseArgs);
                        }
                        if (pair != null) {
                            String generatorWrapperSuite = null;
                            String testName = (String)pair.second;
                            String testQName = (String)pair.first + "::" + (testAsSuite ? CidrBoostTestUtil._IMPL_NAME : CidrBoostTestUtil.TEST_METHOD_NAME);
                            if (testAsSuite && !this.suites.isEmpty()) {
                                generatorWrapperSuite = (String)this.suites.pop();
                            }
                            links.put(testQName, CidrTestScopeSerialization.createTestScopeElementForCaching((String)testName, (String)CidrTestScopeElementImpl.createPathFromParts(this.suites), (long)symbol.getComplexOffset(), (String)testQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.FUNCTION_DECLARATION, testFramework.getGenerator()));
                            if (generatorWrapperSuite != null) {
                                if (this.myLastSuiteQName != null) {
                                    links.remove(this.myLastSuiteQName);
                                }
                                this.suites.push((Object)generatorWrapperSuite);
                            }
                        }
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestUtil$1", "process"));
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, (Processor)processor);
        return links;
    }

    @Nullable
    private static Pair<String, String> processDataGeneratorTest(@NotNull OCReferenceElement testFactoryCall, @NotNull List<OCExpression> makeTestCaseArgs) {
        OCExpression testNameHolder;
        if (testFactoryCall == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(1);
        }
        if (makeTestCaseArgs == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(2);
        }
        if (makeTestCaseArgs.size() > 0 && (testNameHolder = makeTestCaseArgs.get(0)) instanceof OCLiteralExpression) {
            OCElement testClass;
            List listArguments;
            String test = ((OCLiteralExpression)testNameHolder).getEscapedLiteralText();
            OCTemplateArgumentList templateArgumentList = (OCTemplateArgumentList)PsiTreeUtil.findChildOfType((PsiElement)testFactoryCall, OCTemplateArgumentList.class);
            if (templateArgumentList != null && (listArguments = templateArgumentList.getArguments()).size() > 0 && (testClass = (OCElement)listArguments.get(0)) instanceof OCTypeElement) {
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)testFactoryCall);
                String testClassName = ((OCTypeElement)testClass).getType().resolve(context).getCanonicalName(context);
                return Pair.create((Object)testClassName, (Object)test);
            }
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> processTemplateGeneratorTest(@NotNull OCReferenceElement testFactoryCall, @NotNull List<OCExpression> makeTestCaseArgs) {
        OCExpression testNameHolder;
        if (testFactoryCall == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(3);
        }
        if (makeTestCaseArgs == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(4);
        }
        if (makeTestCaseArgs.size() > 0 && (testNameHolder = makeTestCaseArgs.get(0)) instanceof OCLiteralExpression) {
            OCElement testClass;
            List listArguments;
            String test = ((OCLiteralExpression)testNameHolder).getEscapedLiteralText();
            OCTemplateArgumentList templateArgumentList = (OCTemplateArgumentList)PsiTreeUtil.findChildOfType((PsiElement)testFactoryCall, OCTemplateArgumentList.class);
            if (templateArgumentList != null && (listArguments = templateArgumentList.getArguments()).size() > 0 && (testClass = (OCElement)listArguments.get(0)) instanceof OCTypeElement) {
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)testFactoryCall);
                String testClassName = ((OCTypeElement)testClass).getType().resolve(context).getCanonicalName(context);
                if (testClassName.endsWith(INVOKER_SUFFIX)) {
                    return Pair.create((Object)testClassName.substring(0, testClassName.length() - INVOKER_SUFFIX.length()), (Object)(test + "<>"));
                }
            }
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> processOrdinalTest(@NotNull List<OCExpression> makeTestCaseArgs, @NotNull OCResolveContext context) {
        OCExpression maybeTestName;
        if (makeTestCaseArgs == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CidrBoostTestUtil.$$$reportNull$$$0(6);
        }
        if (makeTestCaseArgs.size() > 1 && (maybeTestName = makeTestCaseArgs.get(1)) instanceof OCLiteralExpression) {
            String name;
            OCQualifiedName qualifiedName;
            OCSymbol symbolRef;
            OCExpression maybeInvokerRef;
            String test = ((OCLiteralExpression)maybeTestName).getEscapedLiteralText();
            OCExpression maybeInvoker = makeTestCaseArgs.get(0);
            if (maybeInvoker instanceof OCUnaryExpression && (maybeInvokerRef = ((OCUnaryExpression)maybeInvoker).getOperand()) instanceof OCReferenceExpression && (symbolRef = ((OCReferenceExpression)maybeInvokerRef).resolveToSymbol()) instanceof OCFunctionSymbol && (qualifiedName = ((OCFunctionSymbol)symbolRef).getResolvedQualifiedName(context)) != null && (name = qualifiedName.getFullName(context)) != null && name.endsWith(INVOKER_SUFFIX)) {
                String testClassName = name.substring(0, name.length() - INVOKER_SUFFIX.length());
                return Pair.create((Object)testClassName, (Object)test);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFactoryCall";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "makeTestCaseArgs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestLinks";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processDataGeneratorTest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processTemplateGeneratorTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processOrdinalTest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

