/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.editor;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRule;
import com.intellij.lang.javascript.linter.tslint.editor.TsLintCodeStyleEditorNotificationProvider;
import com.intellij.lang.javascript.linter.tslint.editor.TsLintCodeStyleEditorNotificationProviderKt;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001b\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00020\u00020\u0010\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/editor/TsLintCodeStyleEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "NOTIFICATION_DISMISSED_PROPERTY", "", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "dismissNotification", "", "getKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isNotificationDismissed", "", "intellij.tslint"})
public final class TsLintCodeStyleEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final String NOTIFICATION_DISMISSED_PROPERTY;
    private final Project project;

    private final boolean isNotificationDismissed(VirtualFile file) {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(this.NOTIFICATION_DISMISSED_PROPERTY) || !TslintUtil.isConfigFile(file);
    }

    private final void dismissNotification() {
        PropertiesComponent.getInstance((Project)this.project).setValue(this.NOTIFICATION_DISMISSED_PROPERTY, true);
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return TsLintCodeStyleEditorNotificationProviderKt.access$getKEY$p();
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!(fileEditor instanceof TextEditor) || !(((TextEditor)fileEditor).getEditor() instanceof EditorEx)) {
            return null;
        }
        if (this.isNotificationDismissed(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026File(file) ?: return null");
        PsiFile psiFile2 = psiFile;
        TsLintConfigWrapper tsLintConfigWrapper = TsLintConfigWrapper.Companion.getConfigForFile(psiFile2);
        if (tsLintConfigWrapper == null) {
            return null;
        }
        TsLintConfigWrapper wrapper = tsLintConfigWrapper;
        Collection<TsLintRule> rules = wrapper.getRulesToApply(project);
        if (rules.isEmpty()) {
            return null;
        }
        return new EditorNotificationPanel(this, EditorColors.GUTTER_BACKGROUND){
            final /* synthetic */ TsLintCodeStyleEditorNotificationProvider this$0;
            {
                this.this$0 = this$0;
                super($super_call_param$1);
                this.setText(TsLintBundle.message("tslint.code.style.apply.message", new Object[0]));
                this.createActionLabel(CommonBundle.message((String)"button.without.mnemonic.yes", (Object[])new Object[0]), "TslintImportCodeStyleAction", false);
                this.createActionLabel(CommonBundle.message((String)"button.without.mnemonic.no", (Object[])new Object[0]), new Runnable(this){
                    final /* synthetic */ createNotificationPanel.1 this$0;

                    public final void run() {
                        TsLintCodeStyleEditorNotificationProvider.access$dismissNotification(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, false);
            }
        };
    }

    public TsLintCodeStyleEditorNotificationProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.NOTIFICATION_DISMISSED_PROPERTY = "tslint.code.style.apply.dismiss";
    }

    public static final /* synthetic */ void access$dismissNotification(TsLintCodeStyleEditorNotificationProvider $this) {
        $this.dismissNotification();
    }
}

