/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.compdb.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.compdb.CompDBLog;
import com.jetbrains.cidr.cpp.compdb.CompDBUtil;
import com.jetbrains.cidr.cpp.compdb.CompDBWorkspace;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBProjectSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDBSettings;
import com.jetbrains.cidr.cpp.compdb.settings.CompDbSettingsAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/compdb/project/CompDBStartupActivity;", "", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.compdb"})
public final class CompDBStartupActivity {
    @NotNull
    public static final CompDBStartupActivity INSTANCE;

    public final void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(CompDBSettings.Companion.getInstance(project).getChangesTopic(), (Object)new CompDbSettingsAdapter(project){
            final /* synthetic */ Project $project;

            public void onToolchainChanged(@Nullable String oldToolchainName, @Nullable String newToolchainName) {
                CompDBLog.INSTANCE.getLOG().debug("CompDB toolchain changed from: " + oldToolchainName + " to: " + newToolchainName);
                for (CompDBProjectSettings projectSettings : CompDBSettings.Companion.getInstance(this.$project).getLinkedProjectsSettings()) {
                    ExternalProjectsManager externalProjectsManager = ExternalProjectsManager.getInstance((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)externalProjectsManager, (String)"ExternalProjectsManager.getInstance(project)");
                    ExternalSystemProjectsWatcher externalSystemProjectsWatcher = externalProjectsManager.getExternalProjectsWatcher();
                    CompDBProjectSettings compDBProjectSettings = projectSettings;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)compDBProjectSettings), (String)"projectSettings");
                    externalSystemProjectsWatcher.markDirty(compDBProjectSettings.getExternalProjectPath());
                }
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
        if (!CompDBUtil.INSTANCE.isCompDBProject(project)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                CompDBWorkspace workspace = CompDBWorkspace.Companion.getInstance(this.$project);
                if (workspace == null || !workspace.isInitialized()) {
                    return;
                }
                workspace.checkInitialState();
            }
            {
                this.$project = project;
            }
        });
    }

    private CompDBStartupActivity() {
    }

    static {
        CompDBStartupActivity compDBStartupActivity;
        INSTANCE = compDBStartupActivity = new CompDBStartupActivity();
    }
}

