/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeSerialization;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestUtil {
    private static final Pattern INSTANTIATE_DATA_TEST = Pattern.compile("gtest_(\\w*)_dummy_");
    private static final Pattern INSTANTIATE_TYPED_TEST = Pattern.compile("gtest_(\\w*)_(\\w*)");
    private static final Pattern SKIP_REGISTRATION_TEST = Pattern.compile("gtest_(\\w*)_(\\w*)_registered_");
    private static final Pattern REGISTER_TYPED_TEST = Pattern.compile("gtest_registered_test_names_(\\w*)_");
    private static final Pattern TYPED_TEST_CASE_P = Pattern.compile("gtest_typed_test_(?:case|suite)_p_state_(\\w*)_");
    private static final Pattern TYPED_TEST_CASE = Pattern.compile("gtest_type_params_(\\w*)_");
    @NonNls
    public static final String TEST_BODY = "TestBody";
    @NonNls
    private static final String ADD_TO_REGISTRY = "AddToRegistry";
    @NonNls
    private static final String REGISTER = "Register";
    @NonNls
    private static final String TEST_INFO = "test_info_";
    private static final Pattern STAFF_GT_FILES = Pattern.compile("(?:gtest|gmock)(?:[_\\-][^.]+)?\\.h");
    @NonNls
    private static final String GTEST_BASE_CLASS_FULL = "::testing::Test";

    @NotNull
    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(0);
        }
        final int iterationCountToFindGTestAsBaseClass = Registry.intValue((String)"cidr.test.framework.base.class.iteration.count");
        final int longestBaseClassResolveInMS = Registry.intValue((String)"cidr.test.framework.base.class.resolving.time.ms");
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final Project project = file.getProject();
        final CidrGoogleTestFramework testFramework = CidrGoogleTestFramework.getInstance();
        final VirtualFile virtualFile = file.getVirtualFile();
        final boolean isRoot = testFramework.isPotentialTestHolderRoot(file.getProject()).value((Object)virtualFile);
        Processor<OCSymbol> processor = new Processor<OCSymbol>(){

            public boolean process(@NotNull OCSymbol symbol) {
                OCStructSymbol test;
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!isRoot && !virtualFile.equals(symbol.getContainingFile())) {
                    return true;
                }
                PsiFile psiFile = symbol.getContainingPsiFile(project);
                if (psiFile == null || CidrGoogleTestUtil.skipFile(psiFile) || testFramework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) {
                    return true;
                }
                if (CidrTestUtil.processNamespaceRecursively((OCSymbol)symbol, (Processor)this)) {
                    return true;
                }
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)psiFile);
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    String testRefQName;
                    OCDeclaratorSymbol test2 = (OCDeclaratorSymbol)symbol;
                    String varName = test2.getName();
                    Matcher matcher = TYPED_TEST_CASE_P.matcher(varName);
                    if (matcher.find() && (testRefQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)test2, (OCResolveContext)context)) != null) {
                        links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + matcher.group(1)), (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, testFramework.getGenerator()));
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.TYPEDEF) {
                    String testRefQName;
                    OCDeclaratorSymbol test3 = (OCDeclaratorSymbol)symbol;
                    String varName = test3.getName();
                    Matcher matcher = TYPED_TEST_CASE.matcher(varName);
                    if (matcher.matches() && (testRefQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)test3, (OCResolveContext)context)) != null) {
                        links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + matcher.group(1)), (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.TYPEDEF, testFramework.getGenerator()));
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE) {
                    String testRefQName;
                    OCDeclaratorSymbol test4 = (OCDeclaratorSymbol)symbol;
                    String varName = test4.getName();
                    Matcher matcher = SKIP_REGISTRATION_TEST.matcher(varName);
                    if (matcher.find()) {
                        return true;
                    }
                    matcher = REGISTER_TYPED_TEST.matcher(varName);
                    if (matcher.find()) {
                        String testRefQName2 = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)test4, (OCResolveContext)context);
                        if (testRefQName2 != null) {
                            links.put(testRefQName2, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + matcher.group(1)), (long)symbol.getComplexOffset(), (String)testRefQName2, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                        }
                        return true;
                    }
                    matcher = INSTANTIATE_DATA_TEST.matcher(varName);
                    if (matcher.find()) {
                        Couple<String> suite_data = CidrGoogleTestUtil.extractInstantiateTestName(test4, project);
                        testRefQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)test4, (OCResolveContext)context);
                        if (suite_data != null && testRefQName != null) {
                            links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + (String)suite_data.getFirst() + CidrTestScopeElement.SEPARATOR + "data:" + (String)suite_data.getSecond()), (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                            return true;
                        }
                    }
                    if ((matcher = INSTANTIATE_TYPED_TEST.matcher(varName)).find()) {
                        Couple<String> instantiate_suite = CidrGoogleTestUtil.extractInstantiateTypedTestName(test4, project);
                        testRefQName = CidrTestUtil.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)test4, (OCResolveContext)context);
                        if (instantiate_suite != null && testRefQName != null) {
                            links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + (String)instantiate_suite.getSecond() + CidrTestScopeElement.SEPARATOR + "type:" + (String)instantiate_suite.getFirst()), (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.GLOBAL_VARIABLE, testFramework.getGenerator()));
                            return true;
                        }
                    }
                } else if (symbol instanceof OCStructSymbol && CidrGoogleTestUtil.hasGTAsBaseClasses(test = (OCStructSymbol)symbol, context, iterationCountToFindGTestAsBaseClass, longestBaseClassResolveInMS)) {
                    Couple<String> suite_test;
                    String testRefQName = test.getType().getCanonicalName(context);
                    String className = test.getName();
                    CommonProcessors.FindFirstAndOnlyProcessor firstAndOnlyProcessor = new CommonProcessors.FindFirstAndOnlyProcessor();
                    test.processFunctions(CidrGoogleTestUtil.TEST_BODY, (Processor)firstAndOnlyProcessor);
                    if (firstAndOnlyProcessor.getFoundValue() != null && (suite_test = CidrGoogleTestUtil.extractGoogleTestName(test, project)) != null) {
                        String bodyQName = testRefQName + "::TestBody";
                        String testName = "test:" + (String)suite_test.getSecond();
                        String suiteName = "suite:" + (String)suite_test.getFirst();
                        links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching((String)testName, (String)suiteName, (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.STRUCT, testFramework.getGenerator()));
                        links.put(bodyQName, CidrTestScopeSerialization.createTestScopeElementForCaching((String)testName, (String)suiteName, (long)((OCFunctionSymbol)firstAndOnlyProcessor.getFoundValue()).getComplexOffset(), (String)bodyQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.FUNCTION_DECLARATION, testFramework.getGenerator()));
                        return true;
                    }
                    links.put(testRefQName, CidrTestScopeSerialization.createTestScopeElementForCaching(null, (String)("suite:" + className), (long)symbol.getComplexOffset(), (String)testRefQName, (PsiFile)psiFile, (OCSymbolKind)OCSymbolKind.STRUCT, testFramework.getGenerator()));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestUtil$1", "process"));
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, (Processor)processor);
        HashMap<String, CidrTestScopeElement> hashMap = links;
        if (hashMap == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static boolean skipFile(@NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(2);
        }
        return STAFF_GT_FILES.matcher(file.getName()).matches();
    }

    private static boolean hasGTAsBaseClasses(@NotNull OCStructSymbol struct, @NotNull OCResolveContext context, int iterationCountToFindGTestAsBaseClass, final int longestBaseClassResolveInMS) {
        if (struct == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(4);
        }
        if (CidrGoogleTestUtil.isTraitLike(CidrGoogleTestUtil.getCanonicalAndPlainNames(struct, context))) {
            return false;
        }
        HashMap<String, Boolean> className2isTest = new HashMap<String, Boolean>();
        Stack<OCStructSymbol> structsWorkset = new Stack<OCStructSymbol>();
        structsWorkset.add(struct);
        int iterationCountToFindGTestAsParent = iterationCountToFindGTestAsBaseClass;
        while (!structsWorkset.isEmpty() && iterationCountToFindGTestAsParent-- > 0) {
            OCStructSymbol _symbol = (OCStructSymbol)structsWorkset.pop();
            Couple<String> _symbolCanonicalAndPlainName = CidrGoogleTestUtil.getCanonicalAndPlainNames(_symbol, context);
            if (className2isTest.containsKey(_symbolCanonicalAndPlainName.second)) {
                if (className2isTest.get(_symbolCanonicalAndPlainName.second) != Boolean.TRUE) continue;
                return true;
            }
            className2isTest.put((String)_symbolCanonicalAndPlainName.second, null);
            final Ref timeoutInResolve = Ref.create((Object)false);
            try {
                Boolean isTest = (Boolean)ProgressManager.getInstance().runProcess(() -> !_symbol.processBaseClasses(context, (baseSymbol, baseVisibility) -> {
                    if (baseSymbol instanceof OCStructSymbol) {
                        Couple<String> _baseCanonicalAndPlainName = CidrGoogleTestUtil.getCanonicalAndPlainNames((OCStructSymbol)baseSymbol, context);
                        if (GTEST_BASE_CLASS_FULL.equals(_baseCanonicalAndPlainName.first)) {
                            return false;
                        }
                        if (!CidrGoogleTestUtil.isTraitLike(_baseCanonicalAndPlainName)) {
                            structsWorkset.push((OCStructSymbol)baseSymbol);
                        }
                    }
                    return true;
                }), (ProgressIndicator)new AbstractProgressIndicatorBase(){
                    final long startTime = System.currentTimeMillis();

                    public boolean isCanceled() {
                        if (super.isCanceled()) {
                            return true;
                        }
                        if (System.currentTimeMillis() - this.startTime > (long)longestBaseClassResolveInMS) {
                            timeoutInResolve.set((Object)true);
                            this.cancel();
                            return true;
                        }
                        return false;
                    }
                });
                className2isTest.put((String)_symbolCanonicalAndPlainName.second, isTest);
                if (isTest != Boolean.TRUE) continue;
                return true;
            }
            catch (ProcessCanceledException e) {
                if (((Boolean)timeoutInResolve.get()).booleanValue()) continue;
                throw e;
            }
        }
        return false;
    }

    private static boolean isTraitLike(@NotNull Couple<String> canonicalAndPlainNames) {
        if (canonicalAndPlainNames == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(5);
        }
        return ((String)canonicalAndPlainNames.first).indexOf((String)canonicalAndPlainNames.second, ((String)canonicalAndPlainNames.second).length()) >= 0;
    }

    private static Couple<String> getCanonicalAndPlainNames(@NotNull OCStructSymbol struct, @NotNull OCResolveContext context) {
        String canonicalClassName;
        int argPos;
        if (struct == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(7);
        }
        String plainBaseClassName = (argPos = (canonicalClassName = struct.getType().getCanonicalName(context)).indexOf(60)) >= 0 ? canonicalClassName.substring(0, argPos) : canonicalClassName;
        return Couple.of((Object)canonicalClassName, (Object)plainBaseClassName);
    }

    @Nullable
    private static Couple<String> extractInstantiateTypedTestName(@NotNull OCDeclaratorSymbol inst2test, @NotNull Project project) {
        PsiElement idRegister;
        PsiElement registerCall;
        PsiElement element;
        if (inst2test == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(9);
        }
        if ((element = inst2test.locateDefinition(project)) instanceof OCDeclarator && (registerCall = element.getLastChild()) instanceof OCCallExpression && OCElementUtil.getElementType((PsiElement)(idRegister = PsiTreeUtil.getDeepestLast((PsiElement)registerCall.getFirstChild()))) == OCTokenTypes.IDENTIFIER && REGISTER.equals(idRegister.getText())) {
            List registerCallArgs = ((OCCallExpression)registerCall).getArguments();
            if (registerCallArgs.size() == 3 && registerCallArgs.get(0) instanceof OCLiteralExpression && registerCallArgs.get(1) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)registerCallArgs.get(0)).getUnescapedLiteralText(), (Object)((OCLiteralExpression)registerCallArgs.get(1)).getUnescapedLiteralText());
            }
            if (registerCallArgs.size() >= 4 && registerCallArgs.get(0) instanceof OCLiteralExpression && registerCallArgs.get(3) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)registerCallArgs.get(0)).getUnescapedLiteralText(), (Object)((OCLiteralExpression)registerCallArgs.get(3)).getUnescapedLiteralText());
            }
        }
        return null;
    }

    @Nullable
    private static Couple<String> extractInstantiateTestName(@NotNull OCDeclaratorSymbol regInstantiate, @NotNull Project project) {
        OCExpression addTestCaseInstantiationCallArg0;
        List addTestCaseInstantiationCallArgs;
        PsiElement addTestCaseInstantiationCall;
        PsiElement element;
        if (regInstantiate == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(11);
        }
        if ((element = regInstantiate.locateDefinition(project)) instanceof OCDeclarator && (addTestCaseInstantiationCall = element.getLastChild()) instanceof OCCallExpression && !(addTestCaseInstantiationCallArgs = ((OCCallExpression)addTestCaseInstantiationCall).getArguments()).isEmpty() && (addTestCaseInstantiationCallArg0 = (OCExpression)addTestCaseInstantiationCallArgs.get(0)) instanceof OCLiteralExpression) {
            OCExpression getTestCasePatternHolderCallArg0;
            List getTestCasePatternHolderCallArgs;
            PsiElement getTestCasePatternHolderCall;
            String test = ((OCLiteralExpression)addTestCaseInstantiationCallArg0).getUnescapedLiteralText();
            PsiElement qe = addTestCaseInstantiationCall.getFirstChild();
            if (qe instanceof OCQualifiedExpression && (getTestCasePatternHolderCall = qe.getFirstChild()) instanceof OCCallExpression && !(getTestCasePatternHolderCallArgs = ((OCCallExpression)getTestCasePatternHolderCall).getArguments()).isEmpty() && (getTestCasePatternHolderCallArg0 = (OCExpression)getTestCasePatternHolderCallArgs.get(0)) instanceof OCLiteralExpression) {
                return Couple.of((Object)((OCLiteralExpression)getTestCasePatternHolderCallArg0).getUnescapedLiteralText(), (Object)test);
            }
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractGoogleTestName(@Nullable OCStructSymbol symbol, @NotNull Project project) {
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(12);
        }
        @NotNull List<Object> arguments = Collections.emptyList();
        if (symbol != null) {
            OCDeclarator varDeclarator;
            OCDeclaration declaration;
            String name = symbol.getName();
            if (name.endsWith("_Test") && (declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)symbol.locateDefinition(project), OCDeclaration.class)) != null && (varDeclarator = (OCDeclarator)PsiTreeUtil.getChildOfType((PsiElement)(declaration = (OCDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration, OCDeclaration.class)), OCDeclarator.class)) != null) {
                if (TEST_INFO.equals(varDeclarator.getName())) {
                    arguments = CidrGoogleTestUtil.extractMethodArguments((PsiElement)varDeclarator);
                } else {
                    String varName = "gtest_" + name.substring(0, name.length() - "_Test".length()) + "_registered_";
                    if (varName.equals(varDeclarator.getName())) {
                        List<OCExpression> result = CidrGoogleTestUtil.extractMethodArguments((PsiElement)varDeclarator);
                        if (result.size() >= 5) {
                            arguments = result.subList(2, 4);
                        } else if (result.size() >= 3) {
                            arguments = result.subList(1, 3);
                        }
                    }
                }
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractMethodArguments((OCNamespaceSymbol)symbol, ADD_TO_REGISTRY, project);
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol, project);
            }
        }
        if (arguments.size() >= 2) {
            String className = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(0)));
            String methodName = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(1)));
            return Couple.of((Object)className, (Object)methodName);
        }
        return null;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable PsiElement psiElement) {
        PsiElement parent;
        OCCallExpression expression;
        if (psiElement != null && (expression = (OCCallExpression)PsiTreeUtil.findChildOfType((PsiElement)(parent = psiElement.getParent()), OCCallExpression.class)) != null) {
            List list = expression.getArguments();
            if (list == null) {
                CidrGoogleTestUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<OCExpression> list = Collections.emptyList();
        if (list == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static List<OCExpression> extractTypeParameterizedArguments(@NotNull OCStructSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(16);
        }
        List<OCExpression> arguments = Collections.emptyList();
        if (symbol.getParent() instanceof OCNamespaceSymbol && (arguments = CidrGoogleTestUtil.extractMethodArguments((OCNamespaceSymbol)symbol.getParent(), "gtest_" + symbol.getName() + "_defined_", project)).size() >= 4) {
            arguments = arguments.subList(2, 4);
        }
        return arguments;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCNamespaceSymbol parent, @NotNull String methodName, @NotNull Project project) {
        OCSymbol member;
        if (parent == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(17);
        }
        if (methodName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(19);
        }
        List<OCExpression> list = (member = parent.findMember(methodName)) != null ? CidrGoogleTestUtil.extractMethodArguments(member, project) : Collections.emptyList();
        if (list == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(21);
        }
        if (project == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(22);
        }
        return CidrGoogleTestUtil.extractMethodArguments(symbol.locateDefinition(project));
    }

    @NotNull
    public static String extractArgumentValue(@Nullable PsiElement element) {
        LeafPsiElement leafPsiElement = (LeafPsiElement)PsiTreeUtil.findChildOfType((PsiElement)element, LeafPsiElement.class);
        String string = leafPsiElement == null ? "" : StringUtil.notNullize((String)leafPsiElement.getText());
        if (string == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalAndPlainNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inst2test";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regInstantiate";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestLinks";
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMethodArguments";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractArgumentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestLinks";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 20: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasGTAsBaseClasses";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTraitLike";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalAndPlainNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractInstantiateTypedTestName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractInstantiateTestName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractGoogleTestName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractTypeParameterizedArguments";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractMethodArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

