/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.RunnerType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/coverage/CoverageLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.platform.coverage"})
public final class CoverageLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final StringEventField RUNNER_NAME;
    private static final EventId3<RunnerType, Integer, Integer> START;
    private static final EventId3<String, Long, Integer> REPORT_LOADING;
    private static final EventId2<Long, Long> HTML;
    private static final EventId3<Long, Integer, Integer> REPORT_BUILDING;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("coverage", 3);
        RUNNER_NAME = EventFields.String((String)"runner", (List)CollectionsKt.listOf((Object[])new String[]{"emma", "jacoco", "idea"}));
        START = GROUP.registerEvent("started", (EventField)EventFields.Enum$default((String)"runner", RunnerType.class, null, (int)4, null), (EventField)EventFields.Int((String)"includes"), (EventField)EventFields.Int((String)"excludes"));
        REPORT_LOADING = GROUP.registerEvent("report.loaded", (EventField)RUNNER_NAME, (EventField)EventFields.DurationMs, (EventField)EventFields.Int((String)"loaded_classes"));
        HTML = GROUP.registerEvent("html.generated", (EventField)EventFields.DurationMs, (EventField)EventFields.Long((String)"generation_ms"));
        REPORT_BUILDING = GROUP.registerEvent("report.built", (EventField)EventFields.DurationMs, (EventField)EventFields.Int((String)"annotated_classes"), (EventField)EventFields.Int((String)"loaded_classes"));
    }

    @JvmStatic
    public static final void logStarted(@NotNull CoverageRunner coverageRunner, boolean isSampling, boolean isTrackRepTestEnabled, int includePatterns, int excludePatterns) {
        Companion.logStarted(coverageRunner, isSampling, isTrackRepTestEnabled, includePatterns, excludePatterns);
    }

    @JvmStatic
    public static final void logReportLoading(@Nullable Project project, @NotNull CoverageRunner coverageRunner, long timeMs, int loadedClasses) {
        Companion.logReportLoading(project, coverageRunner, timeMs, loadedClasses);
    }

    @JvmStatic
    public static final void logHTMLReport(@Nullable Project project, long timeMs, long generationTimeMs) {
        Companion.logHTMLReport(project, timeMs, generationTimeMs);
    }

    @JvmStatic
    public static final void logReportBuilding(@Nullable Project project, long timeMs, int annotatedClasses, int loadedClasses) {
        Companion.logReportBuilding(project, timeMs, annotatedClasses, loadedClasses);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J*\u0010\u0017\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0007J*\u0010\u001a\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\nH\u0007J0\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0007J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/coverage/CoverageLogger$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HTML", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "REPORT_BUILDING", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "REPORT_LOADING", "", "RUNNER_NAME", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "START", "Lcom/intellij/coverage/RunnerType;", "logHTMLReport", "", "project", "Lcom/intellij/openapi/project/Project;", "timeMs", "generationTimeMs", "logReportBuilding", "annotatedClasses", "loadedClasses", "logReportLoading", "coverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "logStarted", "isSampling", "", "isTrackRepTestEnabled", "includePatterns", "excludePatterns", "roundClasses", "classes", "intellij.platform.coverage"})
    public static final class Companion {
        @JvmStatic
        public final void logStarted(@NotNull CoverageRunner coverageRunner, boolean isSampling, boolean isTrackRepTestEnabled, int includePatterns, int excludePatterns) {
            RunnerType runnerType;
            Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
            switch (coverageRunner.getId()) {
                case "emma": {
                    runnerType = RunnerType.Emma;
                    break;
                }
                case "jacoco": {
                    runnerType = RunnerType.JaCoCo;
                    break;
                }
                case "idea": {
                    if (isSampling) {
                        runnerType = RunnerType.IJCSampling;
                        break;
                    }
                    if (isTrackRepTestEnabled) {
                        runnerType = RunnerType.IJCTracingTestTracking;
                        break;
                    }
                    runnerType = RunnerType.IJCTracing;
                    break;
                }
                default: {
                    return;
                }
            }
            RunnerType type = runnerType;
            START.log((Object)type, (Object)this.roundClasses(includePatterns), (Object)this.roundClasses(excludePatterns));
        }

        @JvmStatic
        public final void logReportLoading(@Nullable Project project, @NotNull CoverageRunner coverageRunner, long timeMs, int loadedClasses) {
            Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
            REPORT_LOADING.log(project, (Object)coverageRunner.getId(), (Object)timeMs, (Object)this.roundClasses(loadedClasses));
        }

        @JvmStatic
        public final void logHTMLReport(@Nullable Project project, long timeMs, long generationTimeMs) {
            HTML.log(project, (Object)timeMs, (Object)generationTimeMs);
        }

        @JvmStatic
        public final void logReportBuilding(@Nullable Project project, long timeMs, int annotatedClasses, int loadedClasses) {
            REPORT_BUILDING.log(project, (Object)timeMs, (Object)this.roundClasses(annotatedClasses), (Object)this.roundClasses(loadedClasses));
        }

        private final int roundClasses(int classes) {
            return classes == 0 ? 0 : StatisticsUtil.getNextPowerOfTwo((int)classes);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

