/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.stm32cubemx;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CubeMXManager;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.RunStm32CubeMXAction;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.EmbeddedMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CubeMXFileEditor
extends UserDataHolderBase
implements FileEditor,
DumbAware,
CubeMXManager.CubeStatusListener,
DataProvider {
    public static final JBFont FONT = JBUI.Fonts.label((float)16.0f);
    @NotNull
    private final VirtualFile myFile;
    private final JBPanel myPanel;
    private final ActionLink myRunStm32CubeMX;
    private final JBLabel myStatusLabel;
    private final JBLabel mcuLabel;
    private final Project myProject;

    public CubeMXFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CubeMXFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CubeMXFileEditor.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        GridLayoutManager layout = new GridLayoutManager(7, 1);
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(1);
        constraints.setRow(0);
        this.myProject = project;
        this.myPanel = new JBPanel((LayoutManager)layout).withBorder(BorderFactory.createEmptyBorder(80, 0, 0, 0));
        this.myRunStm32CubeMX = CubeMXFileEditor.standardFont(new ActionLink("", e -> RunStm32CubeMXAction.openFile(project, this.myFile)));
        ActionLink openHelp = CubeMXFileEditor.standardFont(new ActionLink("", e -> EmbeddedMessages.openHelp()));
        openHelp.setContextHelpIcon();
        this.myStatusLabel = CubeMXFileEditor.standardFont(new JBLabel(""));
        this.mcuLabel = CubeMXFileEditor.standardFont(new JBLabel(""));
        constraints.setVSizePolicy(4);
        this.myPanel.add((Component)new Spacer(), (Object)constraints);
        this.myPanel.setFocusable(true);
        constraints.setVSizePolicy(0);
        constraints.setRow(constraints.getRow() + 1);
        JBPanel mcuPanel = new JBPanel((LayoutManager)new FlowLayout()).andTransparent();
        mcuPanel.add((Component)this.mcuLabel);
        mcuPanel.add((Component)ContextHelpLabel.createWithLink(null, (String)EmbeddedBundle.message("cube.mx.open.external.editor", new Object[0]), (String)EmbeddedBundle.message("cube.mx.more.information.link", new Object[0]), EmbeddedMessages::openHelp));
        this.myPanel.add((Component)mcuPanel, (Object)constraints);
        constraints.setRow(constraints.getRow() + 1);
        this.myPanel.add((Component)this.myRunStm32CubeMX, (Object)constraints);
        constraints.setRow(constraints.getRow() + 1);
        this.myPanel.add((Component)this.myStatusLabel, (Object)constraints);
        constraints.setRow(constraints.getRow() + 1);
        constraints.setVSizePolicy(4);
        this.myPanel.add((Component)new Spacer(), (Object)constraints);
        constraints.setRow(constraints.getRow() + 1);
        this.myPanel.add((Component)new Spacer(), (Object)constraints);
        this.myPanel.setBackground((Color)JBColor.namedColor((String)"Editor.background", (Color)IdeBackgroundUtil.getIdeBackgroundColor()));
        CubeMXManager cubeMXManager = CubeMXManager.getInstance(project);
        cubeMXManager.notifyPossibleCubeMXChanges();
        project.getMessageBus().connect((Disposable)this).subscribe(CubeMXManager.TOPIC, (Object)this);
        this.cubeMxStatusUpdated(CubeMXManager.getInstance(project));
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
    }

    @NonNls
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CubeMXFileEditor.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        return null;
    }

    private static <T extends Component> T standardFont(T component) {
        component.setFont((Font)FONT);
        return component;
    }

    @NotNull
    public JComponent getComponent() {
        JBPanel jBPanel = this.myPanel;
        if (jBPanel == null) {
            CubeMXFileEditor.$$$reportNull$$$0(3);
        }
        return jBPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRunStm32CubeMX;
    }

    @NotNull
    public String getName() {
        String ioc;
        String string = ioc = "IOC";
        if (string == null) {
            CubeMXFileEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            CubeMXFileEditor.$$$reportNull$$$0(5);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            CubeMXFileEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            CubeMXFileEditor.$$$reportNull$$$0(7);
        }
    }

    public void dispose() {
        DataManager.removeDataProvider((JComponent)this.myPanel);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            CubeMXFileEditor.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @Override
    public void cubeMxStatusUpdated(@NotNull CubeMXManager manager) {
        if (manager == null) {
            CubeMXFileEditor.$$$reportNull$$$0(9);
        }
        CubeMXManager.CubeStatus status = manager.getStatus();
        String mcu = manager.getTargetMCU();
        if (mcu != null) {
            this.mcuLabel.setText(EmbeddedBundle.message("mcu.is.configured", mcu));
        } else {
            this.mcuLabel.setText(EmbeddedBundle.message("no.mcu.configured", new Object[0]));
        }
        switch (status) {
            case OK: {
                this.myStatusLabel.setIcon(null);
                this.myStatusLabel.setText("");
                break;
            }
            case BROKEN: {
                this.myStatusLabel.setIcon(AllIcons.General.BalloonError);
                this.myStatusLabel.setText(EmbeddedBundle.message("cube.mx.invalid.file.content", new Object[0]));
                break;
            }
            case WRONG_TARGET: {
                this.myStatusLabel.setIcon(AllIcons.General.BalloonWarning);
                this.myStatusLabel.setText(EmbeddedBundle.message("cube.mx.wrong.ide", new Object[0]));
                break;
            }
            case REQUIRES_GENERATION: {
                this.myStatusLabel.setIcon(AllIcons.General.BalloonWarning);
                this.myStatusLabel.setText(EmbeddedBundle.message("cube.mx.project.sources.not.generated", new Object[0]));
                break;
            }
            case OUTDATED: {
                this.myStatusLabel.setIcon(AllIcons.General.BalloonWarning);
                this.myStatusLabel.setText(EmbeddedBundle.message("cube.mx.project.sources.outdated", new Object[0]));
                break;
            }
        }
        boolean enabled = !manager.isUtilityRunning();
        this.myRunStm32CubeMX.setEnabled(enabled);
        this.myRunStm32CubeMX.setText(enabled ? EmbeddedBundle.message("cube.mx.editor.open", new Object[0]) : EmbeddedBundle.message("cube.mx.editor.opened", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CubeMXFileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/CubeMXFileEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cubeMxStatusUpdated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

