/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.embedded.stm32cubemx;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.cpp.embedded.EmbeddedBundle;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CubeMXFileType;
import com.jetbrains.cidr.cpp.embedded.stm32cubemx.CubeMXManager;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.EmbeddedSettingsState;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.ui.EmbeddedMessages;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunStm32CubeMXAction
extends AnAction
implements DumbAware {
    private static final Key<OSProcessHandler> IOC_EDITOR_PROCESS = new Key("IOC_EDITOR_PROCESS");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(0);
        }
        VirtualFile file = RunStm32CubeMXAction.getIocFile(e);
        e.getPresentation().setVisible(file != null);
        e.getPresentation().setEnabled(RunStm32CubeMXAction.isEnabledForFile(file));
    }

    public static boolean isEnabledForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        OSProcessHandler handler = (OSProcessHandler)IOC_EDITOR_PROCESS.get((UserDataHolder)file);
        return handler == null || handler.isProcessTerminated();
    }

    @Nullable
    private static VirtualFile getIocFile(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(1);
        }
        if ((file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)CubeMXFileType.INSTANCE)) {
            return file;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(2);
        }
        RunStm32CubeMXAction.openFile(e.getProject(), RunStm32CubeMXAction.getIocFile(e));
    }

    public static void openFile(final @Nullable Project project, final @Nullable VirtualFile file) {
        if (RunStm32CubeMXAction.isEnabledForFile(file)) {
            GeneralCommandLine commandLine = RunStm32CubeMXAction.createCommandLine(file);
            try {
                OSProcessHandler.Silent handler = new OSProcessHandler.Silent(commandLine){

                    protected void onOSProcessTerminated(int exitCode) {
                        super.onOSProcessTerminated(exitCode);
                        if (project != null) {
                            CubeMXManager.getInstance(project).cubeUtilityStatus(false);
                        }
                        IOC_EDITOR_PROCESS.set((UserDataHolder)file, null);
                    }
                };
                if (project != null) {
                    CubeMXManager.getInstance(project).cubeUtilityStatus(true);
                }
                handler.startNotify();
                IOC_EDITOR_PROCESS.set((UserDataHolder)file, (Object)handler);
            }
            catch (Throwable e) {
                EmbeddedMessages.showErrorMessage(project, e.getLocalizedMessage(), EmbeddedBundle.message("stm32cubemx2", new Object[0]));
            }
        }
    }

    @Nullable
    public static GeneralCommandLine createJavaCommandLine(@Nullable VirtualFile file) {
        String javaExec = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        EmbeddedSettingsState state = (EmbeddedSettingsState)ApplicationManager.getApplication().getComponent(EmbeddedSettingsState.class);
        String cubeLocation = state.stm32CubeMXLocation;
        if (!new File(cubeLocation).exists()) {
            EmbeddedMessages.showErrorMessage(null, EmbeddedBundle.message("stm32.cube.mx.project.generation.failure", new Object[0]), EmbeddedBundle.message("stm32.cube.mx.is.not.found", new Object[0]));
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(javaExec).withParameters(new String[]{"-jar", cubeLocation});
        if (file != null) {
            commandLine.withWorkDirectory(RunStm32CubeMXAction.platformSpecificPath(file.getParent()));
            commandLine.withParameters(new String[]{RunStm32CubeMXAction.platformSpecificPath(file)});
        }
        return commandLine;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull VirtualFile file) {
        if (file == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(3);
        }
        EmbeddedSettingsState state = Objects.requireNonNull((EmbeddedSettingsState)ApplicationManager.getApplication().getComponent(EmbeddedSettingsState.class));
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withWorkDirectory(RunStm32CubeMXAction.platformSpecificPath(file.getParent())).withExePath(state.stm32CubeMXLocation).withParameters(new String[]{RunStm32CubeMXAction.platformSpecificPath(file)});
        if (generalCommandLine == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    private static String platformSpecificPath(@NotNull VirtualFile file) {
        if (file == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(5);
        }
        String string = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
        if (string == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/RunStm32CubeMXAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/embedded/stm32cubemx/RunStm32CubeMXAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "platformSpecificPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIocFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "platformSpecificPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

