/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.custom;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.custom.CustomGdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.custom.CustomGdbServerRunConfigurationSettingsEditor;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGdbServerRunConfiguration
extends GdbServerRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction {
    private static final String ATTR_RESET_COMMAND = "reset-cmd";
    private static final String DEFAULT_RESET_COMMAND = "monitor reset";
    private static final String ATTR_RESET_AFTER_DOWNLOAD = "reset-after-download";
    private String myResetCommand = "monitor reset";
    private boolean myResetAfterDownload = true;

    public CustomGdbServerRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new CustomGdbServerRunConfigurationSettingsEditor(this.getProject(), this.getHelper());
    }

    public void readExternal(@NotNull Element parentElement) throws InvalidDataException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        if (element != null) {
            this.myResetCommand = element.getAttributeValue(ATTR_RESET_COMMAND, DEFAULT_RESET_COMMAND);
            this.myResetAfterDownload = !Boolean.FALSE.toString().equals(element.getAttributeValue(ATTR_RESET_AFTER_DOWNLOAD));
        }
    }

    public void writeExternal(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(parentElement);
        Element element = parentElement.getChild("custom-gdb-server");
        assert (element != null);
        element.setAttribute(ATTR_RESET_COMMAND, this.myResetCommand);
        element.setAttribute(ATTR_RESET_AFTER_DOWNLOAD, Boolean.toString(this.myResetAfterDownload));
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(3);
        }
        CustomGdbServerLauncher launcher = new CustomGdbServerLauncher(environment, this, this.getDebuggerData().getOrCreateDebuggerToolchain());
        return new CidrCommandLineState(environment, (CidrLauncher)launcher);
    }

    @NotNull
    public String getResetCommand() {
        String string = this.myResetCommand;
        if (string == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setResetCommand(@NotNull String resetCommand) {
        if (resetCommand == null) {
            CustomGdbServerRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myResetCommand = resetCommand;
    }

    public boolean isResetAfterDownload() {
        return this.myResetAfterDownload;
    }

    public void setResetAfterDownload(boolean resetAfterDownload) {
        this.myResetAfterDownload = resetAfterDownload;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/custom/CustomGdbServerRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setResetCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

