/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.GdbRtosSupport;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.RtosLLThread;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.RtosLLValue;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.RtosOptions;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.RtosSettings;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/GdbRtosSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "getBundledRtosCommands", "Ljava/io/File;", "Companion", "RtosCommands", "intellij.clion.embedded"})
public final class GdbRtosSupport
implements CidrDebugProcessConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final File getBundledRtosCommands() {
        File file = CidrPathManager.getBinPath(CidrDebuggerPathManager.class, (String)"clion-embedded/bin", (String)"rtos", null).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"CidrPathManager.getBinPa\u2026           null).toFile()");
        return file;
    }

    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        RunParameters runParameters = process.getRunParameters();
        Intrinsics.checkNotNullExpressionValue((Object)runParameters, (String)"process.runParameters");
        if (!(runParameters.getDebuggerDriverConfiguration() instanceof GDBDriverConfiguration)) {
            return;
        }
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"process.project");
        RtosOptions state = RtosSettings.Companion.getState(project);
        if (!state.isRtosEnabled()) {
            return;
        }
        process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(this, state){
            final /* synthetic */ GdbRtosSupport this$0;
            final /* synthetic */ RtosOptions $state;

            public final void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                try {
                    String string = FileUtil.toSystemIndependentName((String)GdbRtosSupport.access$getBundledRtosCommands(this.this$0).getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndepen\u2026sCommands().absolutePath)");
                    String rtosPath = string;
                    String script = "import sys; sys.path.insert(0, " + DebuggerDriver.stringify((String)rtosPath) + "); ";
                    script = script + "import common; import freertos ";
                    driver.executeInterpreterCommand(-1L, -1, "python " + script);
                    String string2 = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_init(\"" + (Object)((Object)this.$state.getRtosType()) + "\")");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"driver.executeInterprete\u2026(\\\"${state.rtosType}\\\")\")");
                    String consoleOutput = string2;
                    Map map = (Map)com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.GdbRtosSupport$Companion.access$tryDecodeJsonFromConsoleOutput(GdbRtosSupport.Companion, consoleOutput, BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)));
                    if (map == null) {
                        return;
                    }
                    Map answer = map;
                    CharSequence charSequence = (CharSequence)answer.get("name");
                    boolean bl = false;
                    boolean bl2 = false;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)new RtosCommands());
                    }
                }
                catch (ExecutionException e) {
                    CidrDebuggerLog.LOG.info("RTOS integration state: " + (Object)((Object)this.$state.getRtosType()) + ", RTOS has not been found");
                }
            }
            {
                this.this$0 = gdbRtosSupport;
                this.$state = rtosOptions;
            }
        });
    }

    public static final /* synthetic */ File access$getBundledRtosCommands(GdbRtosSupport $this) {
        return $this.getBundledRtosCommands();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J1\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#H\u0002\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/GdbRtosSupport$RtosCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "()V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "getData", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "value", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "getFrames", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "from", "", "count", "untilFirstLineWithCode", "", "getThreads", "", "Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/RtosLLThread;", "getVariableChildren", "getVariables", "Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/RtosLLValue;", "frame", "switchTaskContextAndExecute", "T", "task", "callable", "Lkotlin/Function0;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/RtosLLThread;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.clion.embedded"})
    private static final class RtosCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBTuple stopTuple) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)stopTuple, (String)"stopTuple");
            CompletionStage completionStage = bridge.executeAsyncCommand(new GDBDriver.Command(stopTuple, bridge){
                final /* synthetic */ GDBTuple $stopTuple;
                final /* synthetic */ GDBDriver.Bridge $bridge;

                @Nullable
                public final DebuggerDriver.StopPlace call() {
                    GDBTuple gDBTuple = this.$stopTuple.getRequiredTupleOrThrow("frame", new Supplier(this){
                        final /* synthetic */ doReadStopPlaceAsync.1 this$0;

                        @NotNull
                        public final ExecutionException get() {
                            return new ExecutionException(GDBBundle.message((String)"error.cannot.read.stop.place", (Object[])new Object[]{this.this$0.$stopTuple}));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)gDBTuple, (String)"stopTuple.getRequiredTup\u2026\", stopTuple))\n        })");
                    GDBTuple frameTuple2 = gDBTuple;
                    LLFrame lLFrame = this.$bridge.doReadFrame(0, frameTuple2);
                    Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"bridge.doReadFrame(0, frameTuple)");
                    LLFrame frame = lLFrame;
                    this.$bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
                    String string = this.$bridge.sendSilentRequestAndGetOutput("p/r $rtos_curr()", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bridge.sendSilentRequest\u2026tput(\"p/r \\$rtos_curr()\")");
                    String consoleOutput = string;
                    Map map = (Map)com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.GdbRtosSupport$Companion.access$tryDecodeJsonFromConsoleOutput(GdbRtosSupport.Companion, consoleOutput, BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)));
                    if (map == null) {
                        throw (Throwable)new ExecutionException(GDBBundle.message((String)"error.cannot.read.stop.place", (Object[])new Object[]{this.$stopTuple}));
                    }
                    Map task = map;
                    long threadId = this.$bridge.doEvaluateAndLoad(-1L, -1, "$_gthread", null).intValue();
                    Object object = (String)task.get("t_id");
                    long l = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L;
                    String string2 = (String)task.get("t_name");
                    if (string2 == null) {
                        string2 = "<>";
                    }
                    RtosLLThread thread = new RtosLLThread(threadId, l, "STOPPED", string2, (String)task.get("s_top_addr"), frame.getProgramCounter());
                    return new DebuggerDriver.StopPlace((LLThread)thread, frame);
                }
                {
                    this.$stopTuple = gDBTuple;
                    this.$bridge = bridge;
                }
            }).handle((BiFunction)doReadStopPlaceAsync.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"bridge.executeAsyncComma\u2026}\n        result\n      })");
            return completionStage;
        }

        @NotNull
        public List<RtosLLThread> getThreads(@NotNull GDBDriver.Bridge bridge) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.SuspendedCommand(bridge){
                final /* synthetic */ GDBDriver.Bridge $bridge;

                @Nullable
                public final List<RtosLLThread> call() {
                    this.$bridge.sendSilentRequestAndGetOutput("set print elements 0", new Object[0]);
                    boolean bl = false;
                    Set result = new LinkedHashSet<E>();
                    long threadId = this.$bridge.doEvaluateAndLoad(-1L, -1, "$_gthread", null).intValue();
                    this.$bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
                    String string = this.$bridge.sendSilentRequestAndGetOutput("p/r $rtos_tasks()", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bridge.sendSilentRequest\u2026put(\"p/r \\$rtos_tasks()\")");
                    String consoleOutput = string;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "set print elements %s";
                    Object[] objectArray = new Object[]{250};
                    boolean bl2 = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    this.$bridge.sendSilentRequestAndGetOutput(string3, new Object[0]);
                    List list = (List)com.jetbrains.cidr.cpp.execution.debugger.embedded.rtos.GdbRtosSupport$Companion.access$tryDecodeJsonFromConsoleOutput(GdbRtosSupport.Companion, consoleOutput, BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE))));
                    if (list == null) {
                        boolean bl3 = false;
                        return new ArrayList<E>();
                    }
                    List tasks = list;
                    Iterable $this$forEach$iv = tasks;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Map task = (Map)element$iv;
                        boolean bl4 = false;
                        Map map = task;
                        Object object = "t_id";
                        boolean bl5 = false;
                        Map map2 = map;
                        boolean bl6 = false;
                        if (!map2.containsKey(object)) continue;
                        map = task;
                        object = "t_pc";
                        bl5 = false;
                        map2 = map;
                        bl6 = false;
                        if (!map2.containsKey(object)) continue;
                        map = task;
                        object = "t_name";
                        bl5 = false;
                        map2 = map;
                        bl6 = false;
                        if (!map2.containsKey(object)) continue;
                        map = task;
                        object = "s_top_addr";
                        bl5 = false;
                        map2 = map;
                        bl6 = false;
                        if (!map2.containsKey(object)) continue;
                        Address addr = Address.NULL;
                        try {
                            V v = task.get("t_pc");
                            Intrinsics.checkNotNull(v);
                            Address address = DebuggerDriver.parseAddress((String)((String)v));
                            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"DebuggerDriver.parseAddress(task[\"t_pc\"]!!)");
                            addr = address;
                        }
                        catch (ExecutionException e) {
                            CidrDebuggerLog.LOG.warn(e.getMessage());
                        }
                        object = result;
                        V v = task.get("t_id");
                        Intrinsics.checkNotNull(v);
                        Long l = StringsKt.toLongOrNull((String)((String)v));
                        long l2 = l != null ? l : -1L;
                        String string4 = (String)task.get("t_state");
                        V v2 = task.get("t_name");
                        Intrinsics.checkNotNull(v2);
                        RtosLLThread rtosLLThread = new RtosLLThread(threadId, l2, string4, (String)v2, (String)task.get("s_top_addr"), addr);
                        boolean bl7 = false;
                        object.add(rtosLLThread);
                    }
                    return CollectionsKt.toMutableList((Collection)result);
                }
                {
                    this.$bridge = bridge;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bridge.executeCommand(GD\u2026.toMutableList()\n      })");
            return (List)object;
        }

        private final <T> T switchTaskContextAndExecute(GDBDriver.Bridge bridge, RtosLLThread task, Function0<? extends T> callable) {
            DebuggerDriver.StopPlace stopPlace = bridge.getStopPlace();
            if (Intrinsics.areEqual((Object)(stopPlace != null && (stopPlace = stopPlace.frame) != null ? stopPlace.getProgramCounter() : null), (Object)task.getProgramCounter())) {
                return (T)callable.invoke();
            }
            bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
            bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_thread(" + task.getStackTopAddress() + ')', new Object[0]);
            Object result = callable.invoke();
            bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_back()", new Object[0]);
            return (T)result;
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand(new GDBDriver.Command(this, bridge, thread, from, count, untilFirstLineWithCode){
                    final /* synthetic */ RtosCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLThread $thread;
                    final /* synthetic */ int $from;
                    final /* synthetic */ int $count;
                    final /* synthetic */ boolean $untilFirstLineWithCode;

                    @Nullable
                    public final DebuggerDriver.ResultList<LLFrame> call() {
                        return (DebuggerDriver.ResultList)RtosCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, (RtosLLThread)this.$thread, (Function0)new Function0<DebuggerDriver.ResultList<LLFrame>>(this){
                            final /* synthetic */ getFrames.1 this$0;

                            @NotNull
                            public final DebuggerDriver.ResultList<LLFrame> invoke() {
                                return this.this$0.$bridge.doGetFrames(1L, this.this$0.$from, this.this$0.$count, this.this$0.$untilFirstLineWithCode);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = rtosCommands;
                        this.$bridge = bridge;
                        this.$thread = lLThread;
                        this.$from = n;
                        this.$count = n2;
                        this.$untilFirstLineWithCode = bl;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bridge.executeCommand {\n\u2026de)\n          }\n        }");
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = DebuggerDriver.ResultList.empty();
                resultList = resultList2;
                Intrinsics.checkNotNullExpressionValue((Object)resultList2, (String)"DebuggerDriver.ResultList.empty()");
            }
            return resultList;
        }

        @NotNull
        public List<RtosLLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            List list;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.SuspendedCommand(this, bridge, thread, frame){
                    final /* synthetic */ RtosCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLThread $thread;
                    final /* synthetic */ LLFrame $frame;

                    @Nullable
                    public final List<RtosLLValue> call() {
                        return (List)RtosCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, (RtosLLThread)this.$thread, (Function0)new Function0<List<RtosLLValue>>(this){
                            final /* synthetic */ getVariables.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final List<RtosLLValue> invoke() {
                                void $this$mapTo$iv$iv;
                                List list = this.this$0.$bridge.doGetFrameVariables(((RtosLLThread)this.this$0.$thread).getGdbThreadId(), this.this$0.$frame.getIndex());
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"bridge.doGetFrameVariabl\u2026gdbThreadId, frame.index)");
                                Iterable $this$map$iv = list;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    LLValue lLValue = (LLValue)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    RtosLLThread rtosLLThread = (RtosLLThread)this.this$0.$thread;
                                    int n = this.this$0.$frame.getIndex();
                                    void v3 = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                                    RtosLLValue rtosLLValue = new RtosLLValue(rtosLLThread, n, (LLValue)v3);
                                    collection.add(rtosLLValue);
                                }
                                return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = rtosCommands;
                        this.$bridge = bridge;
                        this.$thread = lLThread;
                        this.$frame = lLFrame;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bridge.executeCommand(GD\u2026()\n          }\n        })");
                list = (List)object;
            } else {
                boolean bl = false;
                list = new ArrayList();
            }
            return list;
        }

        @NotNull
        public LLValueData getData(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value) {
            LLValueData lLValueData;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.SuspendedCommand(this, bridge, value){
                    final /* synthetic */ RtosCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLValue $value;

                    @Nullable
                    public final LLValueData call() {
                        return (LLValueData)RtosCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, ((RtosLLValue)this.$value).getMyRtosLLThread(), (Function0)new Function0<LLValueData>(this){
                            final /* synthetic */ getData.1 this$0;

                            @NotNull
                            public final LLValueData invoke() {
                                return this.this$0.$bridge.doLoadVariableData(this.this$0.$value);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = rtosCommands;
                        this.$bridge = bridge;
                        this.$value = lLValue;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bridge.executeCommand(GD\u2026e)\n          }\n        })");
                lLValueData = (LLValueData)object;
            } else {
                LLValueData lLValueData2 = bridge.doLoadVariableData(value);
                lLValueData = lLValueData2;
                Intrinsics.checkNotNullExpressionValue((Object)lLValueData2, (String)"bridge.doLoadVariableData(value)");
            }
            return lLValueData;
        }

        @NotNull
        public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value, int from, int count) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.SuspendedCommand(this, bridge, value, from, count){
                    final /* synthetic */ RtosCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLValue $value;
                    final /* synthetic */ int $from;
                    final /* synthetic */ int $count;

                    @Nullable
                    public final DebuggerDriver.ResultList<LLValue> call() {
                        return (DebuggerDriver.ResultList)RtosCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, ((RtosLLValue)this.$value).getMyRtosLLThread(), (Function0)new Function0<DebuggerDriver.ResultList<LLValue>>(this){
                            final /* synthetic */ getVariableChildren.1 this$0;

                            @NotNull
                            public final DebuggerDriver.ResultList<LLValue> invoke() {
                                return this.this$0.$bridge.doGetVariableChildren(this.this$0.$value, this.this$0.$from, this.this$0.$count);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = rtosCommands;
                        this.$bridge = bridge;
                        this.$value = lLValue;
                        this.$from = n;
                        this.$count = n2;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bridge.executeCommand(GD\u2026t)\n          }\n        })");
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = bridge.doGetVariableChildren(value, from, count);
                resultList = resultList2;
                Intrinsics.checkNotNullExpressionValue((Object)resultList2, (String)"bridge.doGetVariableChildren(value, from, count)");
            }
            return resultList;
        }

        public static final /* synthetic */ Object access$switchTaskContextAndExecute(RtosCommands $this, GDBDriver.Bridge bridge, RtosLLThread task, Function0 callable) {
            return $this.switchTaskContextAndExecute(bridge, task, callable);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J+\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/execution/debugger/embedded/rtos/GdbRtosSupport$Companion;", "", "()V", "extractQuotedString", "", "raw", "tryDecodeJsonFromConsoleOutput", "T", "s", "serializer", "Lkotlinx/serialization/KSerializer;", "(Ljava/lang/String;Lkotlinx/serialization/KSerializer;)Ljava/lang/Object;", "intellij.clion.embedded"})
    public static final class Companion {
        private final <T> T tryDecodeJsonFromConsoleOutput(String s, KSerializer<T> serializer) {
            Object object;
            try {
                String extractedQuote = this.extractQuotedString(s);
                object = Json.Default.decodeFromString((DeserializationStrategy)serializer, extractedQuote);
            }
            catch (IllegalArgumentException e) {
                CidrDebuggerLog.LOG.info(e.getMessage());
                object = null;
            }
            return (T)object;
        }

        @NotNull
        public final String extractQuotedString(@NotNull String raw) {
            String string;
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            CharSequence charSequence = raw;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                int left = StringsKt.indexOf$default((CharSequence)raw, (String)"\"", (int)0, (boolean)false, (int)6, null) + 1;
                int right = StringsKt.lastIndexOf$default((CharSequence)raw, (String)"\"", (int)0, (boolean)false, (int)6, null);
                int n = left;
                if (0 > n || ((CharSequence)raw).length() <= n || 0 > (n = right) || ((CharSequence)raw).length() <= n || left >= right) {
                    throw (Throwable)new IllegalArgumentException("Input string doesn't contain enough quotes");
                }
                String string2 = raw;
                boolean bl2 = false;
                String string3 = string2.substring(left, right);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String threadsEscaped = string3;
                string = DebuggerDriver.unescapeString((String)threadsEscaped);
            } else {
                throw (Throwable)new IllegalArgumentException("Empty string passed");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (left in raw.indices \u2026enough quotes\")\n        }");
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ Object access$tryDecodeJsonFromConsoleOutput(Companion $this, String s, KSerializer serializer) {
            return $this.tryDecodeJsonFromConsoleOutput(s, serializer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

