/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.embedded.svd;

import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.Format;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdNodeBase;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.embedded.svd.SvdValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdField
extends SvdValue<SvdNodeBase<?>> {
    private static final Format DEFAULT_FORMAT = Format.BIN;
    private final int myBitOffset;
    private final SvdRegister myParent;
    private long value;

    public SvdField(@NotNull SvdRegister parent, @NotNull String name, @NotNull String description, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction, int bitOffset, int size) {
        if (parent == null) {
            SvdField.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SvdField.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdField.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdField.$$$reportNull$$$0(3);
        }
        super(parent.getId() + "|" + name, name, description, access, readAction, size, DEFAULT_FORMAT);
        this.value = 0L;
        this.myBitOffset = bitOffset;
        this.myParent = parent;
    }

    public int getBitOffset() {
        return this.myBitOffset;
    }

    public void updateFromValue(long registerValue) {
        long newValue = registerValue >> this.myBitOffset;
        this.changed = this.value != (newValue &= -1L << this.getBitSize() ^ 0xFFFFFFFFFFFFFFFFL);
        this.value = newValue;
    }

    @Override
    @NotNull
    public String getDisplayValue() {
        if (this.getAccess().isReadable() && !this.myParent.isFailed()) {
            String string = this.getFormat().format(this.value, this.getBitSize());
            if (string == null) {
                SvdField.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "-";
    }

    @Override
    @NotNull
    public Format getDefaultFormat() {
        Format format = DEFAULT_FORMAT;
        if (format == null) {
            SvdField.$$$reportNull$$$0(5);
        }
        return format;
    }

    public void markStalled() {
        this.changed = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/embedded/svd/SvdField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

