/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ObfuscatorImpl;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ClangdBridgeImpl
implements ClangdBridgeInterface {
    public boolean isClangdOnlyMode() {
        return false;
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        if (registrar == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(0);
        }
        new ClangErrorsAnnotatorSlowPassFactory(registrar, clangErrorsPassId);
        new OurClangTidyInspectionsViaClangdAnnotatorPassFactory(registrar, reparsingPassId);
    }

    @NotNull
    public ImmutableList<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(1);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        ImmutableList immutableList = ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
        if (immutableList == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    public boolean isSupported(@NotNull VirtualFile vf) {
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(3);
        }
        return (vf instanceof VirtualFileWithId || vf instanceof OCFragmentVirtualFile) && OCLanguageUtils.isSupported((VirtualFile)vf);
    }

    public boolean getParameterHints(@NotNull Project project) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(4);
        }
        return HintUtilsKt.isParameterHintsEnabledForLanguage((Language)OCLanguageUtils.getConfigLanguage());
    }

    public void setParameterHints(@NotNull Project project, boolean enabled) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(5);
        }
        HintUtilsKt.setShowParameterHintsForLanguage((boolean)enabled, (Language)OCLanguageUtils.getConfigLanguage());
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection() {
        return ClazyInspection.class;
    }

    @NotNull
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        return OCUnusedIncludeDirectiveInspection.class;
    }

    public boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(6);
        }
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(7);
        }
        return OCSearchScope.isInProjectSourcesOrLibraries((Project)project, (VirtualFile)vf);
    }

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String warningName) {
        if (file == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(8);
        }
        if (range == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(9);
        }
        if (warningName == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(10);
        }
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", warningName);
        OCFile ocFile = OCLanguageUtils.asOCFile((PsiFile)file);
        if (ocFile == null) {
            List<SuppressIntentionAction> list = Collections.emptyList();
            if (list == null) {
                ClangdBridgeImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<SuppressIntentionAction> list = Arrays.asList(new OCSuppressClangForFile(ocFile, range, suppressionGroup), new OCSuppressClangForCallable((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForStatement((PsiFile)ocFile, range, suppressionGroup));
        if (list == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, boolean forIndexer) {
        if (descriptor == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(13);
        }
        return forIndexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new AdvancedClangIdeFacadeImpl(descriptor);
    }

    @NotNull
    public Obfuscator createObfuscator() {
        return new ObfuscatorImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotatorPassFactories";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setParameterHints";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createClangIdeFacade";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

