/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import java.util.Locale;

public enum ClangPostfixTemplateFlags {
    None(0L),
    FreeFunction(1L),
    If(2L),
    For(4L),
    Switch(8L),
    Do(16L),
    While(32L),
    Return(64L),
    ReinterpretCast(128L),
    StaticCast(256L),
    DynamicCast(512L),
    ConstCast(1024L),
    Begin(2048L),
    CBegin(4096L),
    RBegin(8192L),
    CRBegin(16384L),
    Forward(32768L),
    Ref(65536L),
    CRef(131072L),
    Move(262144L),
    New(524288L),
    MakeShared(0x100000L),
    MakeUnique(0x200000L),
    Else(0x400000L),
    Not(0x800000L),
    Fori(0x1000000L),
    Formut(0x2000000L),
    CoReturn(0x4000000L),
    CoYield(0x8000000L),
    CoAwait(0x10000000L),
    AlgorithmFunction(0x20000000L);

    private final long value;

    private ClangPostfixTemplateFlags(long value) {
        this.value = value;
    }

    public static ClangPostfixTemplateFlags fromString(String str) {
        switch (str.toLowerCase(Locale.ROOT)) {
            case "freefunction": {
                return FreeFunction;
            }
            case "if": {
                return If;
            }
            case "for": {
                return For;
            }
            case "switch": {
                return Switch;
            }
            case "do": {
                return Do;
            }
            case "while": {
                return While;
            }
            case "return": {
                return Return;
            }
            case "reinterpret_cast": {
                return ReinterpretCast;
            }
            case "static_cast": {
                return StaticCast;
            }
            case "dynamic_cast": {
                return DynamicCast;
            }
            case "const_cast": {
                return ConstCast;
            }
            case "begin..end": {
                return Begin;
            }
            case "cbegin..cend": {
                return CBegin;
            }
            case "rbegin..rend": {
                return RBegin;
            }
            case "crbegin..crend": {
                return CRBegin;
            }
            case "forward": {
                return Forward;
            }
            case "ref": {
                return Ref;
            }
            case "cref": {
                return CRef;
            }
            case "move": {
                return Move;
            }
            case "new": {
                return New;
            }
            case "make_shared": {
                return MakeShared;
            }
            case "make_unique": {
                return MakeUnique;
            }
            case "else": {
                return Else;
            }
            case "not": {
                return Not;
            }
            case "fori": {
                return Fori;
            }
            case "formut": {
                return Formut;
            }
            case "co_return": {
                return CoReturn;
            }
            case "co_await": {
                return CoAwait;
            }
            case "co_yield": {
                return CoYield;
            }
            case "algorithmfunction": {
                return AlgorithmFunction;
            }
        }
        return None;
    }

    public long getValue() {
        return this.value;
    }
}

