/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangLineMarkerInfo;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangLineMarkerProvider
implements LineMarkerProvider {
    private static final boolean ourLineMarkersEnabled = Registry.is((String)"clion.clang.clangd.index.on");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!ourLineMarkersEnabled) {
            return null;
        }
        return ClangLineMarkerProvider.getClionMarkerFor(element, true);
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (!ourLineMarkersEnabled) {
            return;
        }
        for (PsiElement psiElement : elements) {
            ClangLineMarkerInfo marker = ClangLineMarkerProvider.getClionMarkerFor(psiElement, false);
            if (marker == null) continue;
            result2.add(marker);
        }
    }

    @Nullable
    private static ClangLineMarkerInfo getClionMarkerFor(@NotNull PsiElement element, boolean fastMarker) {
        List<ClionLineMarker> allMarkers;
        ClionLineMarker marker;
        Document document;
        if (element == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (OCElementUtil.isPartOfMacroSubstitution((PsiElement)element)) {
            return null;
        }
        PsiNameIdentifierOwner owner = OCLineMarkerProvider.getElementFromNameIdentifier((PsiElement)element);
        if (owner == null) {
            return null;
        }
        PsiElement nameIdentifier = owner.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        if (owner instanceof OCDeclarator && owner.getParent() instanceof OCFunctionDeclaration) {
            owner = owner.getParent();
        }
        if ((document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile())) == null) {
            return null;
        }
        TextRange range = null;
        List<SymbolKind> kinds = null;
        if (owner instanceof OCFunctionDefinition) {
            OCBlockStatement body = ((OCFunctionDefinition)owner).getBody();
            range = body != null ? new TextRange(owner.getTextRange().getStartOffset(), body.getTextRange().getStartOffset()) : owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Function, SymbolKind.Method, SymbolKind.Constructor);
        } else if (owner instanceof OCFunctionDeclaration) {
            range = owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Function, SymbolKind.Method, SymbolKind.Constructor);
        } else if (owner instanceof OCStruct) {
            range = owner.getTextRange();
            kinds = Arrays.asList(SymbolKind.Class, SymbolKind.Struct);
        }
        if (range != null && (marker = ClangLineMarkerProvider.findBestMarker(document, range, allMarkers = ClangLineMarkerProvider.getAllClionMarkers(owner.getProject(), owner.getContainingFile().getVirtualFile(), document, fastMarker), kinds)) != null) {
            return new ClangLineMarkerInfo(nameIdentifier, marker);
        }
        return null;
    }

    @Nullable
    private static List<ClionLineMarker> getAllClionMarkers(@NotNull Project project, @NotNull VirtualFile vf, @NotNull Document doc, boolean fastMarkers) {
        if (project == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (vf == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (doc == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(6);
        }
        boolean startOffset = false;
        int endOffset = doc.getImmutableCharSequence().length();
        Ref markers = Ref.create();
        ClangResultConsumer resultConsumer = result2 -> {
            try {
                markers.set((Object)((List)result2.waitForResult()));
            }
            catch (ExecutionException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
        };
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart((Project)project);
        if (fastMarkers) {
            service.getFastLineMarkers(vf, 0, endOffset, resultConsumer);
        } else {
            service.getSlowLineMarkers(vf, 0, endOffset, resultConsumer);
        }
        return (List)markers.get();
    }

    @Nullable
    private static ClionLineMarker findBestMarker(@NotNull Document document, @NotNull TextRange range, @Nullable List<ClionLineMarker> markers, @NotNull List<SymbolKind> kinds) {
        if (document == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (range == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (kinds == null) {
            ClangLineMarkerProvider.$$$reportNull$$$0(9);
        }
        if (markers == null) {
            return null;
        }
        EnumSet<SymbolKind> kindSet = EnumSet.copyOf(kinds);
        Range structRange = ClangLanguageServiceUtils.offsets2Range((Document)document, (int)range.getStartOffset(), (int)range.getEndOffset());
        Position startPos = structRange.getStart();
        for (ClionLineMarker marker : markers) {
            if (!kindSet.contains(marker.getSource().getKind()) || marker.getTargets().isEmpty()) continue;
            Position markerStartPos = marker.getSource().getLocation().getRange().getStart();
            if (startPos.getLine() != markerStartPos.getLine()) continue;
            return marker;
        }
        return null;
    }

    @Nullable
    private static PsiElement getNameElementForMarker(@Nullable PsiElement element) {
        PsiElement name = OCLineMarkerProvider.getIdElement((PsiElement)element);
        if (name != null) {
            PsiElement nameFromMacro = ClangLineMarkerProvider.getNameElementForMacroRange(OCElementUtil.getRangeInMacroCall((PsiElement)name));
            return nameFromMacro != null ? nameFromMacro : name;
        }
        return element;
    }

    @Nullable
    private static PsiElement getNameElementForMacroRange(@Nullable OCMacroRange range) {
        if (range == null) {
            return null;
        }
        OCReferenceElement ref = range.getMacroCall().getMacroReferenceElement();
        if (ref == null) {
            return null;
        }
        return ref.getNameIdentifier();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/navigation/ClangLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getClionMarkerFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllClionMarkers";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findBestMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

