/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.MisraProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyAnnotationApplier {
    public void applyFail(@NotNull PsiFile file, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(0);
        }
        if (reason == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(2);
        }
        String message = OCInspectionsBundle.message((String)"inspection.clangTidy.failed", (Object[])new Object[]{reason});
        holder.newAnnotation(severity, message).range((PsiElement)file).fileLevel().withFix((IntentionAction)new OpenClangTidySettingsAction()).create();
    }

    private static void applySuccess(@NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics2, boolean isBatchMode, @NotNull DiagnosticProcessor diagnosticProcessor) {
        OCFile ocFile;
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(3);
        }
        if (diagnostics2 == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(4);
        }
        if (diagnosticProcessor == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(5);
        }
        if ((ocFile = OCLanguageUtils.asOCFile((PsiFile)file)) == null) {
            return;
        }
        for (ClangTidyDiagnostic diagnostic : diagnostics2) {
            OCPragma.Mode mode;
            ProgressManager.checkCanceled();
            ClangTidyInspectionBase sourceInspection = ClangTidyUtil.findInspectionFromClangTidyDiagnostic(diagnostic, file, file.getProject());
            if (sourceInspection == null) continue;
            boolean isMisraInspection = sourceInspection instanceof MisraInspection;
            PsiElement elementToAnnotate = ClangTidyAnnotationApplier.getElementToAnnotate(file, diagnostic.getFileOffset(), isMisraInspection);
            if (elementToAnnotate == null) continue;
            TextRange rangeToHighlight = ClangTidyAnnotationApplier.getRangeToHighlight(elementToAnnotate, isMisraInspection, diagnostic.getRanges());
            String diagnosticMessage = sourceInspection.getMessage(diagnostic.getMessage(), isBatchMode);
            String quickFixMessage = sourceInspection.getQuickFixMessage() != null ? sourceInspection.getQuickFixMessage() : diagnosticMessage;
            List replacements = diagnostic.getReplacements();
            ClionFixItHint clionFix = diagnostic.getClionFix();
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(((Object)((Object)sourceInspection)).getClass(), (PsiElement)file, (HighlightSeverity)HighlightSeverity.WARNING);
            if (highlightSeverity == null || (mode = OCPragmaSuppressionUtils.getDiagnosticMode((OCFile)ocFile, (int)rangeToHighlight.getStartOffset(), (String)sourceInspection.getSuppressName(diagnosticName))) == OCPragma.Mode.IGNORE) continue;
            List<IntentionAction> fixesToRegister = clionFix != null ? ClangQuickFixFactoryKt.getClangQuickFixes(clionFix, OCResolveContext.forPsi((PsiElement)file), (PsiElement)file) : Collections.singletonList(replacements.isEmpty() ? new EmptyIntentionAction(sourceInspection.getDisplayName()) : new ClangTidyIntentionAction(quickFixMessage, diagnosticName, replacements));
            for (IntentionAction fix : fixesToRegister) {
                if (!diagnosticProcessor.processDiagnostic(diagnosticMessage, diagnosticName, rangeToHighlight, highlightSeverity, sourceInspection, ocFile, fix)) break;
            }
        }
    }

    public void applySuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(6);
        }
        if (diagnostics2 == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(8);
        }
        ClangTidyAnnotationApplier.applySuccess(file, diagnostics2, holder.isBatchMode(), new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (ocFile == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    1.$$$reportNull$$$0(6);
                }
                AnnotationBuilder builder = holder.newAnnotation(highlightSeverity, diagnosticMessage).range(rangeToHighlight).withFix((IntentionAction)new IntentionWrapper(fixToRegister, file)).problemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                if (sourceInspection.getForcedHighlightType() != null) {
                    builder = builder.highlightType(sourceInspection.getForcedHighlightType());
                }
                builder.create();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ocFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier$1";
                objectArray[2] = "processDiagnostic";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void applySuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull ProblemsHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(9);
        }
        if (diagnostics2 == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(11);
        }
        ClangTidyAnnotationApplier.applySuccess(file, diagnostics2, !holder.isOnTheFly(), new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (ocFile == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    2.$$$reportNull$$$0(6);
                }
                PsiElement startElement = file.findElementAt(rangeToHighlight.getStartOffset());
                PsiElement endElement = file.findElementAt(rangeToHighlight.getEndOffset() - 1);
                if (startElement == null || endElement == null) {
                    return false;
                }
                IntentionWrapper localQuickFix = new IntentionWrapper(fixToRegister, file);
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)file.getProject()).createProblemDescriptor(startElement, endElement, diagnosticMessage, sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType(), holder.isOnTheFly(), new LocalQuickFix[]{localQuickFix});
                problemDescriptor.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                holder.registerProblem(problemDescriptor);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ocFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier$2";
                objectArray[2] = "processDiagnostic";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void applySuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics2, final @NotNull HighlightInfoHolder holder, boolean isBatch) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(12);
        }
        if (diagnostics2 == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(14);
        }
        ClangTidyAnnotationApplier.applySuccess(file, diagnostics2, isBatch, new DiagnosticProcessor(){

            @Override
            public boolean processDiagnostic(@NotNull @NlsContexts.DetailedDescription String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull OCFile ocFile, @NotNull IntentionAction fixToRegister) {
                if (diagnosticMessage == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (diagnosticName == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (rangeToHighlight == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (highlightSeverity == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (sourceInspection == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (ocFile == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (fixToRegister == null) {
                    3.$$$reportNull$$$0(6);
                }
                ProblemHighlightType problemHighlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)problemHighlightType, (HighlightSeverity)highlightSeverity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(rangeToHighlight).descriptionAndTooltip(diagnosticMessage).severity(highlightSeverity).problemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection)).create();
                holder.add(info);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fixToRegister);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticMessage";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "diagnosticName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rangeToHighlight";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "highlightSeverity";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceInspection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ocFile";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixToRegister";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier$3";
                objectArray[2] = "processDiagnostic";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static SuppressableProblemGroup createProblemGroup(@NotNull OCFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        boolean canSuppressByInlineComment;
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(15);
        }
        if (highlightRange == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(16);
        }
        if (checkName == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(17);
        }
        if (inspection == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(18);
        }
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file.getVirtualFile(), file.getProject());
        boolean bl = canSuppressByInlineComment = !(inspection instanceof OurClangTidyInspection);
        if (ClangTidyInspectionBase.isMisraInspection(checkName)) {
            return new MisraProblemGroup(file, highlightRange, checkName, canDisable, inspection.getShortName());
        }
        if (checkName.startsWith("-Wclazy")) {
            return new ClazyProblemGroup(checkName, canDisable, inspection.getShortName());
        }
        return new ClangTidyProblemGroup(file, highlightRange, checkName, canDisable, canSuppressByInlineComment, inspection.getShortName());
    }

    @Nullable
    public static PsiElement getElementToAnnotate(@NotNull PsiFile file, int offset, boolean useExactRange) {
        PsiElement element;
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(19);
        }
        PsiElement psiElement = element = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild();
        if (element instanceof PsiComment || useExactRange) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant((PsiElement)element)) {
            element = OCElementUtil.getPrevSignificantSibling((PsiElement)element);
        }
        if (element == null) {
            return null;
        }
        if (ClangTidyAnnotationApplier.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class});
        assert (!(context instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context != null ? context : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(20);
        }
        if (elementType == OCTokenTypes.LBRACE || elementType == OCTokenTypes.RBRACE || elementType == OCTokenTypes.COMMA) {
            return true;
        }
        if (!OCTokenTypes.KEYWORDS.contains(elementType) || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.EXTERN_KEYWORD, OCTokenTypes.REGISTER_KEYWORD, OCTokenTypes.STATIC_KEYWORD, OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        List declarators;
        PsiElement identifier;
        if (element == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(21);
        }
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                TextRange textRange = keywordElement.get().getTextRange();
                if (textRange == null) {
                    ClangTidyAnnotationApplier.$$$reportNull$$$0(22);
                }
                return textRange;
            }
        }
        if (element instanceof OCStructLike && (identifier = ((OCStructLike)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplier.$$$reportNull$$$0(23);
            }
            return textRange;
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && ((OCDeclarator)declarators.get(0)).getName() != "<unnamed>") {
            element = (PsiElement)declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplier.$$$reportNull$$$0(24);
            }
            return textRange;
        }
        if (element instanceof LeafPsiElement && element.getText().equals("typename") && element.getParent() instanceof OCTypeElement) {
            TextRange textRange = element.getParent().getTextRange();
            if (textRange == null) {
                ClangTidyAnnotationApplier.$$$reportNull$$$0(25);
            }
            return textRange;
        }
        TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)element);
        if (textRange == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(26);
        }
        return textRange;
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement elementToAnnotate, boolean isMisraInspection, @NotNull List<ClangTidyRange> additionalRanges) {
        if (elementToAnnotate == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(27);
        }
        if (additionalRanges == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(28);
        }
        if (isMisraInspection && additionalRanges.size() == 1) {
            ClangTidyRange range = additionalRanges.get(0);
            return new TextRange(range.getFileOffset(), range.getFileOffset() + Math.max(range.getLength(), 1));
        }
        return ClangTidyAnnotationApplier.getRangeToHighlight(elementToAnnotate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticProcessor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAnnotate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFail";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applySuccess";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProblemGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementToAnnotate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMakeSenseToHighlight";
                break;
            }
            case 21: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToHighlight";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface DiagnosticProcessor {
        public boolean processDiagnostic(@NotNull String var1, @NotNull String var2, @NotNull TextRange var3, @NotNull HighlightSeverity var4, @NotNull ClangTidyInspectionBase var5, @NotNull OCFile var6, @NotNull IntentionAction var7);
    }
}

