/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.stream.JsonWriter;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public final class ClangTidyUtil {
    @NlsSafe
    public static final String TOOL_NAME = "Clang-Tidy";
    public static final Pattern CLANG_TIDY_VERSION_PATTERN = Pattern.compile("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", 32);

    private ClangTidyUtil() {
    }

    @Nullable
    public static ClangTidyInspection getInspection(@Nullable PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(0);
        }
        return (tool = ClangTidyUtil.findTool(ClangTidyInspection.getInspectionShortName(), false, file, project)) instanceof ClangTidyInspection ? (ClangTidyInspection)tool : null;
    }

    @Nullable
    public static MisraInspection getMisraInspection(@NotNull PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (file == null) {
            ClangTidyUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(2);
        }
        return (tool = ClangTidyUtil.findTool(MisraInspection.Companion.getInspectionShortName(), false, file, project)) instanceof MisraInspection ? (MisraInspection)tool : null;
    }

    @Nullable
    public static ClazyInspection getClazyInspection(@NotNull PsiFile file, @NotNull Project project) {
        InspectionProfileEntry tool;
        if (file == null) {
            ClangTidyUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(4);
        }
        return (tool = ClangTidyUtil.findTool(ClazyInspection.getInspectionShortName(), false, file, project)) instanceof ClazyInspection ? (ClazyInspection)tool : null;
    }

    public static boolean isToolEnabled(LocalInspectionTool inspection, @Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(5);
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        return profile.isToolEnabled(HighlightDisplayKey.find((String)inspection.getID()), (PsiElement)file);
    }

    @NotNull
    public static List<OurClangTidyInspection> getOurInspections(boolean onlyEnabled, @NotNull PsiFile file, @NotNull Project project) {
        if (file == null) {
            ClangTidyUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(7);
        }
        List<InspectionToolWrapper<?, ?>> tools = ClangTidyUtil.findTools(onlyEnabled, file, project);
        ArrayList<OurClangTidyInspection> list = new ArrayList<OurClangTidyInspection>();
        for (InspectionToolWrapper<?, ?> tool : tools) {
            if (tool == null || !(tool.getTool() instanceof OurClangTidyInspection)) continue;
            OurClangTidyInspection toolTool = (OurClangTidyInspection)tool.getTool();
            list.add(toolTool);
        }
        ArrayList<OurClangTidyInspection> arrayList = list;
        if (arrayList == null) {
            ClangTidyUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public static ClangTidyInspectionBase findInspectionFromClangTidyDiagnostic(@NotNull ClangTidyDiagnostic diagnostic, @NotNull PsiFile file, @NotNull Project project) {
        if (diagnostic == null) {
            ClangTidyUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ClangTidyUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(11);
        }
        for (OurClangTidyInspection inspection : ClangTidyUtil.getOurInspections(false, file, project)) {
            if (!inspection.getCheckName().equals(diagnostic.getDiagnosticName())) continue;
            return inspection;
        }
        if (ClangTidyUtil.isMisraInspection(diagnostic)) {
            return ClangTidyUtil.getMisraInspection(file, project);
        }
        if (ClangTidyUtil.isClazyInspection(diagnostic)) {
            return ClangTidyUtil.getClazyInspection(file, project);
        }
        return ClangTidyUtil.getInspection(file, project);
    }

    private static boolean isMisraInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangTidyUtil.$$$reportNull$$$0(12);
        }
        return diagnostic.getDiagnosticName().startsWith("clion-misra-");
    }

    private static boolean isClazyInspection(@NotNull ClangTidyDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangTidyUtil.$$$reportNull$$$0(13);
        }
        return diagnostic.getDiagnosticName().startsWith("-Wclazy") || diagnostic.getDiagnosticName().startsWith("clazy");
    }

    @NotNull
    public static String enableCheck(@NotNull String configuration, @NotNull String checkName) {
        List<String> options;
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(14);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(15);
        }
        if (!ClangTidyUtil.isDisabled(options = ClangTidyUtil.getTrimmedOptions(configuration), checkName)) {
            String string = configuration;
            if (string == null) {
                ClangTidyUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        options.removeIf(option -> option.equals("-" + checkName));
        options.add(checkName);
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(18);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(19);
        }
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.equals(checkName));
        if (!ClangTidyUtil.isDisabled(options, checkName)) {
            options.add("-" + checkName);
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(21);
        }
        if (groupName == null) {
            ClangTidyUtil.$$$reportNull$$$0(22);
        }
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName));
        if (!ClangTidyUtil.isDisabled(options, groupName)) {
            options.add("-" + groupName + "-*");
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public static String getGroupNameForCheck(@NotNull String checkName) {
        int index;
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(24);
        }
        return (index = checkName.indexOf(45)) != -1 ? checkName.substring(0, index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        if (outputWriter == null) {
            ClangTidyUtil.$$$reportNull$$$0(25);
        }
        if (compilerExecutable == null) {
            ClangTidyUtil.$$$reportNull$$$0(26);
        }
        if (compilerWorkingDirectory == null) {
            ClangTidyUtil.$$$reportNull$$$0(27);
        }
        if (compilerOptions == null) {
            ClangTidyUtil.$$$reportNull$$$0(28);
        }
        if (inputFile == null) {
            ClangTidyUtil.$$$reportNull$$$0(29);
        }
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    public static List<String> getTrimmedOptions(@NotNull String configuration) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(30);
        }
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        return options;
    }

    public static boolean isDisabled(@NotNull List<String> options, @NotNull String checkName) {
        if (options == null) {
            ClangTidyUtil.$$$reportNull$$$0(31);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(32);
        }
        boolean disabled = false;
        for (String option : options) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (ClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!ClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            ClangTidyUtil.$$$reportNull$$$0(33);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(34);
        }
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            ClangTidyUtil.$$$reportNull$$$0(35);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(36);
        }
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        if (checks == null) {
            ClangTidyUtil.$$$reportNull$$$0(37);
        }
        if (checkOptions == null) {
            ClangTidyUtil.$$$reportNull$$$0(38);
        }
        String string = ClangUtils.getClangTidyConfig((String)checks, checkOptions);
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String concatClangTidyChecks(@NlsSafe @NotNull String checksA, @NlsSafe @NotNull String checksB) {
        if (checksA == null) {
            ClangTidyUtil.$$$reportNull$$$0(40);
        }
        if (checksB == null) {
            ClangTidyUtil.$$$reportNull$$$0(41);
        }
        List checks = ContainerUtil.concat((List)StringUtil.split((String)checksA, (String)","), (List)StringUtil.split((String)checksB, (String)","));
        String string = StringUtil.join((Collection)checks, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Nullable
    public static File getCustomClangTidyPath() {
        return (File)ApplicationManager.getApplication().runReadAction(() -> {
            ClangTidySettings settings = ClangTidySettings.getInstance();
            return settings != null && settings.getUseExternalClangTidy() && settings.getExternalClangTidyPath() != null ? new File(settings.getExternalClangTidyPath()) : null;
        });
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull OverlayMapping mapping) {
        if (mapping == null) {
            ClangTidyUtil.$$$reportNull$$$0(43);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<Map> roots = new ArrayList<Map>();
        for (File overlayFile : mapping.getOverlayFiles()) {
            File sourceFile = mapping.getSourceFile(overlayFile);
            if (sourceFile == null) continue;
            File parentDirectory = FileUtil.getParentFile((File)sourceFile);
            Map contents = ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)sourceFile.getName()), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"file"), Pair.create((Object)"external-contents", (Object)overlayFile.getAbsolutePath())});
            roots.add(ContainerUtil.newHashMap((Pair)Pair.create((Object)"name", (Object)(parentDirectory != null ? parentDirectory.getAbsolutePath() : "")), (Pair[])new Pair[]{Pair.create((Object)"type", (Object)"directory"), Pair.create((Object)"contents", (Object)new Object[]{contents})}));
        }
        data.put("version", "0");
        data.put("roots", roots.toArray());
        Yaml yaml = new Yaml();
        String string = yaml.dump(data);
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @Nullable
    private static InspectionProfileEntry findTool(@NotNull String inspectionId, boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        if (inspectionId == null) {
            ClangTidyUtil.$$$reportNull$$$0(45);
        }
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(46);
        }
        for (InspectionToolWrapper<?, ?> toolWrapper : ClangTidyUtil.findTools(onlyEnabled, file, project)) {
            if (toolWrapper == null || !toolWrapper.getID().equals(inspectionId)) continue;
            return toolWrapper.getTool();
        }
        return null;
    }

    @NotNull
    private static List<InspectionToolWrapper<?, ?>> findTools(boolean onlyEnabled, @Nullable PsiFile file, @NotNull Project project) {
        if (project == null) {
            ClangTidyUtil.$$$reportNull$$$0(47);
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        if (profile == null) {
            List<InspectionToolWrapper<?, ?>> list = Collections.emptyList();
            if (list == null) {
                ClangTidyUtil.$$$reportNull$$$0(48);
            }
            return list;
        }
        List wrappers = profile.getInspectionTools((PsiElement)file);
        if (!onlyEnabled) {
            List list = wrappers;
            if (list == null) {
                ClangTidyUtil.$$$reportNull$$$0(49);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        for (InspectionToolWrapper wrapper : wrappers) {
            if (wrapper == null || !profile.isToolEnabled(HighlightDisplayKey.find((String)wrapper.getID()), (PsiElement)file)) continue;
            list.add(wrapper);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            ClangTidyUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUtil";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 15: 
            case 19: 
            case 24: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputWriter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerOptions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksA";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checksB";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOurInspections";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "enableCheck";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "disableCheck";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "disableGroup";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyConfig";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "concatClangTidyChecks";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVfsOverlay";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMisraInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClazyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOurInspections";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findInspectionFromClangTidyDiagnostic";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMisraInspection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isClazyInspection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enableCheck";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "disableCheck";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "disableGroup";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNameForCheck";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "writeCompilationDatabase";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedOptions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckEnabled";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckDisabled";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "concatClangTidyChecks";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findTool";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findTools";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 39: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

