/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnusedIncludeDirectiveInspection
extends OCInspection
implements OCInspectionBase.CppMarker {
    private static final Logger LOG = Logger.getInstance((String)OCUnusedIncludeDirectiveInspection.class.getName());
    @NotNull
    public EliminateStrategy strategy = EliminateStrategy.RemoveNotDirectlyUsed;
    public boolean showInHeaders = false;

    public boolean isEnabledByDefault() {
        return PlatformUtils.isCLion();
    }

    public String getMainToolId() {
        return null;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = CidrLangBundle.message((String)"inspection.unused.code", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String @NotNull [] getGroupPath() {
        String[] stringArray = new String[]{CidrLangBundle.message((String)"c.cpp", (Object[])new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public String getStaticDescription() {
        return OCInspectionUtil.getStaticDescription((OCInspectionBase)this);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(2);
        }
        final Class inspectionClass = this.getInspectionClass();
        if (!OCInspectionUtil.isInspectionEnabled((Project)holder.getFile().getProject(), (Class)inspectionClass)) {
            return new PsiElementVisitor(){};
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (isOnTheFly) {
                    return;
                }
                if (!ClangUtils.isClangdOn((Project)file.getProject())) {
                    return;
                }
                if (!ClangdBridge.isSupported((Project)file.getProject(), (VirtualFile)file.getVirtualFile())) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)file.getProject());
                List<ClangDiagnostic> unusedDiagnostics = OCUnusedIncludeDirectiveInspection.getUnusedDiagnostics(service, file);
                if (!unusedDiagnostics.isEmpty()) {
                    Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                    if (document == null) {
                        return;
                    }
                    HighlightInfoHolder highlightInfos = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
                    for (ClangDiagnostic diag : unusedDiagnostics) {
                        HighlightInfo info = ClangErrorsAnnotatorPass.makeAnnotation((ClangIdeFacade)service.getClangIdeFacade(), (ClangDiagnostic)diag, (PsiFile)file, (Document)document, (HighlightInfoHolder)highlightInfos);
                        ProblemDescriptor descriptor = info == null ? null : ProblemDescriptorUtil.toProblemDescriptor((PsiFile)file, (HighlightInfo)info);
                        if (descriptor == null) continue;
                        OCInspection.registerProblem((ProblemsHolder)holder, null, null, (boolean)isOnTheFly, (PsiElement)descriptor.getStartElement(), (PsiElement)descriptor.getEndElement(), (String)info.getDescription(), (String)"CIDR", (ProblemHighlightType)ProblemHighlightType.LIKE_UNUSED_SYMBOL, (TextRange)new TextRange(info.startOffset, info.endOffset), (Class)inspectionClass, (IntentionAction[])IntentionAction.EMPTY_ARRAY);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection$2", "visitFile"));
            }
        };
    }

    @NotNull
    private static List<ClangDiagnostic> getUnusedDiagnostics(@NotNull ClangLanguageService service, @NotNull PsiFile file) {
        if (service == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        List list = (List)service.computeWithOpenedAndParsed(virtualFile, response -> {
            if (response != null) {
                try {
                    Supplier diagsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware((Future)response.getDiagnostics(), (long)Long.MAX_VALUE, (String)"unused include diagnostics");
                    if (diagsSupplier != null) {
                        List diagnostics2 = (List)diagsSupplier.get();
                        return diagnostics2 != null ? ContainerUtil.filter((Collection)diagnostics2, diag -> "clion_unused_include".equals(diag.getCode())) : Collections.emptyList();
                    }
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error((Throwable)e);
                }
            }
            return Collections.emptyList();
        });
        if (list == null) {
            OCUnusedIncludeDirectiveInspection.$$$reportNull$$$0(5);
        }
        return list;
    }

    public JComponent createOptionsPanel() {
        if (!PlatformUtils.isCLion()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel = new JPanel(new GridBagLayout());
        final ComboBox comboBox = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)ContainerUtil.map((Object[])EliminateStrategy.values(), opt -> opt.option)));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OCUnusedIncludeDirectiveInspection.this.strategy = EliminateStrategy.values()[comboBox.getSelectedIndex()];
            }
        });
        comboBox.setSelectedIndex(EliminateStrategy.indexOf(this.strategy));
        panel.add((Component)comboBox, bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        panel.add((Component)new CheckBox(OCInspectionsBundle.message((String)"unused.inspection.run.in.headers", (Object[])new Object[0]), (InspectionProfileEntry)this, "showInHeaders"), bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedDiagnostics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EliminateStrategy {
        RemoveCompletelyUnused("Detect completely unused"),
        RemoveNotDirectlyUsed("Detect not directly used"),
        RemoveNotRequired("Detect not required");

        @NotNull
        public final String option;

        private EliminateStrategy(String option) {
            if (option == null) {
                EliminateStrategy.$$$reportNull$$$0(0);
            }
            this.option = option;
        }

        static int indexOf(@NotNull EliminateStrategy opt) {
            if (opt == null) {
                EliminateStrategy.$$$reportNull$$$0(1);
            }
            int index = 0;
            for (EliminateStrategy strategy : EliminateStrategy.values()) {
                if (strategy == opt) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "opt";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCUnusedIncludeDirectiveInspection$EliminateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

