/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class JSQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    private static final TokenSet QUOTE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.BACKQUOTE, JSTokenTypes.STRING_TEMPLATE_PART, JSDocTokenTypes.STRING_LITERAL_HIGHLIGHTING})});

    protected JSQuoteHandler(TokenSet tokenSet) {
        super(tokenSet);
    }

    public JSQuoteHandler() {
        super(QUOTE_TOKENS);
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            JSQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JSQuoteHandler.$$$reportNull$$$0(1);
        }
        return JSTokenTypes.WHITE_SPACE == tokenType || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR || tokenType == JSDocTokenTypes.DOC_RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.GT || tokenType == JSTokenTypes.STRING_LITERAL || JSTokenTypes.XML_TOKENS.contains(tokenType) || tokenType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL;
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return false;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.isOpeningQuote(iterator, offset);
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            return true;
        }
        if (iterator.getTokenType() == JSTokenTypes.BACKQUOTE && !iterator.atEnd()) {
            iterator.advance();
            boolean result2 = iterator.atEnd() || iterator.getTokenType() != JSTokenTypes.BACKQUOTE;
            iterator.retreat();
            return result2;
        }
        return super.isClosingQuote(iterator, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

