/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependencyTreeLoader;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspaceList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpFile {
    private static final Logger LOG = Logger.getInstance(YarnPnpFile.class);
    private final VirtualFile myPnpFile;
    private final Project myProject;
    private volatile YarnPnpWorkspaceList myWorkspaceList;
    private final AtomicBoolean myRefreshing;

    YarnPnpFile(@NotNull VirtualFile pnpJsFile, @NotNull Project project) {
        if (pnpJsFile == null) {
            YarnPnpFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            YarnPnpFile.$$$reportNull$$$0(1);
        }
        this.myRefreshing = new AtomicBoolean(false);
        this.myPnpFile = pnpJsFile;
        this.myProject = project;
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            YarnPnpFile.$$$reportNull$$$0(2);
        }
        return project;
    }

    boolean refresh() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread(), (Object)"Shouldn't be invoked in EDT");
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Shouldn't be invoked under read action");
        if (this.myRefreshing.compareAndSet(false, true)) {
            YarnPnpWorkspaceList oldWorkspaceList;
            boolean changed;
            YarnPnpWorkspaceList newWorkspaceList = this.loadWorkspaceList();
            if (newWorkspaceList != null) {
                newWorkspaceList.calcLibraryNames(this.myProject);
            }
            boolean bl = changed = !Objects.equals(oldWorkspaceList = this.myWorkspaceList, newWorkspaceList);
            if (changed) {
                this.myWorkspaceList = newWorkspaceList;
            }
            this.myRefreshing.set(false);
            return changed;
        }
        return false;
    }

    @Nullable
    private YarnPnpWorkspaceList loadWorkspaceList() {
        try {
            return YarnPnpDependencyTreeLoader.load(this.myProject, this.myPnpFile);
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        return null;
    }

    @NotNull
    public VirtualFile getPnpFile() {
        VirtualFile virtualFile = this.myPnpFile;
        if (virtualFile == null) {
            YarnPnpFile.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    YarnPnpWorkspaceList getWorkspaceList() {
        return this.myWorkspaceList;
    }

    void setWorkspaceList(@NotNull YarnPnpWorkspaceList workspaceList) {
        if (workspaceList == null) {
            YarnPnpFile.$$$reportNull$$$0(4);
        }
        this.myWorkspaceList = workspaceList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpJsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWorkspaceList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

