/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmsIoService {
    private NpmsIoService() {
    }

    @Nullable
    public static NpmRegistryService.SearchQuery createSearchQuery(final @NotNull String text, boolean preferSuggestions) {
        Pair<String, String> scopeAndName;
        if (text == null) {
            NpmsIoService.$$$reportNull$$$0(0);
        }
        if ((scopeAndName = NpmsIoService.parseScopeAndName(text)) == null) {
            return null;
        }
        final boolean suggestions = preferSuggestions && scopeAndName.first == null;
        return new NpmRegistryService.SearchQuery(text){

            @Override
            @NotNull
            public String getQueryUrl(int from, int limit) {
                if (suggestions) {
                    String string = "https://api.npms.io/v2/search/suggestions?q=" + URLUtil.encodeURIComponent((String)text) + "&size=" + (from + limit);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String query = scopeAndName.first != null ? "scope:" + (String)scopeAndName.first + " " + (String)scopeAndName.second : (String)scopeAndName.second;
                String string = "https://api.npms.io/v2/search?q=" + URLUtil.encodeURIComponent((String)query) + "&from=" + from + "&size=" + limit;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public int getMaxQueryBatchSize() {
                return 100;
            }

            @Override
            @NotNull
            public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
                if (content == null) {
                    1.$$$reportNull$$$0(2);
                }
                JsonReader reader = new JsonReader((Reader)new StringReader(content));
                List<NodePackageBasicInfo> list2 = new SearchResultsReader(reader, suggestions).read();
                List<NodePackageBasicInfo> list3 = list2;
                if (list3 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list3;
                finally {
                    reader.close();
                }
            }

            public String toString() {
                return "'" + text + "*' (Prefix)";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQueryUrl";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseContent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "parseContent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    private static Pair<String, String> parseScopeAndName(@NotNull String text) {
        int slashInd;
        if (text == null) {
            NpmsIoService.$$$reportNull$$$0(1);
        }
        if (text.startsWith("@") && (slashInd = text.indexOf(47, 1)) != -1) {
            String scope = text.substring(1, slashInd);
            String name = text.substring(Math.min(slashInd + 1, text.length()));
            if (name.length() < 4) {
                return null;
            }
            return Pair.create((Object)scope, (Object)name);
        }
        return Pair.create(null, (Object)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "text";
        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSearchQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseScopeAndName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SearchResultsReader {
        private final JsonReader myReader;
        private final boolean mySuggestions;
        private final List<NodePackageBasicInfo> myResults;

        SearchResultsReader(@NotNull JsonReader reader, boolean suggestions) {
            if (reader == null) {
                SearchResultsReader.$$$reportNull$$$0(0);
            }
            this.myResults = new ArrayList<NodePackageBasicInfo>();
            this.myReader = reader;
            this.mySuggestions = suggestions;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (!this.mySuggestions) {
                if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                    this.myReader.skipValue();
                    List<NodePackageBasicInfo> list2 = Collections.emptyList();
                    if (list2 == null) {
                        SearchResultsReader.$$$reportNull$$$0(1);
                    }
                    return list2;
                }
                this.myReader.beginObject();
                while (this.myReader.hasNext()) {
                    String name = this.myReader.nextName();
                    if ("results".equals(name)) {
                        this.readSearchResults();
                        continue;
                    }
                    this.myReader.skipValue();
                }
                this.myReader.endObject();
            } else {
                this.readSearchResults();
            }
            ImmutableList immutableList = ImmutableList.copyOf(this.myResults);
            if (immutableList == null) {
                SearchResultsReader.$$$reportNull$$$0(2);
            }
            return immutableList;
        }

        private void readSearchResults() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readPackageProp();
            }
            this.myReader.endArray();
        }

        private void readPackageProp() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String propName = this.myReader.nextName();
                if ("package".equals(propName)) {
                    ContainerUtil.addIfNotNull(this.myResults, (Object)NpmRegistryServiceImpl.readPackageInfo(this.myReader));
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$SearchResultsReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/NpmsIoService$SearchResultsReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

