/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.lang.javascript.bower.cache.PrevRequestSkippingCache;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfoManager {
    private final NodeJsInterpreter myInterpreter;
    private final PrevRequestSkippingCache<String, NodePackageInfo> myCache;

    public NodePackageInfoManager(final @NotNull Project project, @NotNull NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackageInfoManager.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            NodePackageInfoManager.$$$reportNull$$$0(1);
        }
        this.myInterpreter = interpreter;
        this.myCache = new PrevRequestSkippingCache<String, NodePackageInfo>(new PrevRequestSkippingCache.Fetcher<String, NodePackageInfo>(){

            @Override
            @Nullable
            public NodePackageInfo fetch(@NotNull String packageName) throws Exception {
                if (packageName == null) {
                    1.$$$reportNull$$$0(0);
                }
                return NodePackageUtil.loadPackageInfo(project, NodePackageInfoManager.this.myInterpreter, packageName, false, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/settings/NodePackageInfoManager$1", "fetch"));
            }
        });
    }

    public void fetchPackageInfo(final @NotNull PackageInfoConsumer packageInfoConsumer) {
        if (packageInfoConsumer == null) {
            NodePackageInfoManager.$$$reportNull$$$0(2);
        }
        String packageName = packageInfoConsumer.myPackageName;
        boolean canBeSkipped = packageInfoConsumer.myCanBeSkipped;
        PrevRequestSkippingCache.FetchCallback<String, NodePackageInfo> callback = new PrevRequestSkippingCache.FetchCallback<String, NodePackageInfo>(packageName, canBeSkipped){

            @Override
            public void onSuccess(@Nullable NodePackageInfo packageInfo) {
                packageInfoConsumer.onPackageInfo(packageInfo);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                packageInfoConsumer.onException(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/nodejs/settings/NodePackageInfoManager$2", "onException"));
            }
        };
        this.myCache.fetch(callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageInfoConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodePackageInfoManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchPackageInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class PackageInfoConsumer {
        private final String myPackageName;
        private final boolean myCanBeSkipped;

        public PackageInfoConsumer(@NotNull String packageName) {
            if (packageName == null) {
                PackageInfoConsumer.$$$reportNull$$$0(0);
            }
            this(packageName, true);
        }

        public PackageInfoConsumer(@NotNull String packageName, boolean canBeSkipped) {
            if (packageName == null) {
                PackageInfoConsumer.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myCanBeSkipped = canBeSkipped;
        }

        public abstract void onPackageInfo(@Nullable NodePackageInfo var1);

        public abstract void onException(@NotNull Exception var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/settings/NodePackageInfoManager$PackageInfoConsumer", "<init>"));
        }
    }
}

