/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsView;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "settings.nodejs";
    private final Project myProject;
    private final VirtualFile myRequestor;
    private final boolean myOneClickConfiguration;
    private NodeSettingsView myView;
    private final NodeJsInterpreterManager myInterpreterManager;
    private final NpmManager myNpmManager;

    public NodeSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null, false);
    }

    public NodeSettingsConfigurable(@NotNull Project project, @Nullable VirtualFile requestor, boolean oneClickConfiguration) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRequestor = requestor;
        this.myOneClickConfiguration = oneClickConfiguration;
        this.myInterpreterManager = NodeJsInterpreterManager.getInstance(project);
        this.myNpmManager = NpmManager.getInstance(project);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message("settings.nodejs.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        NodeSettingsView view;
        this.myView = view = new NodeSettingsView(this.myProject, this.myRequestor, this.myOneClickConfiguration);
        return view.getComponent();
    }

    public boolean isModified() {
        NodeSettingsView view = this.myView;
        if (view == null) {
            return false;
        }
        NodeJsInterpreterRef prevInterpreter = this.myInterpreterManager.getInterpreterRef();
        NodeJsInterpreterRef nextInterpreter = view.getInterpreterRef();
        NodePackageRef prevPmPackageRef = this.myNpmManager.getPackageRef();
        NodePackageRef nextPmPackageRef = view.getPackageManagerPackageRef();
        return !prevInterpreter.equals(nextInterpreter) || !prevPmPackageRef.equals(nextPmPackageRef);
    }

    public void apply() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            NodeJsInterpreterRef oldInterpreterRef = this.myInterpreterManager.getInterpreterRef();
            NodeJsInterpreterRef newInterpreterRef = view.getInterpreterRef();
            this.myInterpreterManager.setInterpreterRef(newInterpreterRef);
            NodePackageRef oldNpmRef = this.myNpmManager.getPackageRef();
            NodePackageRef newNpmRef = view.getPackageManagerPackageRef();
            this.myNpmManager.setPackageRef(newNpmRef);
            if (!oldInterpreterRef.equals(newInterpreterRef) || !oldNpmRef.equals(newNpmRef)) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
        }
    }

    public void reset() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            view.setInterpreterRef(this.myInterpreterManager.getInterpreterRef());
            view.setPackageManagerPackageRef(this.myNpmManager.getPackageRef());
        }
    }

    public static void showSettingsDialog(@NotNull Project project) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, NodeSettingsConfigurable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeSettingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showSettingsDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

