/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileIndexingHandler
extends FrameworkIndexingHandler {
    private static final Key<Boolean> IS_TEST_FILE = Key.create((String)(JSFile.class.getSimpleName() + " isTestFile"));
    private static final FileAttribute IS_TEST_FILE_ATTRIBUTE = new FileAttribute("javascript.file.is.test", 1, true);

    @Override
    public void processFile(@NotNull JSFile psiFile, @NotNull JSFileCachedData data) {
        VirtualFile file2;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(0);
        }
        if (data == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(1);
        }
        if ((file2 = JsTestFileIndexingHandler.getLocalFileToProcess(psiFile)) != null) {
            JSTestFileType testFileType = JsTestFileIndexingHandler.getTestFileType(psiFile);
            JsTestFileIndexingHandler.setIsTestFile(file2, testFileType != null);
            data.setTestFileType(testFileType);
        }
    }

    @Nullable
    private static VirtualFile getLocalFileToProcess(@NotNull JSFile psiFile) {
        VirtualFile file2;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(2);
        }
        if ((file2 = psiFile.getViewProvider().getVirtualFile()) instanceof LightVirtualFile) {
            file2 = ((LightVirtualFile)file2).getOriginalFile();
        }
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file2, (long)0x100000L)) {
            return null;
        }
        if (JSLibraryUtil.isProbableLibraryFile(file2)) {
            return null;
        }
        if (TypeScriptUtil.isDefinitionFile(file2)) {
            return null;
        }
        return file2;
    }

    @Nullable
    private static JSTestFileType getTestFileType(@NotNull JSFile psiFile) {
        JasmineFileStructure jasmine;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(3);
        }
        if (!(jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile)).isEmpty()) {
            return JSTestFileType.JASMINE;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!qunit.isEmpty()) {
            return JSTestFileType.QUNIT;
        }
        MochaTddFileStructure tdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!tdd.isEmpty()) {
            return JSTestFileType.TDD;
        }
        return null;
    }

    private static void setIsTestFile(@NotNull VirtualFile file2, @Nullable Boolean isTestFile) {
        Boolean prevValue;
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(4);
        }
        if (!Objects.equals(prevValue = (Boolean)file2.getUserData(IS_TEST_FILE), isTestFile)) {
            file2.putUserData(IS_TEST_FILE, (Object)isTestFile);
            JsTestFileIndexingHandler.writeIsTestFileAttribute(file2, isTestFile);
        }
    }

    public static boolean isTestFile(@NotNull VirtualFile file2, @NotNull Project project) {
        JSFileCachedData data;
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(6);
        }
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        Boolean isTestFileCached = (Boolean)file2.getUserData(IS_TEST_FILE);
        if (isTestFileCached != null) {
            return isTestFileCached;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file2));
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        Boolean isTestFileFromAttr = JsTestFileIndexingHandler.readIsTestFileAttribute(file2);
        if (isTestFileFromAttr != null) {
            file2.putUserData(IS_TEST_FILE, (Object)isTestFileFromAttr);
            return isTestFileFromAttr;
        }
        if (psiFile instanceof JSFileBaseImpl && (data = ((JSFileBaseImpl)psiFile).tryGetCachedData()) != null) {
            boolean isTestFile = data.getTestFileType() != null;
            JsTestFileIndexingHandler.setIsTestFile(file2, isTestFile);
            return isTestFile;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Boolean readIsTestFileAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(7);
        }
        try (DataInputStream inputStream = IS_TEST_FILE_ATTRIBUTE.readAttribute(file2);){
            if (inputStream == null) return null;
            Boolean bl = inputStream.readBoolean();
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void writeIsTestFileAttribute(@NotNull VirtualFile file2, @Nullable Boolean isTestFile) {
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(8);
        }
        try (DataOutputStream outputStream = IS_TEST_FILE_ATTRIBUTE.writeAttribute(file2);){
            if (isTestFile != null) {
                outputStream.writeBoolean(isTestFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void processFile(@NotNull JSFile file2, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(9);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(10);
        }
        if (JsTestFileIndexingHandler.getLocalFileToProcess(file2) == null) {
            return;
        }
        for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            JsTestFileIndexingHandler.putTestFileStructure(file2, indexBuilder, builder);
        }
    }

    @NotNull
    public static Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> getFileStructureBuilders() {
        List<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> list2 = Arrays.asList(JasmineFileStructureBuilder.getInstance(), QUnitFileStructureBuilder.getInstance(), MochaTddFileStructureBuilder.getInstance());
        if (list2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static <T extends AbstractTestFileStructure> void putTestFileStructure(@NotNull JSFile file2, @NotNull JSIndexContentBuilder indexBuilder, @NotNull AbstractTestFileStructureBuilder<T> builder) {
        if (file2 == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(12);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(14);
        }
        T testStructure = builder.buildTestFileStructure(file2);
        indexBuilder.putAdditionalData(builder.KEY, testStructure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/JsTestFileIndexingHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileIndexingHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructureBuilders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFileToProcess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestFileType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setIsTestFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTestFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readIsTestFileAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeIsTestFileAttribute";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putTestFileStructure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

